/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.kernel;

import com.google.common.base.Preconditions;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.kernel.FastMove;
import org.apache.jackrabbit.oak.kernel.KernelRootBuilder;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class KernelNodeBuilder
extends MemoryNodeBuilder
implements FastMove {
    private final KernelRootBuilder root;
    private NodeState base = null;
    private NodeState rootBase = null;

    KernelNodeBuilder(MemoryNodeBuilder parent, String name, KernelRootBuilder root) {
        super(parent, name);
        this.root = (KernelRootBuilder)Preconditions.checkNotNull((Object)root);
    }

    @Override
    protected MemoryNodeBuilder createChildBuilder(String name) {
        return new KernelNodeBuilder(this, name, this.root);
    }

    @Override
    public NodeState getBaseState() {
        if (this.base == null || this.rootBase != this.root.getBaseState()) {
            this.base = this.getParent().getBaseState().getChildNode(this.getName());
            this.rootBase = this.root.getBaseState();
        }
        return this.base;
    }

    @Override
    public void reset(NodeState newBase) {
        throw new IllegalStateException("Cannot reset a non-root builder");
    }

    @Override
    public boolean moveTo(NodeBuilder newParent, String newName) {
        if (newParent instanceof FastMove) {
            Preconditions.checkNotNull((Object)newParent);
            AbstractNodeState.checkValidName(newName);
            this.annotateSourcePath();
            boolean success = !this.isRoot() && this.exists() && !newParent.hasChildNode(newName) && ((FastMove)((Object)newParent)).moveFrom(this, newName);
            return success;
        }
        return super.moveTo(newParent, newName);
    }

    @Override
    public boolean moveFrom(KernelNodeBuilder source, String newName) {
        String sourcePath = source.getPath();
        String destPath = PathUtils.concat((String)this.getPath(), (String)newName);
        return this.root.move(sourcePath, destPath);
    }
}

