/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query.parser;

import com.hp.hpl.jena.rdf.query.EvalFailureException;
import com.hp.hpl.jena.rdf.query.Query;
import com.hp.hpl.jena.rdf.query.QueryFormatUtils;
import com.hp.hpl.jena.rdf.query.ResultBinding;
import com.hp.hpl.jena.rdf.query.Value;
import com.hp.hpl.jena.rdf.query.ValueException;
import com.hp.hpl.jena.rdf.query.parser.Expr;
import com.hp.hpl.jena.rdf.query.parser.RDQLParser;
import com.hp.hpl.jena.rdf.query.parser.SimpleNode;
import java.io.PrintWriter;

public class Literal
extends SimpleNode
implements Value,
Expr {
    boolean isSet = false;
    boolean isInt = false;
    boolean isBoolean = false;
    boolean isLong = false;
    boolean isURI = false;
    boolean isString = false;
    int valInt;
    boolean valBoolean;
    long valLong;
    String valString;
    String valURI;

    Literal(int n) {
        super(n);
    }

    Literal(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    protected void unset() {
        this.isSet = false;
        if (this.isString) {
            this.valString = null;
        }
        if (this.isURI) {
            this.valURI = null;
        }
        this.isInt = false;
        this.isBoolean = false;
        this.isLong = false;
        this.isURI = false;
        this.isString = false;
    }

    public Value eval(Query query, ResultBinding resultBinding) {
        if (!this.isSet) {
            throw new EvalFailureException("Literal value not set");
        }
        return this;
    }

    public boolean isSet() {
        return this.isSet;
    }

    public boolean isNumber() {
        return this.isSet && (this.isInt || this.isLong);
    }

    public boolean isInt() {
        return this.isSet && this.isInt;
    }

    public boolean isLong() {
        return this.isSet && this.isLong;
    }

    public boolean isBoolean() {
        return this.isSet && this.isBoolean;
    }

    public boolean isString() {
        return this.isSet && this.isString;
    }

    public boolean isURI() {
        return this.isSet && this.isURI;
    }

    protected void setInt(int n) {
        this.unset();
        this.isSet = true;
        this.isInt = true;
        this.valInt = n;
    }

    protected void setLong(long l) {
        this.unset();
        this.isSet = true;
        this.isLong = true;
        this.valLong = l;
    }

    protected void setBoolean(boolean bl) {
        this.unset();
        this.isSet = true;
        this.isBoolean = true;
        this.valBoolean = bl;
    }

    protected void setString(String string) {
        this.unset();
        this.isSet = true;
        this.isString = true;
        this.valString = string;
    }

    protected void setURI(String string) {
        this.unset();
        this.isSet = true;
        this.isURI = true;
        this.isString = true;
        this.valURI = string;
        this.valString = string;
    }

    public int getInt() {
        if (!this.isSet || !this.isInt) {
            throw new ValueException("Not an int: " + this);
        }
        return this.valInt;
    }

    public long getLong() {
        if (!this.isSet || !this.isLong) {
            throw new ValueException("Not a long: " + this);
        }
        return this.valLong;
    }

    public boolean getBoolean() {
        if (!this.isSet || !this.isBoolean) {
            throw new ValueException("Not a boolean: " + this);
        }
        return this.valBoolean;
    }

    public String getString() {
        if (!this.isSet || !this.isString) {
            throw new ValueException("Not a string: " + this);
        }
        return this.valString;
    }

    public String getURI() {
        if (!this.isSet || !this.isURI) {
            throw new ValueException("Not a URI: " + this);
        }
        return this.valURI;
    }

    public String asQuotedString() {
        if (!this.isSet) {
            return "literal:unset";
        }
        if (this.isInt) {
            return Integer.toString(this.valInt);
        }
        if (this.isLong) {
            return Long.toString(this.valLong);
        }
        if (this.isBoolean) {
            return this.valBoolean ? "true" : "false";
        }
        if (this.isURI) {
            return "<" + this.valURI + ">";
        }
        if (this.isString) {
            return "\"" + this.valString + "\"";
        }
        return "literal:unknown";
    }

    public String asUnquotedString() {
        if (!this.isSet) {
            return "literal:unset";
        }
        if (this.isInt) {
            return Integer.toString(this.valInt);
        }
        if (this.isLong) {
            return Long.toString(this.valLong);
        }
        if (this.isBoolean) {
            return this.valBoolean ? "true" : "false";
        }
        if (this.isURI) {
            return this.valURI;
        }
        if (this.isString) {
            return this.valString;
        }
        return "literal:unknown";
    }

    public String asInfixString() {
        return this.asQuotedString();
    }

    public String asPrefixString() {
        if (!this.isSet) {
            return "literal:unset";
        }
        if (this.isInt) {
            return "int:" + Integer.toString(this.valInt);
        }
        if (this.isLong) {
            return "long:" + Long.toString(this.valLong);
        }
        if (this.isBoolean) {
            return "boolean:" + (this.valBoolean ? "true" : "false");
        }
        if (this.isURI) {
            return "URI:" + this.valURI;
        }
        if (this.isString) {
            return "string:" + this.valString;
        }
        return "literal:unknown";
    }

    public void print(PrintWriter printWriter, int n) {
        QueryFormatUtils.indent(printWriter, n);
        printWriter.println(this.asPrefixString());
    }

    public String toString() {
        return this.asUnquotedString();
    }
}

