/*
 * Decompiled with CFR 0.152.
 */
package org.jfile.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.jfile.exceptions.InvalidMagicFileHeaderException;
import org.jfile.exceptions.InvalidMagicFileSectionHeaderException;
import org.jfile.model.Magic;
import org.jfile.model.MagicSection;
import org.jfile.util.Parser;

public class MagicParser
implements Parser<Magic> {
    public static final String MAGIC_FILE_HEADER = "MIME-Magic\u0000\n";
    public static final String MAGIC_FILE_LOCATION = "org/jfile/resources/magic";
    public static int OFFSET_MASK = 2;
    public static int LENGTH_MASK = 4;
    public static int VALUE_MASK = 8;

    @Override
    public TreeMap<Integer, List<Magic>> parse() throws IOException, InvalidMagicFileHeaderException, InvalidMagicFileSectionHeaderException {
        URL url = MagicParser.class.getClassLoader().getResource(MAGIC_FILE_LOCATION);
        return this.parse(new File(url.getPath()));
    }

    @Override
    public TreeMap<Integer, List<Magic>> parse(File magicFile) throws IOException, InvalidMagicFileHeaderException, InvalidMagicFileSectionHeaderException {
        RandomAccessFile raf = null;
        TreeMap<Integer, List<Magic>> magics = new TreeMap<Integer, List<Magic>>();
        try {
            raf = new RandomAccessFile(magicFile, "r");
            String header = raf.readLine();
            if (header.equals(MAGIC_FILE_HEADER)) {
                throw new InvalidMagicFileHeaderException("Invalid Magic File Header");
            }
            int c = raf.read();
            while (c == 91) {
                String sectionHeader = raf.readLine();
                if (!sectionHeader.endsWith("]")) {
                    throw new InvalidMagicFileSectionHeaderException("Invalid Section header");
                }
                String[] tokens = sectionHeader.substring(0, sectionHeader.length() - 1).split(":");
                if (tokens.length != 2) {
                    throw new InvalidMagicFileSectionHeaderException("Invalid priority or type");
                }
                Magic magic = new Magic();
                magic.setPriority(Integer.parseInt(tokens[0]));
                magic.setType(tokens[1]);
                magic.setSections(MagicParser.parseSections(raf));
                List<Magic> list = magics.get(magic.getPriority());
                if (list == null) {
                    list = new ArrayList<Magic>();
                    magics.put(magic.getPriority(), list);
                }
                list.add(magic);
                c = raf.read();
            }
            TreeMap<Integer, List<Magic>> treeMap = magics;
            return treeMap;
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    private static List<MagicSection> parseSections(RandomAccessFile raf) throws IOException, InvalidMagicFileSectionHeaderException {
        ArrayList<MagicSection> previous = new ArrayList<MagicSection>();
        MagicSection section = new MagicSection();
        ArrayList<MagicSection> sections = new ArrayList<MagicSection>();
        int c = raf.read();
        int required = 0;
        while (c != 91 && c != -1) {
            byte[] buf;
            int len;
            if (Character.isDigit(c)) {
                raf.seek(raf.getFilePointer() - 1L);
                section.setIndent(MagicParser.readStringAsInt(raf));
                c = raf.read();
            }
            if (c == 62) {
                section.setOffset(MagicParser.readStringAsInt(raf));
                required |= OFFSET_MASK;
                c = raf.read();
            }
            if (c == 61) {
                len = raf.readUnsignedShort();
                section.setLength(len);
                buf = new byte[len];
                raf.read(buf, 0, len);
                section.setValue(buf);
                c = raf.read();
                required |= LENGTH_MASK;
                required |= VALUE_MASK;
            }
            if (c == 38) {
                len = section.getLength();
                buf = new byte[len];
                raf.read(buf, 0, len);
                section.setMask(buf);
                c = raf.read();
            }
            if (c == 126) {
                section.setWordSize(MagicParser.readStringAsInt(raf));
                c = raf.read();
            }
            if (c == 43) {
                section.setRangeLength(MagicParser.readStringAsInt(raf));
                c = raf.read();
            }
            if (c == 10 && (required & LENGTH_MASK) != 0 && (required & OFFSET_MASK) != 0 && (required & VALUE_MASK) != 0) {
                if (section.getMask() == null) {
                    byte[] buf2 = new byte[section.getLength()];
                    int len2 = section.getLength();
                    int i = 0;
                    while (i < len2) {
                        buf2[i] = -1;
                        ++i;
                    }
                    section.setMask(buf2);
                }
                if (section.getIndent() > 0) {
                    MagicSection parent = MagicParser.findParent(previous, section.getIndent());
                    if (parent != null) {
                        if (parent.getSubSections() == null) {
                            parent.setSubSections(new ArrayList<MagicSection>());
                        }
                        parent.getSubSections().add(section);
                    }
                } else {
                    sections.add(section);
                }
                previous.add(section);
            } else {
                System.out.println("Invalid section");
                while (c != 10 && c != -1) {
                    c = raf.read();
                }
            }
            section = new MagicSection();
            c = raf.read();
        }
        raf.seek(raf.getFilePointer() - 1L);
        return sections;
    }

    private static MagicSection findParent(List<MagicSection> previous, int indent) {
        int maxIndex = previous.size() - 1;
        int parentIndent = indent - 1;
        int i = maxIndex;
        while (i >= 0) {
            MagicSection ms = previous.get(i);
            if (ms.getIndent() == parentIndent) {
                return ms;
            }
            --i;
        }
        return null;
    }

    private static Integer readStringAsInt(RandomAccessFile raf) throws IOException {
        int c;
        StringBuffer buf = new StringBuffer();
        while (Character.isDigit(c = raf.read())) {
            buf.append((char)c);
        }
        Integer retVal = Integer.parseInt(buf.toString());
        raf.seek(raf.getFilePointer() - 1L);
        return retVal;
    }
}

