/*
 * Decompiled with CFR 0.152.
 */
package com.germinus.easyconf;

import com.germinus.easyconf.ComponentConfiguration;
import com.germinus.easyconf.ConfigurationException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EasyConf {
    private static final Log log = LogFactory.getLog((Class)(class$com$germinus$easyconf$EasyConf == null ? (class$com$germinus$easyconf$EasyConf = EasyConf.class$("com.germinus.easyconf.EasyConf")) : class$com$germinus$easyconf$EasyConf));
    private static Map cache = new HashMap();
    static /* synthetic */ Class class$com$germinus$easyconf$EasyConf;

    private EasyConf() {
    }

    public static ComponentConfiguration getConfiguration(String componentName) {
        try {
            ComponentConfiguration componentConf = (ComponentConfiguration)cache.get(componentName);
            if (componentConf == null) {
                componentConf = new ComponentConfiguration(componentName);
                cache.put(componentName, componentConf);
            }
            return componentConf;
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(componentName, "Error reading the configuration", e);
        }
    }

    public static ComponentConfiguration getConfiguration(String companyId, String componentName) {
        try {
            String cacheKey = companyId + componentName;
            ComponentConfiguration componentConf = (ComponentConfiguration)cache.get(cacheKey);
            if (componentConf == null) {
                componentConf = new ComponentConfiguration(companyId, componentName);
                cache.put(cacheKey, componentConf);
            }
            return componentConf;
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(componentName, "Error reading the configuration for " + companyId, e);
        }
    }

    public static void refreshComponent(String componentName) {
        ComponentConfiguration componentConf = (ComponentConfiguration)cache.get(componentName);
        if (componentConf != null) {
            cache.remove(componentName);
            log.info((Object)("Refreshed the configuration of component " + componentName));
        }
    }

    public static void refreshAll() {
        cache = new HashMap();
        log.info((Object)"Refreshed the configuration of all components");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

