/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.Colormap;
import com.jhlabs.image.ImageMath;
import com.jhlabs.image.LinearColormap;
import com.jhlabs.image.PixelUtils;
import com.jhlabs.image.WholeImageFilter;

public class ShapeFilter
extends WholeImageFilter {
    public static final int LINEAR = 0;
    public static final int CIRCLE_UP = 1;
    public static final int CIRCLE_DOWN = 2;
    public static final int SMOOTH = 3;
    private double factor = 1.0;
    protected Colormap colormap = new LinearColormap();
    private boolean useAlpha = true;
    private boolean invert = false;
    private int type;
    private static final float one = 1.0f;
    private static final float sqrt2 = (float)Math.sqrt(2.0);
    private static final float sqrt5 = (float)Math.sqrt(5.0);

    public void setFactor(double d) {
        this.factor = d;
    }

    public double getFactor() {
        return this.factor;
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public void setUseAlpha(boolean bl) {
        this.useAlpha = bl;
    }

    public boolean getUseAlpha() {
        return this.useAlpha;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public void setInvert(boolean bl) {
        this.invert = bl;
    }

    public boolean getInvert() {
        return this.invert;
    }

    public void imageComplete(int n) {
        if (n == 1 || n == 4) {
            this.consumer.imageComplete(n);
            return;
        }
        try {
            int n2 = this.originalSpace.width;
            int n3 = this.originalSpace.height;
            float[] fArray = new float[n2 * n3];
            this.makeMap(this.inPixels, fArray, n2, n3);
            float f = this.distanceMap(fArray, n2, n3);
            this.applyMap(fArray, this.inPixels, n2, n3, f);
            this.consumer.setPixels(0, 0, n2, n3, this.defaultRGBModel, this.inPixels, 0, n2);
            this.consumer.imageComplete(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public float distanceMap(float[] fArray, int n, int n2) {
        float f;
        int n3;
        int n4;
        int n5 = n - 3;
        int n6 = n2 - 3;
        float f2 = 0.0f;
        int n7 = 0;
        while (n7 < n2) {
            n4 = 0;
            while (n4 < n) {
                n3 = n4 + n7 * n;
                if (fArray[n3] > 0.0f && (f = n4 < 2 || n4 > n5 || n7 < 2 || n7 > n6 ? this.setEdgeValue(n4, n7, fArray, n, n3, n5, n6) : this.setValue(fArray, n, n3)) > f2) {
                    f2 = f;
                }
                ++n4;
            }
            ++n7;
        }
        n4 = n2 - 1;
        while (n4 >= 0) {
            n3 = n - 1;
            while (n3 >= 0) {
                int n8 = n3 + n4 * n;
                if (fArray[n8] > 0.0f && (f = n3 < 2 || n3 > n5 || n4 < 2 || n4 > n6 ? this.setEdgeValue(n3, n4, fArray, n, n8, n5, n6) : this.setValue(fArray, n, n8)) > f2) {
                    f2 = f;
                }
                --n3;
            }
            --n4;
        }
        return f2;
    }

    private void makeMap(int[] nArray, float[] fArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                float f;
                int n5 = n4 + n3 * n;
                fArray[n5] = f = (float)(this.useAlpha ? nArray[n5] >> 24 & 0xFF : (PixelUtils.brightness(nArray[n5]) > 127 ? 255 : 0));
                ++n4;
            }
            ++n3;
        }
    }

    private void applyMap(float[] fArray, int[] nArray, int n, int n2, float f) {
        if (f == 0.0f) {
            f = 1.0f;
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                int n5 = n4 + n3 * n;
                float f2 = fArray[n5];
                if (this.colormap == null) {
                    if (f2 != 0.0f) {
                        int n6 = (int)(255.0 * this.factor * (double)f2);
                        if (n6 > 255) {
                            n6 = 255;
                        }
                        nArray[n5] = 0xFF000000 | n6 << 16 | n6 << 8 | n6;
                    } else {
                        nArray[n5] = 0;
                    }
                } else if (f2 != 0.0f) {
                    double d = ImageMath.clamp(this.factor * (double)f2 / (double)f, 0.0, 1.0);
                    switch (this.type) {
                        case 1: {
                            d = ImageMath.circleUp(d);
                            break;
                        }
                        case 2: {
                            d = ImageMath.circleDown(d);
                            break;
                        }
                        case 3: {
                            d = ImageMath.smoothStep(0.0, 1.0, d);
                            break;
                        }
                    }
                    if (this.invert) {
                        d = 1.0 - d;
                    }
                    nArray[n5] = this.colormap.getColor(d);
                } else {
                    nArray[n5] = 0;
                }
                ++n4;
            }
            ++n3;
        }
    }

    private float setEdgeValue(int n, int n2, float[] fArray, int n3, int n4, int n5, int n6) {
        float f;
        int n7 = n4 - n3 - n3 - 2;
        int n8 = n7 + n3;
        int n9 = n8 + n3;
        int n10 = n9 + n3;
        int n11 = n10 + n3;
        float f2 = fArray[n9 + 2];
        float f3 = n2 < 2 ? (float)(n2 + 1) : fArray[n8 + 2] + 1.0f;
        f3 = n < 2 ? (float)(n + 1) : fArray[n9 + 1] + 1.0f;
        if (f3 < (f = f3)) {
            f = f3;
        }
        if ((f3 = n > n5 ? (float)(n5 + 3 - n) : fArray[n9 + 3] + 1.0f) < f) {
            f = f3;
        }
        if ((f3 = n2 > n6 ? (float)(n6 + 3 - n2) : fArray[n10 + 2] + 1.0f) < f) {
            f = f3;
        }
        if ((f3 = n < 2 || n2 < 2 ? f2 + sqrt2 : fArray[n8 + 1] + sqrt2) < f) {
            f = f3;
        }
        if ((f3 = n > n5 || n2 < 2 ? f2 + sqrt2 : fArray[n8 + 3] + sqrt2) < f) {
            f = f3;
        }
        if ((f3 = n < 2 || n2 > n6 ? f2 + sqrt2 : fArray[n10 + 1] + sqrt2) < f) {
            f = f3;
        }
        if ((f3 = n > n5 || n2 > n6 ? f2 + sqrt2 : fArray[n10 + 3] + sqrt2) < f) {
            f = f3;
        }
        if ((f3 = n < 2 || n2 < 2 ? f2 + sqrt5 : fArray[n7 + 1] + sqrt5) < f) {
            f = f3;
        }
        if ((f3 = n > n5 || n2 < 2 ? f2 + sqrt5 : fArray[n7 + 3] + sqrt5) < f) {
            f = f3;
        }
        if ((f3 = n > n5 || n2 < 2 ? f2 + sqrt5 : fArray[n8 + 4] + sqrt5) < f) {
            f = f3;
        }
        if ((f3 = n > n5 || n2 > n6 ? f2 + sqrt5 : fArray[n10 + 4] + sqrt5) < f) {
            f = f3;
        }
        if ((f3 = n > n5 || n2 > n6 ? f2 + sqrt5 : fArray[n11 + 3] + sqrt5) < f) {
            f = f3;
        }
        if ((f3 = n < 2 || n2 > n6 ? f2 + sqrt5 : fArray[n11 + 1] + sqrt5) < f) {
            f = f3;
        }
        if ((f3 = n < 2 || n2 > n6 ? f2 + sqrt5 : fArray[n10] + sqrt5) < f) {
            f = f3;
        }
        if ((f3 = n < 2 || n2 < 2 ? f2 + sqrt5 : fArray[n8] + sqrt5) < f) {
            f = f3;
        }
        fArray[n4] = f;
        return fArray[n4];
    }

    private float setValue(float[] fArray, int n, int n2) {
        int n3 = n2 - n - n - 2;
        int n4 = n3 + n;
        int n5 = n4 + n;
        int n6 = n5 + n;
        int n7 = n6 + n;
        float f = fArray[n5 + 1] + 1.0f;
        f = fArray[n4 + 2] + 1.0f;
        float f2 = f;
        if (f < f2) {
            f2 = f;
        }
        if ((f = fArray[n5 + 3] + 1.0f) < f2) {
            f2 = f;
        }
        if ((f = fArray[n6 + 2] + 1.0f) < f2) {
            f2 = f;
        }
        if ((f = fArray[n4 + 1] + sqrt2) < f2) {
            f2 = f;
        }
        if ((f = fArray[n4 + 3] + sqrt2) < f2) {
            f2 = f;
        }
        if ((f = fArray[n6 + 1] + sqrt2) < f2) {
            f2 = f;
        }
        if ((f = fArray[n6 + 3] + sqrt2) < f2) {
            f2 = f;
        }
        if ((f = fArray[n3 + 1] + sqrt5) < f2) {
            f2 = f;
        }
        if ((f = fArray[n3 + 3] + sqrt5) < f2) {
            f2 = f;
        }
        if ((f = fArray[n4 + 4] + sqrt5) < f2) {
            f2 = f;
        }
        if ((f = fArray[n6 + 4] + sqrt5) < f2) {
            f2 = f;
        }
        if ((f = fArray[n7 + 3] + sqrt5) < f2) {
            f2 = f;
        }
        if ((f = fArray[n7 + 1] + sqrt5) < f2) {
            f2 = f;
        }
        if ((f = fArray[n6] + sqrt5) < f2) {
            f2 = f;
        }
        if ((f = fArray[n4] + sqrt5) < f2) {
            f2 = f;
        }
        fArray[n2] = f2;
        return fArray[n2];
    }

    public String toString() {
        return "Stylize/Shapeburst...";
    }
}

