/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.restriction;

import com.google.common.base.Objects;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinitionImpl;

public class RestrictionImpl
implements Restriction {
    private final RestrictionDefinition definition;
    private final PropertyState property;

    public RestrictionImpl(@Nonnull PropertyState property, @Nonnull RestrictionDefinition def) {
        this.definition = def;
        this.property = property;
    }

    public RestrictionImpl(@Nonnull PropertyState property, boolean isMandatory) {
        this.definition = new RestrictionDefinitionImpl(property.getName(), property.getType(), isMandatory);
        this.property = property;
    }

    @Override
    @Nonnull
    public RestrictionDefinition getDefinition() {
        return this.definition;
    }

    @Override
    @Nonnull
    public PropertyState getProperty() {
        return this.property;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.definition, this.property});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RestrictionImpl) {
            RestrictionImpl other = (RestrictionImpl)o;
            return this.definition.equals(other.definition) && this.property.equals(other.property);
        }
        return false;
    }
}

