/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user.autosave;

import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.oak.security.user.autosave.AuthorizableImpl;
import org.apache.jackrabbit.oak.security.user.autosave.AuthorizableWrapper;
import org.apache.jackrabbit.oak.security.user.autosave.AutoSaveEnabledManager;

class GroupImpl
extends AuthorizableImpl
implements Group {
    GroupImpl(Group dlg, AutoSaveEnabledManager mgr) {
        super((Authorizable)dlg, mgr);
    }

    private Group getDelegate() {
        return (Group)this.dlg;
    }

    public Iterator<Authorizable> getDeclaredMembers() throws RepositoryException {
        return AuthorizableWrapper.createIterator(this.getDelegate().getDeclaredMembers(), this.mgr);
    }

    public Iterator<Authorizable> getMembers() throws RepositoryException {
        return AuthorizableWrapper.createIterator(this.getDelegate().getMembers(), this.mgr);
    }

    public boolean isDeclaredMember(Authorizable authorizable) throws RepositoryException {
        if (this.isValid(authorizable)) {
            return this.getDelegate().isDeclaredMember(((AuthorizableImpl)authorizable).dlg);
        }
        return false;
    }

    public boolean isMember(Authorizable authorizable) throws RepositoryException {
        if (this.isValid(authorizable)) {
            return this.getDelegate().isMember(((AuthorizableImpl)authorizable).dlg);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMember(Authorizable authorizable) throws RepositoryException {
        try {
            if (this.isValid(authorizable)) {
                boolean bl = this.getDelegate().addMember(((AuthorizableImpl)authorizable).dlg);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.mgr.autosave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMember(Authorizable authorizable) throws RepositoryException {
        try {
            if (this.isValid(authorizable)) {
                boolean bl = this.getDelegate().removeMember(((AuthorizableImpl)authorizable).dlg);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.mgr.autosave();
        }
    }

    private boolean isValid(Authorizable a) {
        return a instanceof AuthorizableImpl;
    }
}

