/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user.autosave;

import java.security.Principal;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.oak.security.user.autosave.AuthorizableWrapper;
import org.apache.jackrabbit.oak.security.user.autosave.AutoSaveEnabledManager;

class AuthorizableImpl
implements Authorizable {
    final Authorizable dlg;
    final AutoSaveEnabledManager mgr;

    AuthorizableImpl(Authorizable dlg, AutoSaveEnabledManager mgr) {
        this.dlg = dlg;
        this.mgr = mgr;
    }

    public String getID() throws RepositoryException {
        return this.dlg.getID();
    }

    public boolean isGroup() {
        return this.dlg.isGroup();
    }

    public Principal getPrincipal() throws RepositoryException {
        return this.dlg.getPrincipal();
    }

    public Iterator<Group> declaredMemberOf() throws RepositoryException {
        return AuthorizableWrapper.createGroupIterator(this.dlg.declaredMemberOf(), this.mgr);
    }

    public Iterator<Group> memberOf() throws RepositoryException {
        return AuthorizableWrapper.createGroupIterator(this.dlg.memberOf(), this.mgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() throws RepositoryException {
        try {
            this.dlg.remove();
        }
        finally {
            this.mgr.autosave();
        }
    }

    public Iterator<String> getPropertyNames() throws RepositoryException {
        return this.dlg.getPropertyNames();
    }

    public Iterator<String> getPropertyNames(String s) throws RepositoryException {
        return this.dlg.getPropertyNames(s);
    }

    public boolean hasProperty(String s) throws RepositoryException {
        return this.dlg.hasProperty(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String s, Value value) throws RepositoryException {
        try {
            this.dlg.setProperty(s, value);
        }
        finally {
            this.mgr.autosave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String s, Value[] values) throws RepositoryException {
        try {
            this.dlg.setProperty(s, values);
        }
        finally {
            this.mgr.autosave();
        }
    }

    public Value[] getProperty(String s) throws RepositoryException {
        return this.dlg.getProperty(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeProperty(String s) throws RepositoryException {
        try {
            boolean bl = this.dlg.removeProperty(s);
            return bl;
        }
        finally {
            this.mgr.autosave();
        }
    }

    public String getPath() throws RepositoryException {
        return this.dlg.getPath();
    }

    public int hashCode() {
        return this.dlg.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AuthorizableImpl) {
            return this.dlg.equals(((AuthorizableImpl)o).dlg);
        }
        return false;
    }

    public String toString() {
        return this.dlg.toString();
    }
}

