/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.privilege;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.spi.security.privilege.ImmutablePrivilegeDefinition;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConstants;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeDefinition;
import org.apache.jackrabbit.oak.util.NodeUtil;

class PrivilegeDefinitionWriter
implements PrivilegeConstants {
    private static final String[] NON_AGGR_PRIVILEGES = new String[]{"rep:readNodes", "rep:readProperties", "rep:addProperties", "rep:alterProperties", "rep:removeProperties", "jcr:addChildNodes", "jcr:removeChildNodes", "jcr:removeNode", "jcr:readAccessControl", "jcr:modifyAccessControl", "jcr:nodeTypeManagement", "jcr:versionManagement", "jcr:lockManagement", "jcr:lifecycleManagement", "jcr:retentionManagement", "jcr:workspaceManagement", "jcr:nodeTypeDefinitionManagement", "jcr:namespaceManagement", "rep:privilegeManagement", "rep:userManagement", "rep:indexDefinitionManagement"};
    private static final Map<String, String[]> AGGREGATE_PRIVILEGES = ImmutableMap.of((Object)"jcr:read", (Object)new String[]{"rep:readNodes", "rep:readProperties"}, (Object)"jcr:modifyProperties", (Object)new String[]{"rep:addProperties", "rep:alterProperties", "rep:removeProperties"}, (Object)"jcr:write", (Object)new String[]{"jcr:modifyProperties", "jcr:addChildNodes", "jcr:removeChildNodes", "jcr:removeNode"}, (Object)"rep:write", (Object)new String[]{"jcr:write", "jcr:nodeTypeManagement"});
    private final Root root;
    private final PrivilegeBitsProvider bitsMgr;
    private PrivilegeBits next;

    PrivilegeDefinitionWriter(Root root) {
        this.root = root;
        this.bitsMgr = new PrivilegeBitsProvider(root);
        Tree privilegesTree = this.bitsMgr.getPrivilegesTree();
        this.next = privilegesTree.exists() && privilegesTree.hasProperty("rep:next") ? PrivilegeBits.getInstance(privilegesTree) : PrivilegeBits.NEXT_AFTER_BUILT_INS;
    }

    void writeDefinition(PrivilegeDefinition definition) throws RepositoryException {
        this.writeDefinitions(Collections.singleton(definition));
    }

    void writeBuiltInDefinitions() throws RepositoryException {
        this.writeDefinitions(PrivilegeDefinitionWriter.getBuiltInDefinitions());
    }

    @Nonnull
    private PrivilegeBits getNext() {
        return this.next;
    }

    @Nonnull
    private PrivilegeBits next() {
        PrivilegeBits bits = this.next;
        this.next = bits.nextBits();
        return bits;
    }

    private void writeDefinitions(Iterable<PrivilegeDefinition> definitions) throws RepositoryException {
        try {
            Tree privilegesTree = this.root.getTree("/jcr:system/rep:privileges");
            if (!privilegesTree.exists()) {
                throw new RepositoryException("Privilege store does not exist.");
            }
            NodeUtil privilegesNode = new NodeUtil(privilegesTree);
            for (PrivilegeDefinition definition : definitions) {
                if (privilegesNode.hasChild(definition.getName())) {
                    throw new RepositoryException("Privilege definition with name '" + definition.getName() + "' already exists.");
                }
                this.writePrivilegeNode(privilegesNode, definition);
            }
            this.getNext().writeTo(privilegesTree);
            this.root.commit();
        }
        catch (CommitFailedException e) {
            throw e.asRepositoryException();
        }
    }

    private void writePrivilegeNode(NodeUtil privilegesNode, PrivilegeDefinition definition) throws RepositoryException {
        String[] declAggrNames;
        boolean isAggregate;
        String name = definition.getName();
        NodeUtil privNode = privilegesNode.addChild(name, "rep:Privilege");
        if (definition.isAbstract()) {
            privNode.setBoolean("rep:isAbstract", true);
        }
        boolean bl = isAggregate = (declAggrNames = definition.getDeclaredAggregateNames().toArray(new String[definition.getDeclaredAggregateNames().size()])).length > 0;
        if (isAggregate) {
            privNode.setNames("rep:aggregates", declAggrNames);
        }
        PrivilegeBits bits = PrivilegeBits.BUILT_IN.containsKey(name) ? PrivilegeBits.BUILT_IN.get(name) : (isAggregate ? this.bitsMgr.getBits(declAggrNames) : this.next());
        bits.writeTo(privNode.getTree());
    }

    private static Collection<PrivilegeDefinition> getBuiltInDefinitions() {
        LinkedHashMap<String, ImmutablePrivilegeDefinition> definitions = new LinkedHashMap<String, ImmutablePrivilegeDefinition>();
        for (String privilegeName : NON_AGGR_PRIVILEGES) {
            ImmutablePrivilegeDefinition def = new ImmutablePrivilegeDefinition(privilegeName, false, null);
            definitions.put(privilegeName, def);
        }
        for (String privilegeName : AGGREGATE_PRIVILEGES.keySet()) {
            ImmutablePrivilegeDefinition def = new ImmutablePrivilegeDefinition(privilegeName, false, Arrays.asList((Object[])AGGREGATE_PRIVILEGES.get(privilegeName)));
            definitions.put(privilegeName, def);
        }
        ImmutablePrivilegeDefinition all = new ImmutablePrivilegeDefinition("jcr:all", false, definitions.keySet());
        definitions.put("jcr:all", all);
        return definitions.values();
    }
}

