/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.core.ImmutableRoot;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.plugins.tree.ImmutableTree;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionEntry;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionUtil;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.PostValidationHook;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AccessControlConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.apache.jackrabbit.oak.spi.state.DefaultNodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionHook
implements PostValidationHook,
AccessControlConstants,
PermissionConstants {
    private static final Logger log = LoggerFactory.getLogger(PermissionHook.class);
    private final RestrictionProvider restrictionProvider;
    private final String workspaceName;
    private NodeBuilder permissionRoot;
    private PrivilegeBitsProvider bitsProvider;
    private TypePredicate isACL;
    private TypePredicate isACE;
    private TypePredicate isGrantACE;
    private Map<String, Acl> modified = new HashMap<String, Acl>();
    private Map<String, Acl> deleted = new HashMap<String, Acl>();

    public PermissionHook(String workspaceName, RestrictionProvider restrictionProvider) {
        this.workspaceName = workspaceName;
        this.restrictionProvider = restrictionProvider;
    }

    @Override
    @Nonnull
    public NodeState processCommit(NodeState before, NodeState after, CommitInfo info) throws CommitFailedException {
        NodeBuilder rootAfter = after.builder();
        this.permissionRoot = this.getPermissionRoot(rootAfter);
        this.bitsProvider = new PrivilegeBitsProvider(new ImmutableRoot(after));
        this.isACL = new TypePredicate(after, "rep:ACL");
        this.isACE = new TypePredicate(after, "rep:ACE");
        this.isGrantACE = new TypePredicate(after, "rep:GrantACE");
        Diff diff = new Diff("");
        after.compareAgainstBaseState(before, diff);
        this.apply();
        return rootAfter.getNodeState();
    }

    private void apply() {
        for (Map.Entry<String, Acl> entry : this.deleted.entrySet()) {
            entry.getValue().remove();
        }
        for (Map.Entry<String, Acl> entry : this.modified.entrySet()) {
            entry.getValue().update();
        }
    }

    @Nonnull
    private NodeBuilder getPermissionRoot(NodeBuilder rootBuilder) {
        return rootBuilder.getChildNode("jcr:system").getChildNode("rep:permissionStore").getChildNode(this.workspaceName);
    }

    private final class AcEntry {
        private final String accessControlledPath;
        private final String principalName;
        private final PrivilegeBits privilegeBits;
        private final boolean isAllow;
        private final Set<Restriction> restrictions;
        private final int index;
        private int hashCode = -1;

        private AcEntry(@Nonnull NodeState node, String accessControlledPath, int index) {
            this.accessControlledPath = accessControlledPath;
            this.index = index;
            this.principalName = Text.escapeIllegalJcrChars((String)node.getString("rep:principalName"));
            this.privilegeBits = PermissionHook.this.bitsProvider.getBits(node.getNames("rep:privileges"));
            this.isAllow = PermissionHook.this.isGrantACE.apply(node);
            this.restrictions = PermissionHook.this.restrictionProvider.readRestrictions(Strings.emptyToNull((String)accessControlledPath), new ImmutableTree(node));
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = Objects.hashCode((Object[])new Object[]{this.accessControlledPath, this.principalName, this.privilegeBits, this.isAllow, this.restrictions});
            }
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AcEntry) {
                AcEntry other = (AcEntry)o;
                return this.isAllow == other.isAllow && this.privilegeBits.equals(other.privilegeBits) && this.principalName.equals(other.principalName) && this.accessControlledPath.equals(other.accessControlledPath) && this.restrictions.equals(other.restrictions);
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.accessControlledPath);
            sb.append(';').append(this.principalName);
            sb.append(';').append(this.isAllow ? "allow" : "deny");
            sb.append(';').append(PermissionHook.this.bitsProvider.getPrivilegeNames(this.privilegeBits));
            sb.append(';').append(this.restrictions);
            return sb.toString();
        }
    }

    private final class Acl {
        private final String accessControlledPath;
        private final String nodeName;
        private final Map<String, List<AcEntry>> entries = new HashMap<String, List<AcEntry>>();

        private Acl(String aclPath, @Nonnull String name, NodeState node) {
            this.accessControlledPath = name.equals("rep:repoPolicy") ? "" : (aclPath.length() == 0 ? "/" : aclPath);
            this.nodeName = PermissionUtil.getEntryName(this.accessControlledPath);
            LinkedHashSet orderedChildNames = Sets.newLinkedHashSet(node.getNames(":childOrder"));
            long n = orderedChildNames.size();
            if (node.getChildNodeCount(n + 1L) > n) {
                Iterables.addAll((Collection)orderedChildNames, node.getChildNodeNames());
            }
            int index = 0;
            for (String childName : orderedChildNames) {
                NodeState ace = node.getChildNode(childName);
                if (!PermissionHook.this.isACE.apply(ace)) continue;
                AcEntry entry = new AcEntry(ace, this.accessControlledPath, index);
                List<AcEntry> list = this.entries.get(entry.principalName);
                if (list == null) {
                    list = new ArrayList<AcEntry>();
                    this.entries.put(entry.principalName, list);
                }
                list.add(entry);
                ++index;
            }
        }

        private void remove() {
            for (String principalName : this.entries.keySet()) {
                if (PermissionHook.this.permissionRoot.hasChildNode(principalName)) {
                    NodeBuilder principalRoot = PermissionHook.this.permissionRoot.getChildNode(principalName);
                    NodeBuilder parent = principalRoot.getChildNode(this.nodeName);
                    if (!parent.exists()) continue;
                    if (PermissionUtil.checkACLPath(parent, this.accessControlledPath)) {
                        NodeBuilder newParent = null;
                        for (String childName : parent.getChildNodeNames()) {
                            if (childName.charAt(0) != 'c') continue;
                            NodeBuilder child = parent.getChildNode(childName);
                            if (newParent == null) {
                                newParent = child;
                                continue;
                            }
                            newParent.setChildNode(childName, child.getNodeState());
                            child.remove();
                        }
                        parent.remove();
                        if (newParent == null) continue;
                        principalRoot.setChildNode(this.nodeName, newParent.getNodeState());
                        continue;
                    }
                    for (String childName : parent.getChildNodeNames()) {
                        NodeBuilder child;
                        if (childName.charAt(0) != 'c' || !PermissionUtil.checkACLPath(child = parent.getChildNode(childName), this.accessControlledPath)) continue;
                        child.remove();
                    }
                    continue;
                }
                log.error("Unable to remove permission entry {}: Principal root missing.", (Object)this);
            }
        }

        private void update() {
            for (String principalName : this.entries.keySet()) {
                NodeBuilder parent;
                NodeBuilder principalRoot = PermissionHook.this.permissionRoot.child(principalName);
                if (!principalRoot.hasProperty("jcr:primaryType")) {
                    principalRoot.setProperty("jcr:primaryType", "rep:PermissionStore", Type.NAME);
                }
                if (!(parent = principalRoot.child(this.nodeName)).hasProperty("jcr:primaryType")) {
                    parent.setProperty("jcr:primaryType", "rep:PermissionStore", Type.NAME);
                }
                if (parent.hasProperty("rep:accessControlledPath")) {
                    if (!PermissionUtil.checkACLPath(parent, this.accessControlledPath)) {
                        NodeBuilder child = null;
                        int idx = 0;
                        for (String childName : parent.getChildNodeNames()) {
                            if (childName.charAt(0) != 'c') continue;
                            child = parent.getChildNode(childName);
                            if (PermissionUtil.checkACLPath(child, this.accessControlledPath)) break;
                            child = null;
                            ++idx;
                        }
                        while (child == null) {
                            String name = 'c' + String.valueOf(idx++);
                            child = parent.getChildNode(name);
                            if (child.exists()) {
                                child = null;
                                continue;
                            }
                            child = parent.child(name);
                            child.setProperty("jcr:primaryType", "rep:PermissionStore", Type.NAME);
                        }
                        parent = child;
                        parent.setProperty("rep:accessControlledPath", this.accessControlledPath);
                    }
                } else {
                    parent.setProperty("rep:accessControlledPath", this.accessControlledPath);
                }
                this.updateEntries(parent, this.entries.get(principalName));
            }
        }

        private void updateEntries(NodeBuilder parent, List<AcEntry> list) {
            for (String childName : parent.getChildNodeNames()) {
                if (childName.charAt(0) == 'c') continue;
                parent.getChildNode(childName).remove();
            }
            for (AcEntry ace : list) {
                PermissionEntry.write(parent, ace.isAllow, ace.index, ace.privilegeBits, ace.restrictions);
            }
        }
    }

    private class Diff
    extends DefaultNodeStateDiff {
        private final String parentPath;

        private Diff(String parentPath) {
            this.parentPath = parentPath;
        }

        @Override
        public boolean childNodeAdded(String name, NodeState after) {
            if (NodeStateUtils.isHidden(name)) {
                return true;
            }
            String path = this.parentPath + '/' + name;
            if (PermissionHook.this.isACL.apply(after)) {
                Acl acl = new Acl(this.parentPath, name, after);
                PermissionHook.this.modified.put(acl.accessControlledPath, acl);
            } else {
                after.compareAgainstBaseState(EmptyNodeState.EMPTY_NODE, new Diff(path));
            }
            return true;
        }

        @Override
        public boolean childNodeChanged(String name, NodeState before, NodeState after) {
            if (NodeStateUtils.isHidden(name)) {
                return true;
            }
            String path = this.parentPath + '/' + name;
            if (PermissionHook.this.isACL.apply(before)) {
                if (PermissionHook.this.isACL.apply(after)) {
                    Acl acl = new Acl(this.parentPath, name, after);
                    PermissionHook.this.modified.put(acl.accessControlledPath, acl);
                    Acl beforeAcl = new Acl(this.parentPath, name, before);
                    beforeAcl.entries.keySet().removeAll(acl.entries.keySet());
                    if (!beforeAcl.entries.isEmpty()) {
                        PermissionHook.this.deleted.put(this.parentPath, beforeAcl);
                    }
                } else {
                    Acl acl = new Acl(this.parentPath, name, before);
                    PermissionHook.this.deleted.put(acl.accessControlledPath, acl);
                }
            } else if (PermissionHook.this.isACL.apply(after)) {
                Acl acl = new Acl(this.parentPath, name, after);
                PermissionHook.this.modified.put(acl.accessControlledPath, acl);
            } else {
                after.compareAgainstBaseState(before, new Diff(path));
            }
            return true;
        }

        @Override
        public boolean childNodeDeleted(String name, NodeState before) {
            if (NodeStateUtils.isHidden(name)) {
                return true;
            }
            String path = this.parentPath + '/' + name;
            if (PermissionHook.this.isACL.apply(before)) {
                Acl acl = new Acl(this.parentPath, name, before);
                PermissionHook.this.deleted.put(acl.accessControlledPath, acl);
            } else {
                EmptyNodeState.EMPTY_NODE.compareAgainstBaseState(before, new Diff(path));
            }
            return true;
        }
    }
}

