/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.accesscontrol;

import com.google.common.base.Preconditions;
import java.security.AccessControlException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.security.authorization.accesscontrol.Util;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AccessControlConstants;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.apache.jackrabbit.oak.spi.xml.NodeInfo;
import org.apache.jackrabbit.oak.spi.xml.PropInfo;
import org.apache.jackrabbit.oak.spi.xml.ProtectedNodeImporter;
import org.apache.jackrabbit.oak.spi.xml.ReferenceChangeTracker;
import org.apache.jackrabbit.oak.spi.xml.TextValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessControlImporter
implements ProtectedNodeImporter,
AccessControlConstants {
    private static final Logger log = LoggerFactory.getLogger(AccessControlImporter.class);
    private static final int CHILD_STATUS_UNDEFINED = 0;
    private static final int CHILD_STATUS_ACE = 1;
    private static final int CHILD_STATUS_RESTRICTION = 2;
    private AccessControlManager acMgr;
    private PrincipalManager principalManager;
    private ReadOnlyNodeTypeManager ntMgr;
    private boolean initialized = false;
    private int childStatus;
    private JackrabbitAccessControlList acl;
    private MutableEntry entry;
    private int importBehavior;

    @Override
    public boolean init(Session session, Root root, NamePathMapper namePathMapper, boolean isWorkspaceImport, int uuidBehavior, ReferenceChangeTracker referenceTracker, SecurityProvider securityProvider) {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        try {
            AuthorizationConfiguration config = securityProvider.getConfiguration(AuthorizationConfiguration.class);
            this.importBehavior = Util.getImportBehavior(config);
            if (isWorkspaceImport) {
                this.acMgr = config.getAccessControlManager(root, namePathMapper);
                PrincipalConfiguration pConfig = securityProvider.getConfiguration(PrincipalConfiguration.class);
                this.principalManager = pConfig.getPrincipalManager(root, namePathMapper);
            } else {
                this.acMgr = session.getAccessControlManager();
                this.principalManager = ((JackrabbitSession)session).getPrincipalManager();
            }
            this.ntMgr = ReadOnlyNodeTypeManager.getInstance(root, namePathMapper);
            this.initialized = true;
        }
        catch (RepositoryException e) {
            log.warn("Error while initializing access control importer", (Throwable)e);
        }
        return this.initialized;
    }

    @Override
    public void processReferences() throws RepositoryException {
    }

    @Override
    public boolean start(Tree protectedParent) throws RepositoryException {
        this.checkInitialized();
        this.acl = this.getACL(protectedParent);
        return this.acl != null;
    }

    @Override
    public void end(Tree protectedParent) throws RepositoryException {
        if (this.acl == null) {
            throw new IllegalStateException("End reached without ACL to write back.");
        }
        this.acMgr.setPolicy(this.acl.getPath(), (AccessControlPolicy)this.acl);
        this.acl = null;
    }

    @Override
    public void startChildInfo(NodeInfo childInfo, List<PropInfo> propInfos) throws RepositoryException {
        this.checkInitialized();
        String ntName = childInfo.getPrimaryTypeName();
        if ("rep:GrantACE".equals(ntName) || "rep:DenyACE".equals(ntName)) {
            if (this.entry != null) {
                throw new ConstraintViolationException("Invalid child node sequence: ACEs may not be nested.");
            }
            this.entry = new MutableEntry("rep:GrantACE".equals(ntName));
            for (PropInfo prop : propInfos) {
                String name = prop.getName();
                if ("rep:principalName".equals(name)) {
                    this.entry.setPrincipal(prop.getTextValue());
                    continue;
                }
                if ("rep:privileges".equals(name)) {
                    this.entry.setPrivilegeNames(prop.getTextValues());
                    continue;
                }
                this.entry.addRestriction(prop);
            }
            this.childStatus = 1;
        } else if ("rep:Restrictions".equals(ntName)) {
            if (this.entry == null) {
                throw new ConstraintViolationException("Invalid child node sequence: Restriction must be associated with an ACE");
            }
            this.entry.addRestrictions(propInfos);
            this.childStatus = 2;
        } else {
            throw new ConstraintViolationException("Invalid child node with type " + ntName);
        }
    }

    @Override
    public void endChildInfo() throws RepositoryException {
        this.checkInitialized();
        switch (this.childStatus) {
            case 1: {
                this.entry.applyTo(this.acl);
                this.entry = null;
                this.childStatus = 0;
                break;
            }
            case 2: {
                this.childStatus = 1;
                break;
            }
            default: {
                throw new ConstraintViolationException("Invalid child node sequence.");
            }
        }
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized");
        }
    }

    @CheckForNull
    private JackrabbitAccessControlList getACL(Tree tree) throws RepositoryException {
        String nodeName = tree.getName();
        JackrabbitAccessControlList acl = null;
        if (!tree.isRoot()) {
            Tree parent = tree.getParent();
            if ("rep:policy".equals(nodeName) && this.ntMgr.isNodeType(tree, "rep:ACL")) {
                acl = this.getACL(parent.getPath());
            } else if ("rep:repoPolicy".equals(nodeName) && this.ntMgr.isNodeType(tree, "rep:ACL") && parent.isRoot()) {
                acl = this.getACL((String)null);
            }
        }
        if (acl != null) {
            for (AccessControlEntry ace : acl.getAccessControlEntries()) {
                acl.removeAccessControlEntry(ace);
            }
        }
        return acl;
    }

    @CheckForNull
    private JackrabbitAccessControlList getACL(String path) throws RepositoryException {
        JackrabbitAccessControlList acl = null;
        for (AccessControlPolicy p : this.acMgr.getPolicies(path)) {
            if (!(p instanceof JackrabbitAccessControlList)) continue;
            acl = (JackrabbitAccessControlList)p;
            break;
        }
        return acl;
    }

    private final class MutableEntry {
        final boolean isAllow;
        Principal principal;
        List<Privilege> privileges;
        Map<String, Value> restrictions = new HashMap<String, Value>();
        boolean ignore;

        private MutableEntry(boolean isAllow) {
            this.isAllow = isAllow;
        }

        private void setPrincipal(TextValue txtValue) {
            String principalName = txtValue.getString();
            this.principal = AccessControlImporter.this.principalManager.getPrincipal(principalName);
            if (this.principal == null) {
                switch (AccessControlImporter.this.importBehavior) {
                    case 1: {
                        log.debug("Unknown principal " + principalName + " -> Ignoring this ACE.");
                        this.ignore = true;
                        break;
                    }
                    case 3: {
                        throw new AccessControlException("Unknown principal " + principalName);
                    }
                    case 2: {
                        this.principal = new PrincipalImpl(principalName);
                    }
                }
            }
        }

        private void setPrivilegeNames(List<? extends TextValue> txtValues) throws RepositoryException {
            this.privileges = new ArrayList<Privilege>();
            for (TextValue textValue : txtValues) {
                Value privilegeName = textValue.getValue(7);
                this.privileges.add(AccessControlImporter.this.acMgr.privilegeFromName(privilegeName.getString()));
            }
        }

        private void addRestriction(PropInfo propInfo) throws RepositoryException {
            String restrictionName = propInfo.getName();
            int targetType = AccessControlImporter.this.acl.getRestrictionType(restrictionName);
            this.restrictions.put(propInfo.getName(), propInfo.getValue(targetType));
        }

        private void addRestrictions(List<PropInfo> propInfos) throws RepositoryException {
            for (PropInfo prop : propInfos) {
                this.addRestriction(prop);
            }
        }

        private void applyTo(JackrabbitAccessControlList acl) throws RepositoryException {
            Preconditions.checkNotNull((Object)acl);
            if (!this.ignore) {
                acl.addEntry(this.principal, this.privileges.toArray(new Privilege[this.privileges.size()]), this.isAllow, this.restrictions);
            } else {
                log.debug("Unknown principal: Ignore ACE based on ImportBehavior.IGNORE configuration.");
            }
        }
    }
}

