/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.IndexUtils;
import org.apache.jackrabbit.oak.spi.lifecycle.WorkspaceInitializer;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AccessControlConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionConstants;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;

class AuthorizationInitializer
implements WorkspaceInitializer,
AccessControlConstants,
PermissionConstants {
    AuthorizationInitializer() {
    }

    @Override
    public void initialize(NodeBuilder builder, String workspaceName) {
        NodeBuilder permissionStore;
        NodeBuilder index = IndexUtils.getOrCreateOakIndex(builder);
        if (!index.hasChildNode("acPrincipalName")) {
            IndexUtils.createIndexDefinition(index, "acPrincipalName", true, false, (Collection<String>)ImmutableList.of((Object)"rep:principalName"), (Collection<String>)ImmutableList.of((Object)"rep:DenyACE", (Object)"rep:GrantACE", (Object)"rep:ACE"));
        }
        if (!(permissionStore = builder.child("jcr:system").child("rep:permissionStore")).hasProperty("jcr:primaryType")) {
            permissionStore.setProperty("jcr:primaryType", "rep:PermissionStore", Type.NAME);
        }
        if (!permissionStore.hasChildNode(workspaceName)) {
            permissionStore.child(workspaceName).setProperty("jcr:primaryType", "rep:PermissionStore", Type.NAME);
        }
    }
}

