/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.stats.Clock;

public class CommitRateLimiter
implements CommitHook {
    private volatile boolean blockCommits;
    private volatile long delay;

    public void blockCommits() {
        this.blockCommits = true;
    }

    public void unblockCommits() {
        this.blockCommits = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDelay(long delay) {
        this.delay = delay;
        if (delay == 0L) {
            CommitRateLimiter commitRateLimiter = this;
            synchronized (commitRateLimiter) {
                this.notifyAll();
            }
        }
    }

    @Override
    @Nonnull
    public NodeState processCommit(NodeState before, NodeState after, CommitInfo info) throws CommitFailedException {
        if (this.blockCommits) {
            throw new CommitFailedException("Oak", 1, "System busy. Try again later.");
        }
        this.delay();
        return after;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delay() throws CommitFailedException {
        if (this.delay > 0L) {
            CommitRateLimiter commitRateLimiter = this;
            synchronized (commitRateLimiter) {
                try {
                    long t0 = Clock.ACCURATE.getTime();
                    long dt = this.delay;
                    do {
                        this.wait(dt);
                        dt = dt - Clock.ACCURATE.getTime() + t0;
                    } while (this.delay > 0L && dt > 0L);
                }
                catch (InterruptedException e) {
                    throw new CommitFailedException("Oak", 2, "Interrupted while waiting to commit", e);
                }
            }
        }
    }
}

