/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Striped;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.QueryBuilder;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.plugins.document.CachedNodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentMK;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.StableRevisionComparator;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.UpdateUtils;
import org.apache.jackrabbit.oak.plugins.document.cache.CachingDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.cache.ForwardingListener;
import org.apache.jackrabbit.oak.plugins.document.cache.NodeDocOffHeapCache;
import org.apache.jackrabbit.oak.plugins.document.cache.OffHeapCache;
import org.apache.jackrabbit.oak.plugins.document.mongo.CacheInvalidator;
import org.apache.jackrabbit.oak.plugins.document.mongo.RevisionEntry;
import org.apache.jackrabbit.oak.plugins.document.util.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDocumentStore
implements CachingDocumentStore {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDocumentStore.class);
    private static final boolean LOG_TIME = false;
    private static final DBObject BY_ID_ASC = new BasicDBObject("_id", (Object)1);
    public static final int IN_CLAUSE_BATCH_SIZE = 500;
    private final DBCollection nodes;
    private final DBCollection clusterNodes;
    private final DBCollection settings;
    private long timeSum;
    private final Cache<CacheValue, NodeDocument> nodesCache;
    private final CacheStats cacheStats;
    private final Striped<Lock> locks = Striped.lock((int)64);
    private final Comparator<Revision> comparator = StableRevisionComparator.REVERSE;
    private String lastReadWriteMode;

    public MongoDocumentStore(DB db, DocumentMK.Builder builder) {
        this.nodes = db.getCollection(Collection.NODES.toString());
        this.clusterNodes = db.getCollection(Collection.CLUSTER_NODES.toString());
        this.settings = db.getCollection(Collection.SETTINGS.toString());
        BasicDBObject index = new BasicDBObject();
        index.put("_modified", (Object)-1L);
        BasicDBObject options = new BasicDBObject();
        options.put("unique", (Object)Boolean.FALSE);
        this.nodes.ensureIndex((DBObject)index, (DBObject)options);
        index = new BasicDBObject();
        index.put("_bin", (Object)1);
        options = new BasicDBObject();
        options.put("unique", (Object)Boolean.FALSE);
        options.put("sparse", (Object)Boolean.TRUE);
        this.nodes.ensureIndex((DBObject)index, (DBObject)options);
        index = new BasicDBObject();
        index.put("_deletedOnce", (Object)1);
        options = new BasicDBObject();
        options.put("unique", (Object)Boolean.FALSE);
        options.put("sparse", (Object)Boolean.TRUE);
        this.nodes.ensureIndex((DBObject)index, (DBObject)options);
        index = new BasicDBObject();
        index.put("_sdType", (Object)1);
        options = new BasicDBObject();
        options.put("unique", (Object)Boolean.FALSE);
        options.put("sparse", (Object)Boolean.TRUE);
        this.nodes.ensureIndex((DBObject)index, (DBObject)options);
        this.nodesCache = builder.useOffHeapCache() ? this.createOffHeapCache(builder) : builder.buildCache(builder.getDocumentCacheSize());
        this.cacheStats = new CacheStats(this.nodesCache, "Document-Documents", builder.getWeigher(), builder.getDocumentCacheSize());
    }

    private Cache<CacheValue, NodeDocument> createOffHeapCache(DocumentMK.Builder builder) {
        ForwardingListener<CacheValue, NodeDocument> listener = ForwardingListener.newInstance();
        Cache primaryCache = CacheBuilder.newBuilder().weigher(builder.getWeigher()).maximumWeight(builder.getDocumentCacheSize()).removalListener(listener).recordStats().build();
        NodeDocOffHeapCache cache = new NodeDocOffHeapCache((Cache<CacheValue, NodeDocument>)primaryCache, listener, builder, this);
        return cache;
    }

    private static long start() {
        return 0L;
    }

    private void end(String message, long start) {
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    @Override
    public void invalidateCache() {
        CacheInvalidator.createHierarchicalInvalidator(this).invalidateCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> void invalidateCache(Collection<T> collection, String key) {
        if (collection == Collection.NODES) {
            Lock lock = this.getAndLock(key);
            try {
                this.nodesCache.invalidate((Object)new StringValue(key));
            }
            finally {
                lock.unlock();
            }
        }
    }

    public <T extends Document> void invalidateCache(Collection<T> collection, List<String> keys) {
        for (String key : keys) {
            this.invalidateCache(collection, key);
        }
    }

    @Override
    public <T extends Document> T find(Collection<T> collection, String key) {
        return this.find(collection, key, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> T find(final Collection<T> collection, final String key, int maxCacheAge) {
        NodeDocument doc;
        if (collection != Collection.NODES) {
            return this.findUncached(collection, key);
        }
        StringValue cacheKey = new StringValue(key);
        if (maxCacheAge > 0 && (doc = (NodeDocument)this.nodesCache.getIfPresent((Object)cacheKey)) != null && (maxCacheAge == Integer.MAX_VALUE || System.currentTimeMillis() - doc.getCreated() < (long)maxCacheAge)) {
            if (doc == NodeDocument.NULL) {
                return null;
            }
            return (T)doc;
        }
        try {
            Lock lock = this.getAndLock(key);
            try {
                if (maxCacheAge == 0) {
                    this.invalidateCache(collection, key);
                }
                while (true) {
                    doc = (NodeDocument)this.nodesCache.get((Object)cacheKey, (Callable)new Callable<NodeDocument>(){

                        @Override
                        public NodeDocument call() throws Exception {
                            NodeDocument doc = (NodeDocument)MongoDocumentStore.this.findUncached(collection, key);
                            if (doc == null) {
                                doc = NodeDocument.NULL;
                            }
                            return doc;
                        }
                    });
                    if (maxCacheAge == 0) break;
                    if (maxCacheAge == Integer.MAX_VALUE) {
                        break;
                    }
                    if (System.currentTimeMillis() - doc.getCreated() < (long)maxCacheAge) {
                        break;
                    }
                    this.invalidateCache(collection, key);
                }
            }
            finally {
                lock.unlock();
            }
            if (doc == NodeDocument.NULL) {
                return null;
            }
            return (T)doc;
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Failed to load document with " + key, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    <T extends Document> T findUncached(Collection<T> collection, String key) {
        DBCollection dbCollection = this.getDBCollection(collection);
        long start = MongoDocumentStore.start();
        try {
            DBObject obj = dbCollection.findOne(MongoDocumentStore.getByKeyQuery(key).get());
            if (obj == null) {
                T t = null;
                return t;
            }
            T doc = this.convertFromDBObject(collection, obj);
            if (doc != null) {
                ((Document)doc).seal();
            }
            T t = doc;
            return t;
        }
        finally {
            this.end("findUncached", start);
        }
    }

    @Override
    @Nonnull
    public <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, int limit) {
        return this.query(collection, fromKey, toKey, null, 0L, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, String indexedProperty, long startValue, int limit) {
        MongoDocumentStore.log("query", fromKey, toKey, limit);
        DBCollection dbCollection = this.getDBCollection(collection);
        QueryBuilder queryBuilder = QueryBuilder.start((String)"_id");
        queryBuilder.greaterThan((Object)fromKey);
        queryBuilder.lessThan((Object)toKey);
        if (indexedProperty != null) {
            queryBuilder.and(indexedProperty);
            queryBuilder.greaterThanEquals((Object)startValue);
        }
        DBObject query = queryBuilder.get();
        long start = MongoDocumentStore.start();
        try {
            ArrayList<T> list;
            DBCursor cursor = dbCollection.find(query).sort(BY_ID_ASC);
            try {
                list = new ArrayList<T>();
                for (int i = 0; i < limit && cursor.hasNext(); ++i) {
                    DBObject o = cursor.next();
                    T doc = this.convertFromDBObject(collection, o);
                    if (collection == Collection.NODES && doc != null) {
                        ((Document)doc).seal();
                        String id = ((Document)doc).getId();
                        Lock lock = this.getAndLock(id);
                        StringValue cacheKey = new StringValue(id);
                        try {
                            NodeDocument cached = (NodeDocument)this.nodesCache.getIfPresent((Object)cacheKey);
                            if (cached != null && cached != NodeDocument.NULL) {
                                Number cachedModCount = cached.getModCount();
                                Number modCount = ((Document)doc).getModCount();
                                if (cachedModCount == null || modCount == null) {
                                    throw new IllegalStateException("Missing _modCount");
                                }
                                if (modCount.longValue() > cachedModCount.longValue()) {
                                    this.nodesCache.put((Object)cacheKey, (Object)((NodeDocument)doc));
                                }
                            } else {
                                this.nodesCache.put((Object)cacheKey, (Object)((NodeDocument)doc));
                            }
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                    list.add(doc);
                }
            }
            finally {
                cursor.close();
            }
            ArrayList<T> arrayList = list;
            return arrayList;
        }
        finally {
            this.end("query", start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> void remove(Collection<T> collection, String key) {
        MongoDocumentStore.log("remove", key);
        DBCollection dbCollection = this.getDBCollection(collection);
        long start = MongoDocumentStore.start();
        try {
            WriteResult writeResult = dbCollection.remove(MongoDocumentStore.getByKeyQuery(key).get(), WriteConcern.SAFE);
            this.invalidateCache(collection, key);
            if (writeResult.getError() != null) {
                throw new MicroKernelException("Remove failed: " + writeResult.getError());
            }
        }
        finally {
            this.end("remove", start);
        }
    }

    @Override
    public <T extends Document> void remove(Collection<T> collection, List<String> keys) {
        DBCollection dbCollection = this.getDBCollection(collection);
        for (List keyBatch : Lists.partition(keys, (int)500)) {
            DBObject query = QueryBuilder.start((String)"_id").in((Object)keyBatch).get();
            WriteResult writeResult = dbCollection.remove(query, WriteConcern.SAFE);
            this.invalidateCache(collection, keyBatch);
            if (writeResult.getError() == null) continue;
            throw new MicroKernelException("Remove failed: " + writeResult.getError());
        }
    }

    @CheckForNull
    private <T extends Document> T findAndModify(Collection<T> collection, UpdateOp updateOp, boolean upsert, boolean checkConditions) {
        DBCollection dbCollection = this.getDBCollection(collection);
        updateOp = updateOp.copy();
        DBObject update = MongoDocumentStore.createUpdate(updateOp);
        Lock lock = this.getAndLock(updateOp.getId());
        long start = MongoDocumentStore.start();
        try {
            DBObject oldNode;
            QueryBuilder query;
            Document doc;
            Number modCount = null;
            Document cachedDoc = null;
            if (collection == Collection.NODES && (cachedDoc = (doc = (Document)this.nodesCache.getIfPresent((Object)new StringValue(updateOp.getId())))) != null) {
                modCount = cachedDoc.getModCount();
            }
            if (modCount != null) {
                query = MongoDocumentStore.createQueryForUpdate(updateOp, checkConditions);
                query.and("_modCount").is(modCount);
                BasicDBObject fields = new BasicDBObject();
                fields.put("_id", (Object)1);
                oldNode = dbCollection.findAndModify(query.get(), (DBObject)fields, null, false, update, false, false);
                if (oldNode != null) {
                    this.applyToCache(collection, cachedDoc, updateOp);
                    Document document = cachedDoc;
                    return (T)document;
                }
            }
            query = MongoDocumentStore.createQueryForUpdate(updateOp, checkConditions);
            DBObject oldNode2 = dbCollection.findAndModify(query.get(), null, null, false, update, false, upsert);
            if (checkConditions && oldNode2 == null) {
                oldNode = null;
                return (T)oldNode;
            }
            T oldDoc = this.convertFromDBObject(collection, oldNode2);
            this.applyToCache(collection, oldDoc, updateOp);
            if (oldDoc != null) {
                ((Document)oldDoc).seal();
            }
            T t = oldDoc;
            return t;
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
        finally {
            lock.unlock();
            this.end("findAndModify", start);
        }
    }

    @Override
    @CheckForNull
    public <T extends Document> T createOrUpdate(Collection<T> collection, UpdateOp update) throws MicroKernelException {
        MongoDocumentStore.log("createOrUpdate", update);
        T doc = this.findAndModify(collection, update, true, false);
        MongoDocumentStore.log("createOrUpdate returns ", doc);
        return doc;
    }

    @Override
    public <T extends Document> T findAndUpdate(Collection<T> collection, UpdateOp update) throws MicroKernelException {
        MongoDocumentStore.log("findAndUpdate", update);
        T doc = this.findAndModify(collection, update, false, true);
        MongoDocumentStore.log("findAndUpdate returns ", doc);
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> boolean create(Collection<T> collection, List<UpdateOp> updateOps) {
        MongoDocumentStore.log("create", updateOps);
        ArrayList<T> docs = new ArrayList<T>();
        DBObject[] inserts = new DBObject[updateOps.size()];
        for (int i = 0; i < updateOps.size(); ++i) {
            inserts[i] = new BasicDBObject();
            UpdateOp update = updateOps.get(i);
            T target = collection.newDocument(this);
            UpdateUtils.applyChanges(target, update, this.comparator);
            docs.add(target);
            for (Map.Entry<UpdateOp.Key, UpdateOp.Operation> entry : update.getChanges().entrySet()) {
                UpdateOp.Key k = entry.getKey();
                UpdateOp.Operation op = entry.getValue();
                switch (op.type) {
                    case SET: 
                    case INCREMENT: {
                        inserts[i].put(k.toString(), op.value);
                        break;
                    }
                    case SET_MAP_ENTRY: {
                        Revision r = k.getRevision();
                        if (r == null) {
                            throw new IllegalStateException("SET_MAP_ENTRY must not have null revision");
                        }
                        RevisionEntry value = new RevisionEntry(r, op.value);
                        inserts[i].put(k.getName(), (Object)value);
                        break;
                    }
                    case REMOVE_MAP_ENTRY: {
                        break;
                    }
                }
            }
            if (inserts[i].containsField("_modCount")) continue;
            inserts[i].put("_modCount", (Object)1L);
            ((Document)target).put("_modCount", 1L);
        }
        DBCollection dbCollection = this.getDBCollection(collection);
        long start = MongoDocumentStore.start();
        try {
            WriteResult writeResult = dbCollection.insert(inserts, WriteConcern.SAFE);
            if (writeResult.getError() != null) {
                boolean entry = false;
                return entry;
            }
            if (collection == Collection.NODES) {
                for (Document doc : docs) {
                    Lock lock = this.getAndLock(doc.getId());
                    try {
                        this.addToCache((NodeDocument)doc);
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (MongoException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.end("create", start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> void update(Collection<T> collection, List<String> keys, UpdateOp updateOp) {
        DBCollection dbCollection = this.getDBCollection(collection);
        QueryBuilder query = QueryBuilder.start((String)"_id").in(keys);
        updateOp = updateOp.copy();
        DBObject update = MongoDocumentStore.createUpdate(updateOp);
        long start = MongoDocumentStore.start();
        try {
            HashMap cachedDocs = Collections.emptyMap();
            if (collection == Collection.NODES) {
                cachedDocs = Maps.newHashMap();
                for (String key : keys) {
                    cachedDocs.put(key, this.nodesCache.getIfPresent((Object)new StringValue(key)));
                }
            }
            try {
                WriteResult writeResult = dbCollection.update(query.get(), update, false, true, WriteConcern.SAFE);
                if (writeResult.getError() != null) {
                    throw new MicroKernelException("Update failed: " + writeResult.getError());
                }
                for (Map.Entry entry : cachedDocs.entrySet()) {
                    Lock lock = this.getAndLock((String)entry.getKey());
                    try {
                        if (entry.getValue() == null) {
                            this.nodesCache.invalidate((Object)new StringValue((String)entry.getKey()));
                            continue;
                        }
                        this.applyToCache(Collection.NODES, (Document)entry.getValue(), updateOp.shallowCopy((String)entry.getKey()));
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
            catch (MongoException e) {
                throw new MicroKernelException((Throwable)e);
            }
        }
        finally {
            this.end("update", start);
        }
    }

    @CheckForNull
    <T extends Document> T convertFromDBObject(@Nonnull Collection<T> collection, @Nullable DBObject n) {
        Document copy = null;
        if (n != null) {
            copy = (Document)collection.newDocument(this);
            for (String key : n.keySet()) {
                Object o = n.get(key);
                if (o instanceof String) {
                    copy.put(key, o);
                    continue;
                }
                if (o instanceof Long) {
                    copy.put(key, o);
                    continue;
                }
                if (o instanceof Boolean) {
                    copy.put(key, o);
                    continue;
                }
                if (!(o instanceof BasicDBObject)) continue;
                copy.put(key, this.convertMongoMap((BasicDBObject)o));
            }
        }
        return (T)copy;
    }

    @Nonnull
    private Map<Revision, Object> convertMongoMap(@Nonnull BasicDBObject obj) {
        TreeMap<Revision, Object> map = new TreeMap<Revision, Object>(this.comparator);
        for (Map.Entry entry : obj.entrySet()) {
            map.put(Revision.fromString((String)entry.getKey()), entry.getValue());
        }
        return map;
    }

    <T extends Document> DBCollection getDBCollection(Collection<T> collection) {
        if (collection == Collection.NODES) {
            return this.nodes;
        }
        if (collection == Collection.CLUSTER_NODES) {
            return this.clusterNodes;
        }
        if (collection == Collection.SETTINGS) {
            return this.settings;
        }
        throw new IllegalArgumentException("Unknown collection: " + collection.toString());
    }

    private static QueryBuilder getByKeyQuery(String key) {
        return QueryBuilder.start((String)"_id").is((Object)key);
    }

    @Override
    public void dispose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("MongoDB time: " + this.timeSum);
        }
        this.nodes.getDB().getMongo().close();
        if (this.nodesCache instanceof Closeable) {
            try {
                ((Closeable)this.nodesCache).close();
            }
            catch (IOException e) {
                LOG.warn("Error occurred while closing Off Heap Cache", (Throwable)e);
            }
        }
    }

    @Override
    public CacheStats getCacheStats() {
        return this.cacheStats;
    }

    Iterable<? extends Map.Entry<CacheValue, ? extends CachedNodeDocument>> getCacheEntries() {
        if (this.nodesCache instanceof OffHeapCache) {
            return Iterables.concat(this.nodesCache.asMap().entrySet(), ((OffHeapCache)this.nodesCache).offHeapEntriesMap().entrySet());
        }
        return this.nodesCache.asMap().entrySet();
    }

    CachedNodeDocument getCachedNodeDoc(String id) {
        if (this.nodesCache instanceof OffHeapCache) {
            return ((OffHeapCache)this.nodesCache).getCachedDocument(id);
        }
        return (CachedNodeDocument)this.nodesCache.getIfPresent((Object)new StringValue(id));
    }

    private static void log(String message, Object ... args) {
        if (LOG.isDebugEnabled()) {
            String argList = Arrays.toString(args);
            if (argList.length() > 10000) {
                argList = argList.length() + ": " + argList;
            }
            LOG.debug(message + argList);
        }
    }

    @Override
    public <T extends Document> T getIfCached(Collection<T> collection, String key) {
        if (collection != Collection.NODES) {
            return null;
        }
        Document doc = (Document)this.nodesCache.getIfPresent((Object)new StringValue(key));
        return (T)doc;
    }

    private <T extends Document> void applyToCache(@Nonnull Collection<T> collection, @Nullable T oldDoc, @Nonnull UpdateOp updateOp) {
        if (collection == Collection.NODES) {
            NodeDocument cached;
            StringValue key = new StringValue(updateOp.getId());
            NodeDocument newDoc = (NodeDocument)collection.newDocument(this);
            if (oldDoc != null) {
                cached = (NodeDocument)this.nodesCache.getIfPresent((Object)key);
                if (cached == null) {
                    return;
                }
                oldDoc.deepCopy(newDoc);
            }
            UpdateUtils.applyChanges(newDoc, updateOp, this.comparator);
            newDoc.seal();
            cached = this.addToCache(newDoc);
            if (cached == newDoc) {
                return;
            }
            if (oldDoc == null) {
                return;
            }
            if (Objects.equal((Object)cached.getModCount(), (Object)oldDoc.getModCount())) {
                this.nodesCache.put((Object)key, (Object)newDoc);
            } else {
                this.nodesCache.invalidate((Object)key);
            }
        }
    }

    @Nonnull
    private NodeDocument addToCache(final @Nonnull NodeDocument doc) {
        if (doc == NodeDocument.NULL) {
            throw new IllegalArgumentException("doc must not be NULL document");
        }
        doc.seal();
        try {
            StringValue key = new StringValue(doc.getId());
            while (true) {
                NodeDocument cached;
                if ((cached = (NodeDocument)this.nodesCache.get((Object)key, (Callable)new Callable<NodeDocument>(){

                    @Override
                    public NodeDocument call() {
                        return doc;
                    }
                })) != NodeDocument.NULL) {
                    return cached;
                }
                this.nodesCache.invalidate((Object)key);
            }
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    @Nonnull
    private static QueryBuilder createQueryForUpdate(UpdateOp updateOp, boolean checkConditions) {
        QueryBuilder query = MongoDocumentStore.getByKeyQuery(updateOp.getId());
        for (Map.Entry<UpdateOp.Key, UpdateOp.Operation> entry : updateOp.getChanges().entrySet()) {
            UpdateOp.Key k = entry.getKey();
            UpdateOp.Operation op = entry.getValue();
            switch (op.type) {
                case CONTAINS_MAP_ENTRY: {
                    if (!checkConditions) break;
                    query.and(k.toString()).exists(op.value);
                }
            }
        }
        return query;
    }

    @Nonnull
    private static DBObject createUpdate(UpdateOp updateOp) {
        BasicDBObject setUpdates = new BasicDBObject();
        BasicDBObject incUpdates = new BasicDBObject();
        BasicDBObject unsetUpdates = new BasicDBObject();
        updateOp.increment("_modCount", 1L);
        for (Map.Entry<UpdateOp.Key, UpdateOp.Operation> entry : updateOp.getChanges().entrySet()) {
            UpdateOp.Key k = entry.getKey();
            if (k.getName().equals("_id")) continue;
            UpdateOp.Operation op = entry.getValue();
            switch (op.type) {
                case SET: {
                    setUpdates.append(k.toString(), op.value);
                    break;
                }
                case INCREMENT: {
                    incUpdates.append(k.toString(), op.value);
                    break;
                }
                case SET_MAP_ENTRY: {
                    setUpdates.append(k.toString(), op.value);
                    break;
                }
                case REMOVE_MAP_ENTRY: {
                    unsetUpdates.append(k.toString(), (Object)"1");
                }
            }
        }
        BasicDBObject update = new BasicDBObject();
        if (!setUpdates.isEmpty()) {
            update.append("$set", (Object)setUpdates);
        }
        if (!incUpdates.isEmpty()) {
            update.append("$inc", (Object)incUpdates);
        }
        if (!unsetUpdates.isEmpty()) {
            update.append("$unset", (Object)unsetUpdates);
        }
        return update;
    }

    private Lock getAndLock(String key) {
        Lock l = (Lock)this.locks.get((Object)key);
        l.lock();
        return l;
    }

    @Override
    public void setReadWriteMode(String readWriteMode) {
        if (readWriteMode == null || readWriteMode.equals(this.lastReadWriteMode)) {
            return;
        }
        this.lastReadWriteMode = readWriteMode;
        try {
            WriteConcern writeConcern;
            String write;
            ReadPreference readPref;
            Map map = Splitter.on((String)", ").withKeyValueSeparator(":").split((CharSequence)readWriteMode);
            String read = (String)map.get("read");
            if (read != null && !(readPref = ReadPreference.valueOf((String)read)).equals(this.nodes.getReadPreference())) {
                this.nodes.setReadPreference(readPref);
                LOG.info("Using ReadPreference " + readPref);
            }
            if ((write = (String)map.get("write")) != null && !(writeConcern = WriteConcern.valueOf((String)write)).equals((Object)this.nodes.getWriteConcern())) {
                this.nodes.setWriteConcern(writeConcern);
                LOG.info("Using WriteConcern " + writeConcern);
            }
        }
        catch (Exception e) {
            LOG.error("Error setting readWriteMode " + readWriteMode, (Throwable)e);
        }
    }
}

