/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.TreeTraverser;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.document.CachedNodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class CacheInvalidator {
    static final Logger LOG = LoggerFactory.getLogger(CacheInvalidator.class);

    CacheInvalidator() {
    }

    public abstract InvalidationResult invalidateCache();

    public static CacheInvalidator createHierarchicalInvalidator(MongoDocumentStore documentStore) {
        return new HierarchicalInvalidator(documentStore);
    }

    public static CacheInvalidator createLinearInvalidator(MongoDocumentStore documentStore) {
        return new LinearInvalidator(documentStore);
    }

    public static CacheInvalidator createSimpleInvalidator(MongoDocumentStore documentStore) {
        return new SimpleInvalidator(documentStore);
    }

    private static class HierarchicalInvalidator
    extends CacheInvalidator {
        private static final TreeTraverser<TreeNode> TRAVERSER = new TreeTraverser<TreeNode>(){

            public Iterable<TreeNode> children(TreeNode root) {
                return root.children();
            }
        };
        public static final int IN_QUERY_BATCH_SIZE = 250;
        private final DBCollection nodes;
        private final MongoDocumentStore documentStore;

        public HierarchicalInvalidator(MongoDocumentStore documentStore) {
            this.documentStore = documentStore;
            this.nodes = documentStore.getDBCollection(Collection.NODES);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InvalidationResult invalidateCache() {
            InvalidationResult result = new InvalidationResult();
            TreeNode root = this.constructTreeFromPaths(this.documentStore.getCacheEntries(), result);
            long startTime = System.currentTimeMillis();
            Iterator treeItr = TRAVERSER.breadthFirstTraversal((Object)root).iterator();
            PeekingIterator pitr = Iterators.peekingIterator((Iterator)treeItr);
            HashMap sameLevelNodes = Maps.newHashMap();
            BasicDBObject keys = new BasicDBObject("_id", (Object)1);
            keys.put("_modCount", (Object)1);
            while (pitr.hasNext()) {
                TreeNode tn = (TreeNode)pitr.next();
                if (tn.isRoot()) {
                    tn.markUptodate(startTime);
                    continue;
                }
                if (tn.isUptodate(startTime)) {
                    ++result.upToDateCount;
                } else {
                    sameLevelNodes.put(tn.getId(), tn);
                }
                boolean hasMore = pitr.hasNext();
                if (sameLevelNodes.isEmpty() || (!hasMore || tn.level() == ((TreeNode)pitr.peek()).level()) && hasMore) continue;
                ArrayList sameLevelNodeIds = new ArrayList(sameLevelNodes.keySet());
                for (List idBatch : Lists.partition(sameLevelNodeIds, (int)250)) {
                    QueryBuilder query = QueryBuilder.start((String)"_id").in((Object)idBatch);
                    DBCursor cursor = this.nodes.find(query.get(), (DBObject)keys);
                    LOG.debug("Checking for changed nodes at level {} with {} paths", (Object)tn.level(), (Object)sameLevelNodes.size());
                    ++result.queryCount;
                    try {
                        for (DBObject obj : cursor) {
                            ++result.cacheEntriesProcessedCount;
                            Number latestModCount = (Number)obj.get("_modCount");
                            String id = (String)obj.get("_id");
                            TreeNode tn2 = (TreeNode)sameLevelNodes.get(id);
                            CachedNodeDocument cachedDoc = tn2.getDocument();
                            if (cachedDoc != null) {
                                boolean noChangeInModCount = Objects.equal((Object)latestModCount, (Object)cachedDoc.getModCount());
                                if (noChangeInModCount) {
                                    ++result.upToDateCount;
                                    tn2.markUptodate(startTime);
                                } else {
                                    ++result.invalidationCount;
                                    tn2.invalidate();
                                }
                            }
                            sameLevelNodes.remove(tn2.getId());
                        }
                    }
                    finally {
                        cursor.close();
                    }
                }
                if (!sameLevelNodes.isEmpty()) {
                    for (TreeNode leftOverNodes : sameLevelNodes.values()) {
                        leftOverNodes.invalidate();
                    }
                }
                sameLevelNodes.clear();
            }
            result.timeTaken = System.currentTimeMillis() - startTime;
            LOG.debug("Cache invalidation details - {}", (Object)result);
            return result;
        }

        private TreeNode constructTreeFromPaths(Iterable<? extends Map.Entry<CacheValue, ? extends CachedNodeDocument>> entries, InvalidationResult result) {
            TreeNode root = new TreeNode("");
            for (Map.Entry<CacheValue, ? extends CachedNodeDocument> entry : entries) {
                String path;
                TreeNode current = root;
                ++result.cacheSize;
                CachedNodeDocument doc = entry.getValue();
                if (doc == NodeDocument.NULL) {
                    String id = entry.getKey().toString();
                    if (Utils.isIdFromLongPath(id)) {
                        LOG.debug("Negative cache entry with long path {}. Invalidating", (Object)id);
                        this.documentStore.invalidateCache(Collection.NODES, id);
                        path = null;
                    } else {
                        path = Utils.getPathFromId(id);
                    }
                } else {
                    path = doc.getPath();
                }
                if (path == null) continue;
                for (String name : PathUtils.elements((String)path)) {
                    current = current.child(name);
                }
            }
            return root;
        }

        private class TreeNode {
            private final String name;
            private final TreeNode parent;
            private final String id;
            private final Map<String, TreeNode> children = new HashMap<String, TreeNode>();

            public TreeNode(String name) {
                this(null, name);
            }

            public TreeNode(TreeNode parent, String name) {
                this.name = name;
                this.parent = parent;
                this.id = Utils.getIdFromPath(this.getPath());
            }

            public TreeNode child(String name) {
                TreeNode child = this.children.get(name);
                if (child == null) {
                    child = new TreeNode(this, name);
                    this.children.put(name, child);
                }
                return child;
            }

            public Iterable<TreeNode> children() {
                return this.children.values();
            }

            public String getId() {
                return this.id;
            }

            public int level() {
                return Utils.pathDepth(this.getPath());
            }

            public TreeNode getParent() {
                return this.parent;
            }

            public boolean isRoot() {
                return this.name.isEmpty();
            }

            public String getPath() {
                if (this.isRoot()) {
                    return "/";
                }
                StringBuilder sb = new StringBuilder();
                this.buildPath(sb);
                return sb.toString();
            }

            public void invalidate() {
                LOG.debug("Change detected for {}. Invalidating the cached entry", (Object)this.getId());
                HierarchicalInvalidator.this.documentStore.invalidateCache(Collection.NODES, this.getId());
            }

            public CachedNodeDocument getDocument() {
                return HierarchicalInvalidator.this.documentStore.getCachedNodeDoc(this.id);
            }

            public boolean isUptodate(long time) {
                CachedNodeDocument doc = HierarchicalInvalidator.this.documentStore.getCachedNodeDoc(this.id);
                if (doc != null) {
                    return doc.isUpToDate(time);
                }
                return true;
            }

            public void markUptodate(long cacheCheckTime) {
                CachedNodeDocument doc = this.getDocument();
                if (doc == null) {
                    return;
                }
                this.markUptodate(cacheCheckTime, doc);
            }

            public String toString() {
                return this.id;
            }

            private void markUptodate(long cacheCheckTime, CachedNodeDocument upToDateRoot) {
                for (TreeNode tn : this.children.values()) {
                    tn.markUptodate(cacheCheckTime, upToDateRoot);
                }
                this.markUptodate(this.getId(), cacheCheckTime, upToDateRoot);
            }

            private void markUptodate(String key, long time, CachedNodeDocument upToDateRoot) {
                CachedNodeDocument doc = HierarchicalInvalidator.this.documentStore.getCachedNodeDoc(key);
                if (doc == null) {
                    return;
                }
                if (doc.getCreated() >= upToDateRoot.getCreated() || doc.getLastCheckTime() == upToDateRoot.getLastCheckTime()) {
                    doc.markUpToDate(time);
                }
            }

            private void buildPath(StringBuilder sb) {
                if (!this.isRoot()) {
                    this.getParent().buildPath(sb);
                    sb.append('/').append(this.name);
                }
            }
        }
    }

    private static class LinearInvalidator
    extends CacheInvalidator {
        private final DBCollection nodes;
        private final MongoDocumentStore documentStore;

        public LinearInvalidator(MongoDocumentStore documentStore) {
            this.documentStore = documentStore;
            this.nodes = documentStore.getDBCollection(Collection.NODES);
        }

        @Override
        public InvalidationResult invalidateCache() {
            InvalidationResult result = new InvalidationResult();
            int size = 0;
            ArrayList<String> cachedKeys = new ArrayList<String>();
            for (Map.Entry<CacheValue, ? extends CachedNodeDocument> entry : this.documentStore.getCacheEntries()) {
                ++size;
                cachedKeys.add(entry.getKey().toString());
            }
            result.cacheSize = size;
            QueryBuilder query = QueryBuilder.start((String)"_id").in(cachedKeys);
            BasicDBObject basicDBObject = new BasicDBObject("_id", (Object)1);
            basicDBObject.put("_modCount", (Object)1);
            DBCursor cursor = this.nodes.find(query.get(), (DBObject)basicDBObject);
            ++result.queryCount;
            for (DBObject obj : cursor) {
                ++result.cacheEntriesProcessedCount;
                String id = (String)obj.get("_id");
                Number modCount = (Number)obj.get("_modCount");
                CachedNodeDocument cachedDoc = this.documentStore.getCachedNodeDoc(id);
                if (cachedDoc != null && !Objects.equal((Object)cachedDoc.getModCount(), (Object)modCount)) {
                    this.documentStore.invalidateCache(Collection.NODES, id);
                    ++result.invalidationCount;
                    continue;
                }
                ++result.upToDateCount;
            }
            return result;
        }
    }

    private static class SimpleInvalidator
    extends CacheInvalidator {
        private final MongoDocumentStore documentStore;

        private SimpleInvalidator(MongoDocumentStore documentStore) {
            this.documentStore = documentStore;
        }

        @Override
        public InvalidationResult invalidateCache() {
            InvalidationResult result = new InvalidationResult();
            int size = 0;
            for (Map.Entry<CacheValue, ? extends CachedNodeDocument> entry : this.documentStore.getCacheEntries()) {
                ++size;
                this.documentStore.invalidateCache(Collection.NODES, entry.getKey().toString());
            }
            result.cacheSize = size;
            return result;
        }
    }

    static class InvalidationResult {
        int invalidationCount;
        int upToDateCount;
        int cacheSize;
        long timeTaken;
        int queryCount;
        int cacheEntriesProcessedCount;

        InvalidationResult() {
        }

        public String toString() {
            return "InvalidationResult{invalidationCount=" + this.invalidationCount + ", upToDateCount=" + this.upToDateCount + ", cacheSize=" + this.cacheSize + ", timeTaken=" + this.timeTaken + ", queryCount=" + this.queryCount + ", cacheEntriesProcessedCount=" + this.cacheEntriesProcessedCount + '}';
        }
    }
}

