/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionContext;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.UpdateUtils;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Collision {
    private static final Logger LOG = LoggerFactory.getLogger(Collision.class);
    private final NodeDocument document;
    private final Revision theirRev;
    private final UpdateOp ourOp;
    private final Revision ourRev;
    private final RevisionContext context;

    Collision(@Nonnull NodeDocument document, @Nonnull Revision theirRev, @Nonnull UpdateOp ourOp, @Nonnull Revision ourRev, @Nonnull RevisionContext context) {
        this.document = (NodeDocument)Preconditions.checkNotNull((Object)document);
        this.theirRev = (Revision)Preconditions.checkNotNull((Object)theirRev);
        this.ourOp = (UpdateOp)Preconditions.checkNotNull((Object)ourOp);
        this.ourRev = (Revision)Preconditions.checkNotNull((Object)ourRev);
        this.context = (RevisionContext)Preconditions.checkNotNull((Object)context);
    }

    @Nonnull
    Revision mark(DocumentStore store) throws MicroKernelException {
        if (Collision.markCommitRoot(this.document, this.theirRev, store)) {
            return this.theirRev;
        }
        NodeDocument newDoc = Collection.NODES.newDocument(store);
        this.document.deepCopy(newDoc);
        UpdateUtils.applyChanges(newDoc, this.ourOp, this.context.getRevisionComparator());
        if (!Collision.markCommitRoot(newDoc, this.ourRev, store)) {
            throw new IllegalStateException("Unable to annotate our revision with collision marker. Our revision: " + this.ourRev + ", document:\n" + newDoc.format());
        }
        return this.ourRev;
    }

    private static boolean markCommitRoot(@Nonnull NodeDocument document, @Nonnull Revision revision, @Nonnull DocumentStore store) {
        String p = document.getPath();
        String commitRootPath = null;
        if (document.containsRevision(revision)) {
            if (document.isCommitted(revision)) {
                return false;
            }
            commitRootPath = p;
        } else {
            commitRootPath = document.getCommitRootPath(revision);
            if (commitRootPath == null) {
                Collision.throwNoCommitRootException(revision, document);
            }
        }
        UpdateOp op = new UpdateOp(Utils.getIdFromPath(commitRootPath), false);
        NodeDocument commitRoot = store.find(Collection.NODES, op.getId());
        if (commitRoot.isCommitted(revision)) {
            return false;
        }
        op.setMapEntry("_collisions", revision, true);
        commitRoot = store.createOrUpdate(Collection.NODES, op);
        if (commitRoot.isCommitted(revision)) {
            return false;
        }
        LOG.debug("Marked collision on: {} for {} ({})", new Object[]{commitRootPath, p, revision});
        return true;
    }

    private static void throwNoCommitRootException(@Nonnull Revision revision, @Nonnull Document document) throws MicroKernelException {
        throw new MicroKernelException("No commit root for revision: " + revision + ", document: " + document.format());
    }
}

