/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob;

import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.commons.sort.ExternalSort;

class GarbageCollectorFileState
implements Closeable {
    private final File home;
    private final File markedRefs;
    private final File availableRefs;
    private final File gcCandidates;
    private final File garbage;

    public GarbageCollectorFileState(String root) throws IOException {
        long startTime = System.currentTimeMillis();
        this.home = new File(root, "gcworkdir-" + startTime);
        this.markedRefs = new File(this.home, "marked-" + startTime);
        this.availableRefs = new File(this.home, "avail-" + startTime);
        this.gcCandidates = new File(this.home, "gccand-" + startTime);
        this.garbage = new File(this.home, "gc-" + startTime);
        FileUtils.forceMkdir((File)this.home);
    }

    public File getMarkedRefs() {
        return this.markedRefs;
    }

    public File getAvailableRefs() {
        return this.availableRefs;
    }

    public File getGcCandidates() {
        return this.gcCandidates;
    }

    public File getGarbage() {
        return this.garbage;
    }

    @Override
    public void close() throws IOException {
        if (!this.getGarbage().exists() || FileUtils.sizeOf((File)this.getGarbage()) == 0L) {
            FileUtils.deleteDirectory((File)this.home);
        }
    }

    public void sort(File file) throws IOException {
        File sorted = this.createTempFile();
        Comparator<String> lexComparator = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareTo(s2);
            }
        };
        ExternalSort.mergeSortedFiles((List)ExternalSort.sortInBatch((File)file, (Comparator)lexComparator, (boolean)true), (File)sorted, (Comparator)lexComparator, (boolean)true);
        Files.move((File)sorted, (File)file);
    }

    private File createTempFile() throws IOException {
        return File.createTempFile("temp", null, this.home);
    }
}

