/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.core.HiddenTree;
import org.apache.jackrabbit.oak.core.MutableRoot;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.tree.AbstractTree;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;

class MutableTree
extends AbstractTree {
    private final MutableRoot root;
    private MutableTree parent;
    private MutableRoot.Move pendingMoves;

    MutableTree(MutableRoot root, NodeBuilder builder, MutableRoot.Move pendingMoves) {
        super("", builder);
        this.root = (MutableRoot)Preconditions.checkNotNull((Object)root);
        this.pendingMoves = (MutableRoot.Move)Preconditions.checkNotNull((Object)pendingMoves);
    }

    private MutableTree(MutableRoot root, MutableTree parent, String name, MutableRoot.Move pendingMoves) {
        super(name, parent.nodeBuilder.getChildNode(name));
        this.root = (MutableRoot)Preconditions.checkNotNull((Object)root);
        this.parent = (MutableTree)Preconditions.checkNotNull((Object)parent);
        this.pendingMoves = (MutableRoot.Move)Preconditions.checkNotNull((Object)pendingMoves);
    }

    @Override
    protected MutableTree createChild(String name) throws IllegalArgumentException {
        return new MutableTree(this.root, this, name, this.pendingMoves);
    }

    @Override
    public String getName() {
        this.beforeRead();
        return this.name;
    }

    @Override
    public String getPath() {
        this.beforeRead();
        return super.getPath();
    }

    @Override
    public Tree.Status getStatus() {
        this.beforeRead();
        return super.getStatus();
    }

    @Override
    public boolean exists() {
        this.beforeRead();
        return super.exists();
    }

    @Override
    public MutableTree getParent() {
        this.beforeRead();
        Preconditions.checkState((this.parent != null ? 1 : 0) != 0, (Object)"root tree does not have a parent");
        return this.parent;
    }

    @Override
    public PropertyState getProperty(String name) {
        this.beforeRead();
        return super.getProperty(name);
    }

    @Override
    public boolean hasProperty(String name) {
        this.beforeRead();
        return super.hasProperty(name);
    }

    @Override
    public long getPropertyCount() {
        this.beforeRead();
        return super.getPropertyCount();
    }

    @Override
    public Tree.Status getPropertyStatus(String name) {
        this.beforeRead();
        return super.getPropertyStatus(name);
    }

    @Override
    public Iterable<? extends PropertyState> getProperties() {
        this.beforeRead();
        return super.getProperties();
    }

    @Override
    public Tree getChild(String name) {
        this.beforeRead();
        if (super.hasChild(name)) {
            return this.createChild(name);
        }
        return new HiddenTree(this, name);
    }

    @Override
    public boolean hasChild(String name) {
        this.beforeRead();
        return super.hasChild(name);
    }

    @Override
    public long getChildrenCount(long max) {
        this.beforeRead();
        return super.getChildrenCount(max);
    }

    @Override
    public Iterable<Tree> getChildren() {
        this.beforeRead();
        return super.getChildren();
    }

    @Override
    public boolean remove() {
        this.beforeWrite();
        if (this.parent != null && this.parent.hasChild(this.name)) {
            this.nodeBuilder.remove();
            PropertyState order = this.parent.nodeBuilder.getProperty(":childOrder");
            if (order != null) {
                ArrayList names = Lists.newArrayListWithCapacity((int)order.count());
                for (String n : order.getValue(Type.NAMES)) {
                    if (n.equals(this.name)) continue;
                    names.add(n);
                }
                this.parent.nodeBuilder.setProperty(":childOrder", names, Type.NAMES);
            }
            this.root.updated();
            return true;
        }
        return false;
    }

    @Override
    public Tree addChild(String name) {
        Preconditions.checkArgument((!NodeStateUtils.isHidden(name) ? 1 : 0) != 0);
        this.beforeWrite();
        if (!super.hasChild(name)) {
            this.nodeBuilder.setChildNode(name);
            PropertyState order = this.nodeBuilder.getProperty(":childOrder");
            if (order != null) {
                ArrayList names = Lists.newArrayListWithCapacity((int)(order.count() + 1));
                for (String n : order.getValue(Type.NAMES)) {
                    if (n.equals(name)) continue;
                    names.add(n);
                }
                names.add(name);
                this.nodeBuilder.setProperty(":childOrder", names, Type.NAMES);
            }
            this.root.updated();
        }
        return this.createChild(name);
    }

    @Override
    public void setOrderableChildren(boolean enable) {
        this.beforeWrite();
        if (enable) {
            this.updateChildOrder(true);
        } else {
            this.nodeBuilder.removeProperty(":childOrder");
        }
    }

    @Override
    public boolean orderBefore(String name) {
        this.beforeWrite();
        if (this.parent == null) {
            return false;
        }
        if (name != null && (name.equals(this.name) || !this.parent.hasChild(name))) {
            return false;
        }
        ArrayList names = Lists.newArrayList();
        for (String n : this.parent.getChildNames()) {
            if (n.equals(name)) {
                names.add(this.name);
            }
            if (n.equals(this.name)) continue;
            names.add(n);
        }
        if (name == null) {
            names.add(this.name);
        }
        this.parent.nodeBuilder.setProperty(":childOrder", names, Type.NAMES);
        this.root.updated();
        return true;
    }

    @Override
    public void setProperty(PropertyState property) {
        Preconditions.checkArgument((!NodeStateUtils.isHidden(property.getName()) ? 1 : 0) != 0);
        this.beforeWrite();
        this.nodeBuilder.setProperty(property);
        this.root.updated();
    }

    @Override
    public <T> void setProperty(String name, T value) {
        Preconditions.checkArgument((!NodeStateUtils.isHidden(name) ? 1 : 0) != 0);
        this.beforeWrite();
        this.nodeBuilder.setProperty(name, value);
        this.root.updated();
    }

    @Override
    public <T> void setProperty(String name, T value, Type<T> type) {
        Preconditions.checkArgument((!NodeStateUtils.isHidden(name) ? 1 : 0) != 0);
        this.beforeWrite();
        this.nodeBuilder.setProperty(name, value, type);
        this.root.updated();
    }

    @Override
    public void removeProperty(String name) {
        this.beforeWrite();
        this.nodeBuilder.removeProperty(name);
        this.root.updated();
    }

    void setParentAndName(MutableTree parent, String name) {
        this.name = name;
        this.parent = parent;
    }

    boolean moveTo(MutableTree newParent, String newName) {
        this.name = newName;
        this.parent = newParent;
        return this.nodeBuilder.moveTo(newParent.nodeBuilder, newName);
    }

    @CheckForNull
    MutableTree getTree(@Nonnull String path) {
        Preconditions.checkArgument((boolean)PathUtils.isAbsolute((String)((String)Preconditions.checkNotNull((Object)path))));
        this.beforeRead();
        MutableTree child = this;
        for (String name : PathUtils.elements((String)path)) {
            child = new MutableTree(this.root, child, name, this.pendingMoves);
        }
        return child;
    }

    void updateChildOrder(boolean force) {
        if (force || this.hasOrderableChildren()) {
            this.nodeBuilder.setProperty(PropertyStates.createProperty(":childOrder", this.getChildNames(), Type.NAMES));
        }
    }

    String getPathInternal() {
        if (this.parent == null) {
            return "/";
        }
        StringBuilder sb = new StringBuilder();
        this.buildPath(sb);
        return sb.toString();
    }

    @Override
    protected void buildPath(StringBuilder sb) {
        if (this.parent != null) {
            this.parent.buildPath(sb);
            sb.append('/').append(this.name);
        }
    }

    private void reconnect() {
        if (this.parent != null) {
            this.parent.reconnect();
            this.nodeBuilder = this.parent.nodeBuilder.getChildNode(this.name);
        }
    }

    private void beforeRead() throws IllegalStateException {
        this.root.checkLive();
        if (this.applyPendingMoves()) {
            this.reconnect();
        }
    }

    private void beforeWrite() throws IllegalStateException {
        this.beforeRead();
        if (!super.exists()) {
            throw new IllegalStateException("This tree does not exist");
        }
    }

    private boolean applyPendingMoves() {
        boolean movesApplied = false;
        if (this.parent != null) {
            movesApplied = this.parent.applyPendingMoves();
        }
        MutableRoot.Move old = this.pendingMoves;
        this.pendingMoves = this.pendingMoves.apply(this);
        if (this.pendingMoves != old) {
            movesApplied = true;
        }
        return movesApplied;
    }
}

