/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.client;

import java.rmi.RemoteException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import org.apache.jackrabbit.rmi.client.ClientObject;
import org.apache.jackrabbit.rmi.client.LocalAdapterFactory;
import org.apache.jackrabbit.rmi.client.RemoteRepositoryException;
import org.apache.jackrabbit.rmi.remote.RemoteNodeTypeManager;

public class ClientNodeTypeManager
extends ClientObject
implements NodeTypeManager {
    private RemoteNodeTypeManager remote;

    public ClientNodeTypeManager(RemoteNodeTypeManager remote, LocalAdapterFactory factory) {
        super(factory);
        this.remote = remote;
    }

    public NodeType getNodeType(String name) throws RepositoryException {
        try {
            return this.getFactory().getNodeType(this.remote.getNodeType(name));
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public NodeTypeIterator getAllNodeTypes() throws RepositoryException {
        try {
            return this.getFactory().getNodeTypeIterator(this.remote.getAllNodeTypes());
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public NodeTypeIterator getPrimaryNodeTypes() throws RepositoryException {
        try {
            return this.getFactory().getNodeTypeIterator(this.remote.getPrimaryNodeTypes());
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public NodeTypeIterator getMixinNodeTypes() throws RepositoryException {
        try {
            return this.getFactory().getNodeTypeIterator(this.remote.getMixinNodeTypes());
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public NodeDefinitionTemplate createNodeDefinitionTemplate() throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("TODO: JCRRMI-26");
    }

    public NodeTypeTemplate createNodeTypeTemplate() throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("TODO: JCRRMI-26");
    }

    public NodeTypeTemplate createNodeTypeTemplate(NodeTypeDefinition ntd) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("TODO: JCRRMI-26");
    }

    public PropertyDefinitionTemplate createPropertyDefinitionTemplate() throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("TODO: JCRRMI-26");
    }

    public boolean hasNodeType(String name) throws RepositoryException {
        try {
            return this.remote.hasNodeType(name);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public NodeType registerNodeType(NodeTypeDefinition ntd, boolean allowUpdate) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("TODO: JCRRMI-26");
    }

    public NodeTypeIterator registerNodeTypes(NodeTypeDefinition[] ntds, boolean allowUpdate) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("TODO: JCRRMI-26");
    }

    public void unregisterNodeType(String name) throws RepositoryException {
        this.unregisterNodeTypes(new String[]{name});
    }

    public void unregisterNodeTypes(String[] names) throws RepositoryException {
        try {
            this.remote.unregisterNodeTypes(names);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }
}

