/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.repository;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.api.security.authentication.token.TokenCredentials;
import org.apache.jackrabbit.commons.SimpleValueFactory;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.api.ContentSession;
import org.apache.jackrabbit.oak.api.jmx.SessionMBean;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.repository.JcrDescriptorsImpl;
import org.apache.jackrabbit.oak.jcr.session.RefreshStrategy;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.jcr.session.SessionStats;
import org.apache.jackrabbit.oak.plugins.observation.CommitRateLimiter;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.stats.Clock;
import org.apache.jackrabbit.oak.stats.StatisticManager;
import org.apache.jackrabbit.oak.util.GenericDescriptors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryImpl
implements JackrabbitRepository {
    private static final Logger log = LoggerFactory.getLogger(RepositoryImpl.class);
    public static final String REFRESH_INTERVAL = "oak.refresh-interval";
    public static final String RELAXED_LOCKING = "oak.relaxed-locking";
    private final GenericDescriptors descriptors;
    private final ContentRepository contentRepository;
    protected final Whiteboard whiteboard;
    private final SecurityProvider securityProvider;
    private final int observationQueueLength;
    private final CommitRateLimiter commitRateLimiter;
    private final Clock clock;
    private final ThreadLocal<Long> threadSaveCount = new ThreadLocal();
    private final ListeningScheduledExecutorService scheduledExecutor = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newSingleThreadScheduledExecutor());
    private final StatisticManager statisticManager;

    public RepositoryImpl(@Nonnull ContentRepository contentRepository, @Nonnull Whiteboard whiteboard, @Nonnull SecurityProvider securityProvider, int observationQueueLength, CommitRateLimiter commitRateLimiter) {
        this.contentRepository = (ContentRepository)Preconditions.checkNotNull((Object)contentRepository);
        this.whiteboard = (Whiteboard)Preconditions.checkNotNull((Object)whiteboard);
        this.securityProvider = (SecurityProvider)Preconditions.checkNotNull((Object)securityProvider);
        this.observationQueueLength = observationQueueLength;
        this.commitRateLimiter = commitRateLimiter;
        this.descriptors = this.determineDescriptors();
        this.statisticManager = new StatisticManager(whiteboard, (ScheduledExecutorService)this.scheduledExecutor);
        this.clock = new Clock.Fast((ScheduledExecutorService)this.scheduledExecutor);
    }

    public String[] getDescriptorKeys() {
        return this.descriptors.getKeys();
    }

    public boolean isStandardDescriptor(String key) {
        return this.descriptors.isStandardDescriptor(key);
    }

    public String getDescriptor(String key) {
        try {
            Value v = this.getDescriptorValue(key);
            return v == null ? null : v.getString();
        }
        catch (RepositoryException e) {
            log.debug("Error converting value for descriptor with key {} to string", (Object)key);
            return null;
        }
    }

    public Value getDescriptorValue(String key) {
        return this.descriptors.getValue(key);
    }

    public Value[] getDescriptorValues(String key) {
        return this.descriptors.getValues(key);
    }

    public boolean isSingleValueDescriptor(String key) {
        return this.descriptors.isSingleValueDescriptor(key);
    }

    public Session login(@Nullable Credentials credentials, @Nullable String workspaceName) throws RepositoryException {
        return this.login(credentials, workspaceName, null);
    }

    public Session login() throws RepositoryException {
        return this.login(null, null, null);
    }

    public Session login(Credentials credentials) throws RepositoryException {
        return this.login(credentials, null, null);
    }

    public Session login(String workspace) throws RepositoryException {
        return this.login(null, workspace, null);
    }

    public Session login(@CheckForNull Credentials credentials, @CheckForNull String workspaceName, @CheckForNull Map<String, Object> attributes) throws RepositoryException {
        try {
            Long refreshInterval;
            if (attributes == null) {
                attributes = Collections.emptyMap();
            }
            if ((refreshInterval = RepositoryImpl.getRefreshInterval(credentials)) == null) {
                refreshInterval = RepositoryImpl.getRefreshInterval(attributes);
            } else if (attributes.containsKey(REFRESH_INTERVAL)) {
                throw new RepositoryException("Duplicate attribute 'oak.refresh-interval'.");
            }
            boolean relaxedLocking = RepositoryImpl.getRelaxedLocking(attributes);
            RefreshStrategy refreshStrategy = this.createRefreshStrategy(refreshInterval);
            ContentSession contentSession = this.contentRepository.login(credentials, workspaceName);
            SessionDelegate sessionDelegate = this.createSessionDelegate(refreshStrategy, contentSession);
            SessionContext context = this.createSessionContext(this.statisticManager, this.securityProvider, RepositoryImpl.createAttributes(refreshInterval, relaxedLocking), sessionDelegate, this.observationQueueLength, this.commitRateLimiter);
            return context.getSession();
        }
        catch (javax.security.auth.login.LoginException e) {
            throw new LoginException(e.getMessage(), (Throwable)e);
        }
    }

    private SessionDelegate createSessionDelegate(RefreshStrategy refreshStrategy, ContentSession contentSession) {
        return new SessionDelegate(contentSession, this.securityProvider, refreshStrategy, this.threadSaveCount, this.statisticManager, this.clock){
            ListenableScheduledFuture<Registration> registration;
            {
                this.registration = RepositoryImpl.this.scheduledExecutor.schedule((Callable)new RegistrationCallable(this.getSessionStats(), RepositoryImpl.this.whiteboard), 1L, TimeUnit.MINUTES);
            }

            @Override
            public void logout() {
                this.registration.cancel(false);
                Futures.addCallback(this.registration, (FutureCallback)new FutureCallback<Registration>(){

                    public void onSuccess(Registration registration) {
                        registration.unregister();
                    }

                    public void onFailure(Throwable t) {
                    }
                });
                super.logout();
            }
        };
    }

    public void shutdown() {
        this.statisticManager.dispose();
        this.scheduledExecutor.shutdown();
    }

    protected SessionContext createSessionContext(StatisticManager statisticManager, SecurityProvider securityProvider, Map<String, Object> attributes, SessionDelegate delegate, int observationQueueLength, CommitRateLimiter commitRateLimiter) {
        return new SessionContext((Repository)this, statisticManager, securityProvider, this.whiteboard, attributes, delegate, observationQueueLength, commitRateLimiter);
    }

    protected GenericDescriptors determineDescriptors() {
        return new JcrDescriptorsImpl(this.contentRepository.getDescriptors(), (ValueFactory)new SimpleValueFactory());
    }

    protected GenericDescriptors getDescriptors() {
        return this.descriptors;
    }

    private static Long getRefreshInterval(Credentials credentials) {
        String value;
        if (credentials instanceof SimpleCredentials) {
            Object value2 = ((SimpleCredentials)credentials).getAttribute(REFRESH_INTERVAL);
            return RepositoryImpl.toLong(value2);
        }
        if (credentials instanceof TokenCredentials && (value = ((TokenCredentials)credentials).getAttribute(REFRESH_INTERVAL)) != null) {
            return RepositoryImpl.toLong(value);
        }
        return null;
    }

    private static Long getRefreshInterval(Map<String, Object> attributes) {
        return RepositoryImpl.toLong(attributes.get(REFRESH_INTERVAL));
    }

    private static boolean getRelaxedLocking(Map<String, Object> attributes) {
        Object value = attributes.get(RELAXED_LOCKING);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return false;
    }

    private static Long toLong(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof String) {
            return RepositoryImpl.toLong((String)value);
        }
        return null;
    }

    private static Long toLong(String longValue) {
        try {
            return Long.valueOf(longValue);
        }
        catch (NumberFormatException e) {
            log.warn("Invalid value '" + longValue + "' for " + REFRESH_INTERVAL + ". Expected long. ", (Throwable)e);
            return null;
        }
    }

    private static Map<String, Object> createAttributes(Long refreshInterval, boolean relaxedLocking) {
        if (refreshInterval == null && !relaxedLocking) {
            return Collections.emptyMap();
        }
        if (refreshInterval == null) {
            return Collections.singletonMap(RELAXED_LOCKING, relaxedLocking);
        }
        if (!relaxedLocking) {
            return Collections.singletonMap(REFRESH_INTERVAL, refreshInterval);
        }
        return ImmutableMap.of((Object)REFRESH_INTERVAL, (Object)refreshInterval, (Object)RELAXED_LOCKING, (Object)relaxedLocking);
    }

    private RefreshStrategy createRefreshStrategy(Long refreshInterval) {
        if (refreshInterval == null) {
            return new RefreshStrategy.LogOnce(60L);
        }
        return new RefreshStrategy.Timed(refreshInterval);
    }

    private static class RegistrationCallable
    implements Callable<Registration> {
        private final SessionStats sessionStats;
        private final Whiteboard whiteboard;

        public RegistrationCallable(SessionStats sessionStats, Whiteboard whiteboard) {
            this.sessionStats = sessionStats;
            this.whiteboard = whiteboard;
        }

        @Override
        public Registration call() throws Exception {
            return WhiteboardUtils.registerMBean((Whiteboard)this.whiteboard, SessionMBean.class, (Object)this.sessionStats, (String)"SessionStatistics", (String)this.sessionStats.toString());
        }
    }
}

