/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.delegate;

import javax.annotation.Nonnull;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Impersonation;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.oak.jcr.delegate.AuthorizableDelegator;
import org.apache.jackrabbit.oak.jcr.delegate.ImpersonationDelegator;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;

final class UserDelegator
extends AuthorizableDelegator
implements User {
    private UserDelegator(SessionDelegate sessionDelegate, User userDelegate) {
        super(sessionDelegate, (Authorizable)userDelegate);
    }

    static User wrap(SessionDelegate sessionDelegate, User user) {
        if (user == null) {
            return null;
        }
        return new UserDelegator(sessionDelegate, user);
    }

    @Nonnull
    static User unwrap(@Nonnull User user) {
        if (user instanceof UserDelegator) {
            return ((UserDelegator)user).getDelegate();
        }
        return user;
    }

    private User getDelegate() {
        return (User)this.delegate;
    }

    public boolean isAdmin() {
        return this.sessionDelegate.safePerform(new SessionOperation<Boolean>("isAdmin"){

            @Override
            public Boolean perform() {
                return UserDelegator.this.getDelegate().isAdmin();
            }
        });
    }

    public Credentials getCredentials() {
        return this.sessionDelegate.safePerform(new SessionOperation<Credentials>("getCredentials"){

            @Override
            public Credentials perform() throws RepositoryException {
                return UserDelegator.this.getDelegate().getCredentials();
            }
        });
    }

    public Impersonation getImpersonation() {
        return this.sessionDelegate.safePerform(new SessionOperation<Impersonation>("getImpersonation"){

            @Override
            public Impersonation perform() throws RepositoryException {
                Impersonation impersonation = UserDelegator.this.getDelegate().getImpersonation();
                return ImpersonationDelegator.wrap(UserDelegator.this.sessionDelegate, impersonation);
            }
        });
    }

    public void changePassword(final String password) throws RepositoryException {
        this.sessionDelegate.perform(new SessionOperation<Void>("changePassword"){

            @Override
            public Void perform() throws RepositoryException {
                UserDelegator.this.getDelegate().changePassword(password);
                return null;
            }
        });
    }

    public void changePassword(final String password, final String oldPassword) throws RepositoryException {
        this.sessionDelegate.perform(new SessionOperation<Void>("changePassword"){

            @Override
            public Void perform() throws RepositoryException {
                UserDelegator.this.getDelegate().changePassword(password, oldPassword);
                return null;
            }
        });
    }

    public void disable(final String reason) throws RepositoryException {
        this.sessionDelegate.perform(new SessionOperation<Void>("disable"){

            @Override
            public Void perform() throws RepositoryException {
                UserDelegator.this.getDelegate().disable(reason);
                return null;
            }
        });
    }

    public boolean isDisabled() throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Boolean>("isDisabled"){

            @Override
            public Boolean perform() throws RepositoryException {
                return UserDelegator.this.getDelegate().isDisabled();
            }
        });
    }

    public String getDisabledReason() throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<String>("getDisabledReason"){

            @Override
            public String perform() throws RepositoryException {
                return UserDelegator.this.getDelegate().getDisabledReason();
            }
        });
    }
}

