/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.delegate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.ItemExistsException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.oak.api.AuthInfo;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.ContentSession;
import org.apache.jackrabbit.oak.api.QueryEngine;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.jcr.delegate.ItemDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.NodeDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.PropertyDelegate;
import org.apache.jackrabbit.oak.jcr.session.RefreshStrategy;
import org.apache.jackrabbit.oak.jcr.session.SessionStats;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.apache.jackrabbit.oak.plugins.identifier.IdentifierManager;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.stats.Clock;
import org.apache.jackrabbit.oak.stats.StatisticManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class SessionDelegate {
    static final Logger log = LoggerFactory.getLogger(SessionDelegate.class);
    static final Logger operationLogger = LoggerFactory.getLogger((String)"org.apache.jackrabbit.oak.jcr.operations");
    private final ContentSession contentSession;
    private final SecurityProvider securityProvider;
    private final RefreshStrategy refreshStrategy;
    private boolean refreshAtNextAccess = false;
    private final ThreadLocal<Long> threadSaveCount;
    private long sessionSaveCount;
    private final Root root;
    private final IdentifierManager idManager;
    private final SessionStats sessionStats;
    private final Clock clock;
    private final long loginTime;
    private long accessTime;
    private long readTime = 0L;
    private long writeTime = 0L;
    private long refreshTime = 0L;
    private long saveTime = 0L;
    private long readCount = 0L;
    private long writeCount = 0L;
    private long refreshCount = 0L;
    private long saveCount = 0L;
    private final AtomicLong readCounter;
    private final AtomicLong readDuration;
    private final AtomicLong writeCounter;
    private final AtomicLong writeDuration;
    private boolean isAlive = true;
    private int sessionOpCount;
    private long updateCount = 0L;
    private String userData = null;
    private PermissionProvider permissionProvider;
    private final Lock lock = new ReentrantLock();

    public SessionDelegate(@Nonnull ContentSession contentSession, @Nonnull SecurityProvider securityProvider, @Nonnull RefreshStrategy refreshStrategy, @Nonnull ThreadLocal<Long> threadSaveCount, @Nonnull StatisticManager statisticManager, @Nonnull Clock clock) {
        this.contentSession = (ContentSession)Preconditions.checkNotNull((Object)contentSession);
        this.securityProvider = (SecurityProvider)Preconditions.checkNotNull((Object)securityProvider);
        this.refreshStrategy = (RefreshStrategy)Preconditions.checkNotNull((Object)refreshStrategy);
        this.threadSaveCount = (ThreadLocal)Preconditions.checkNotNull(threadSaveCount);
        this.sessionSaveCount = this.getThreadSaveCount();
        this.root = contentSession.getLatestRoot();
        this.idManager = new IdentifierManager(this.root);
        this.sessionStats = new SessionStats(this);
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
        this.accessTime = this.loginTime = clock.getTime();
        Preconditions.checkNotNull((Object)statisticManager);
        this.readCounter = statisticManager.getCounter(RepositoryStatistics.Type.SESSION_READ_COUNTER);
        this.readDuration = statisticManager.getCounter(RepositoryStatistics.Type.SESSION_READ_DURATION);
        this.writeCounter = statisticManager.getCounter(RepositoryStatistics.Type.SESSION_WRITE_COUNTER);
        this.writeDuration = statisticManager.getCounter(RepositoryStatistics.Type.SESSION_WRITE_DURATION);
    }

    @Nonnull
    public SessionStats getSessionStats() {
        return this.sessionStats;
    }

    private long getThreadSaveCount() {
        Long c = this.threadSaveCount.get();
        return c == null ? 0L : c;
    }

    public long getSecondsSinceLogin() {
        return TimeUnit.SECONDS.convert(this.clock.getTime() - this.loginTime, TimeUnit.MILLISECONDS);
    }

    public Date getLoginTime() {
        return new Date(this.loginTime);
    }

    private Date getTime(long timestamp) {
        if (timestamp != 0L) {
            return new Date(timestamp);
        }
        return null;
    }

    public Date getReadTime() {
        return this.getTime(this.readTime);
    }

    public Date getWriteTime() {
        return this.getTime(this.writeTime);
    }

    public Date getRefreshTime() {
        return this.getTime(this.refreshTime);
    }

    public Date getSaveTime() {
        return this.getTime(this.saveTime);
    }

    public long getReadCount() {
        return this.readCount;
    }

    public long getWriteCount() {
        return this.writeCount;
    }

    public long getRefreshCount() {
        return this.refreshCount;
    }

    public long getSaveCount() {
        return this.saveCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAtNextAccess() {
        this.lock.lock();
        try {
            this.refreshAtNextAccess = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    public <T> Iterator<T> sync(Iterator<T> iterator) {
        return new SynchronizedIterator<T>(iterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T perform(SessionOperation<T> sessionOperation) throws RepositoryException {
        long t0 = this.clock.getTime();
        if (!this.lock.tryLock()) {
            Exception trace;
            if (sessionOperation.isUpdate()) {
                trace = new Exception("Stack trace of concurrent access to " + this.contentSession);
                log.warn("Attempt to perform " + sessionOperation + " while another thread is " + "concurrently writing to " + this.contentSession + ". Blocking until the " + "other thread is finished using this session. Please review your code " + "to avoid concurrent use of a session.", (Throwable)trace);
            } else if (log.isDebugEnabled()) {
                trace = new Exception("Stack trace of concurrent access to " + this.contentSession);
                log.warn("Attempt to perform " + sessionOperation + " while another thread is " + "concurrently reading from " + this.contentSession + ". Blocking until the " + "other thread is finished using this session. Please review your code " + "to avoid concurrent use of a session.", (Throwable)trace);
            }
            this.lock.lock();
        }
        try {
            T t;
            block21: {
                long dt;
                block20: {
                    if (this.sessionOpCount == 0) {
                        if (!(sessionOperation.isRefresh() || sessionOperation.isSave() || sessionOperation.isLogout() || !this.refreshAtNextAccess && this.sessionSaveCount == this.getThreadSaveCount() && !this.refreshStrategy.needsRefresh(TimeUnit.SECONDS.convert(t0 - this.accessTime, TimeUnit.MILLISECONDS)))) {
                            this.refresh(true);
                            this.refreshAtNextAccess = false;
                            this.sessionSaveCount = this.getThreadSaveCount();
                            ++this.updateCount;
                        }
                        sessionOperation.checkPreconditions();
                    }
                    try {
                        ++this.sessionOpCount;
                        T result = sessionOperation.perform();
                        SessionDelegate.logOperationDetails(this.contentSession, sessionOperation);
                        t = result;
                        this.accessTime = t0;
                        dt = TimeUnit.NANOSECONDS.convert(this.clock.getTime() - t0, TimeUnit.MILLISECONDS);
                        --this.sessionOpCount;
                        if (!sessionOperation.isUpdate()) break block20;
                        this.writeTime = t0;
                        ++this.writeCount;
                        this.writeCounter.incrementAndGet();
                    }
                    catch (Throwable throwable) {
                        this.accessTime = t0;
                        long dt2 = TimeUnit.NANOSECONDS.convert(this.clock.getTime() - t0, TimeUnit.MILLISECONDS);
                        --this.sessionOpCount;
                        if (sessionOperation.isUpdate()) {
                            this.writeTime = t0;
                            ++this.writeCount;
                            this.writeCounter.incrementAndGet();
                            this.writeDuration.addAndGet(dt2);
                            ++this.updateCount;
                        } else {
                            this.readTime = t0;
                            ++this.readCount;
                            this.readCounter.incrementAndGet();
                            this.readDuration.addAndGet(dt2);
                        }
                        if (sessionOperation.isSave()) {
                            this.refreshAtNextAccess = false;
                            this.sessionSaveCount = this.getThreadSaveCount() + 1L;
                            this.threadSaveCount.set(this.sessionSaveCount);
                        } else if (sessionOperation.isRefresh()) {
                            this.refreshAtNextAccess = false;
                            this.sessionSaveCount = this.getThreadSaveCount();
                        }
                        throw throwable;
                    }
                    this.writeDuration.addAndGet(dt);
                    ++this.updateCount;
                    break block21;
                }
                this.readTime = t0;
                ++this.readCount;
                this.readCounter.incrementAndGet();
                this.readDuration.addAndGet(dt);
            }
            if (sessionOperation.isSave()) {
                this.refreshAtNextAccess = false;
                this.sessionSaveCount = this.getThreadSaveCount() + 1L;
                this.threadSaveCount.set(this.sessionSaveCount);
            } else if (sessionOperation.isRefresh()) {
                this.refreshAtNextAccess = false;
                this.sessionSaveCount = this.getThreadSaveCount();
            }
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public <T> T safePerform(SessionOperation<T> sessionOperation) {
        try {
            return this.perform(sessionOperation);
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Unexpected exception thrown by operation " + sessionOperation, e);
        }
    }

    @Nonnull
    public ContentSession getContentSession() {
        return this.contentSession;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public void checkAlive() throws RepositoryException {
        if (!this.isAlive()) {
            throw new RepositoryException("This session has been closed.");
        }
    }

    public long getUpdateCount() {
        return this.updateCount;
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }

    private void commit(Root root, String path) throws CommitFailedException {
        ImmutableMap.Builder info = ImmutableMap.builder();
        if (path != null && !PathUtils.denotesRoot((String)path)) {
            info.put((Object)"path", (Object)path);
        }
        if (this.userData != null) {
            info.put((Object)"user-data", (Object)this.userData);
        }
        root.commit((Map)info.build());
        if (this.permissionProvider != null) {
            this.permissionProvider.refresh();
        }
    }

    public void commit() throws CommitFailedException {
        this.commit(this.root, null);
    }

    public void commit(Root root) throws CommitFailedException {
        this.commit(root, null);
    }

    public void checkProtectedNode(String path) throws RepositoryException {
        NodeDelegate node = this.getNode(path);
        if (node == null) {
            throw new PathNotFoundException("Node " + path + " does not exist.");
        }
        if (node.isProtected()) {
            throw new ConstraintViolationException("Node " + path + " is protected.");
        }
    }

    @Nonnull
    public AuthInfo getAuthInfo() {
        return this.contentSession.getAuthInfo();
    }

    public void logout() {
        if (!this.isAlive) {
            return;
        }
        this.isAlive = false;
        try {
            this.contentSession.close();
        }
        catch (IOException e) {
            log.warn("Error while closing connection", (Throwable)e);
        }
    }

    @Nonnull
    public IdentifierManager getIdManager() {
        return this.idManager;
    }

    @CheckForNull
    public NodeDelegate getRootNode() {
        return this.getNode("/");
    }

    @CheckForNull
    public NodeDelegate getNode(String path) {
        Tree tree = this.root.getTree(path);
        return tree.exists() ? new NodeDelegate(this, tree) : null;
    }

    @CheckForNull
    public ItemDelegate getItem(String path) {
        String name = PathUtils.getName((String)path);
        if (name.isEmpty()) {
            return this.getRootNode();
        }
        Tree parent = this.root.getTree(PathUtils.getParentPath((String)path));
        if (parent.hasProperty(name)) {
            return new PropertyDelegate(this, parent, name);
        }
        Tree child = parent.getChild(name);
        if (child.exists()) {
            return new NodeDelegate(this, child);
        }
        return null;
    }

    @CheckForNull
    public NodeDelegate getNodeByIdentifier(String id) {
        Tree tree = this.idManager.getTree(id);
        return tree == null || !tree.exists() ? null : new NodeDelegate(this, tree);
    }

    @CheckForNull
    public PropertyDelegate getProperty(String path) {
        String name;
        Tree parent = this.root.getTree(PathUtils.getParentPath((String)path));
        return parent.hasProperty(name = PathUtils.getName((String)path)) ? new PropertyDelegate(this, parent, name) : null;
    }

    public boolean hasPendingChanges() {
        return this.root.hasPendingChanges();
    }

    public void save(String path) throws RepositoryException {
        this.saveTime = this.clock.getTime();
        ++this.saveCount;
        try {
            this.commit(this.root, path);
        }
        catch (CommitFailedException e) {
            RepositoryException repositoryException = SessionDelegate.newRepositoryException(e);
            this.sessionStats.failedSave(repositoryException);
            throw repositoryException;
        }
    }

    public void refresh(boolean keepChanges) {
        this.refreshTime = this.clock.getTime();
        ++this.refreshCount;
        if (keepChanges && this.hasPendingChanges()) {
            this.root.rebase();
        } else {
            this.root.refresh();
        }
        if (this.permissionProvider != null) {
            this.permissionProvider.refresh();
        }
    }

    @Nonnull
    public String getWorkspaceName() {
        return this.contentSession.getWorkspaceName();
    }

    public void move(String srcPath, String destPath, boolean transientOp) throws RepositoryException {
        Root moveRoot = transientOp ? this.root : this.contentSession.getLatestRoot();
        Tree dest = moveRoot.getTree(destPath);
        if (dest.exists()) {
            throw new ItemExistsException(destPath);
        }
        String destParentPath = PathUtils.getParentPath((String)destPath);
        Tree destParent = moveRoot.getTree(destParentPath);
        if (!destParent.exists()) {
            throw new PathNotFoundException(PathUtils.getParentPath((String)destPath));
        }
        Tree src = moveRoot.getTree(srcPath);
        if (!src.exists()) {
            throw new PathNotFoundException(srcPath);
        }
        try {
            if (!moveRoot.move(srcPath, destPath)) {
                throw new RepositoryException("Cannot move node at " + srcPath + " to " + destPath);
            }
            if (!transientOp) {
                this.saveTime = this.clock.getTime();
                ++this.saveCount;
                this.commit(moveRoot);
                this.refresh(true);
            }
        }
        catch (CommitFailedException e) {
            throw SessionDelegate.newRepositoryException(e);
        }
    }

    @Nonnull
    public QueryEngine getQueryEngine() {
        return this.root.getQueryEngine();
    }

    @Nonnull
    public PermissionProvider getPermissionProvider() {
        if (this.permissionProvider == null) {
            this.permissionProvider = ((AuthorizationConfiguration)((SecurityProvider)Preconditions.checkNotNull((Object)this.securityProvider)).getConfiguration(AuthorizationConfiguration.class)).getPermissionProvider(this.root, this.getWorkspaceName(), this.getAuthInfo().getPrincipals());
        }
        return this.permissionProvider;
    }

    @Nonnull
    public Root getRoot() {
        return this.root;
    }

    public String toString() {
        return this.contentSession.toString();
    }

    private static <T> void logOperationDetails(ContentSession session, SessionOperation<T> ops) {
        if (operationLogger.isDebugEnabled()) {
            Marker sessionMarker = MarkerFactory.getMarker((String)session.toString());
            String sessionId = session.toString();
            operationLogger.debug(sessionMarker, String.format("[%s] %s", sessionId, ops));
        }
    }

    private static RepositoryException newRepositoryException(CommitFailedException exception) {
        return exception.asRepositoryException();
    }

    private final class SynchronizedIterator<T>
    implements Iterator<T> {
        private final Iterator<T> iterator;

        SynchronizedIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            SessionDelegate.this.lock.lock();
            try {
                boolean bl = this.iterator.hasNext();
                return bl;
            }
            finally {
                SessionDelegate.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T next() {
            SessionDelegate.this.lock.lock();
            try {
                T t = this.iterator.next();
                return t;
            }
            finally {
                SessionDelegate.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            SessionDelegate.this.lock.lock();
            try {
                this.iterator.remove();
            }
            finally {
                SessionDelegate.this.lock.unlock();
            }
        }
    }
}

