/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.softwarecatalog.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.softwarecatalog.model.SCProductEntry;
import com.liferay.portlet.softwarecatalog.model.SCProductVersion;
import com.liferay.portlet.softwarecatalog.service.SCProductEntryLocalServiceUtil;
import com.liferay.portlet.softwarecatalog.service.persistence.SCProductEntryActionableDynamicQuery;
import java.util.Locale;
import javax.portlet.PortletURL;

public class SCIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{SCProductEntry.class.getName()};
    public static final String PORTLET_ID = "98";

    public SCIndexer() {
        this.setStagingAware(false);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    protected void doDelete(Object obj) throws Exception {
        SCProductEntry productEntry = (SCProductEntry)obj;
        this.deleteDocument(productEntry.getCompanyId(), productEntry.getProductEntryId());
    }

    protected Document doGetDocument(Object obj) throws Exception {
        SCProductEntry productEntry = (SCProductEntry)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)productEntry);
        StringBundler sb = new StringBundler(15);
        String longDescription = HtmlUtil.extractText((String)productEntry.getLongDescription());
        sb.append(longDescription);
        sb.append(" ");
        sb.append(productEntry.getPageURL());
        sb.append(" ");
        sb.append(productEntry.getRepoArtifactId());
        sb.append(" ");
        sb.append(productEntry.getRepoGroupId());
        sb.append(" ");
        String shortDescription = HtmlUtil.extractText((String)productEntry.getShortDescription());
        sb.append(shortDescription);
        sb.append(" ");
        sb.append(productEntry.getType());
        sb.append(" ");
        sb.append(productEntry.getUserId());
        sb.append(" ");
        String userName = PortalUtil.getUserName((long)productEntry.getUserId(), (String)productEntry.getUserName());
        sb.append(userName);
        document.addText("content", sb.toString());
        document.addText("title", productEntry.getName());
        document.addKeyword("type", productEntry.getType());
        String version = "";
        SCProductVersion latestProductVersion = productEntry.getLatestVersion();
        if (latestProductVersion != null) {
            version = latestProductVersion.getVersion();
        }
        document.addKeyword("version", version);
        document.addText("longDescription", longDescription);
        document.addText("pageURL", productEntry.getPageURL());
        document.addKeyword("repoArtifactId", productEntry.getRepoArtifactId());
        document.addKeyword("repoGroupId", productEntry.getRepoGroupId());
        document.addText("shortDescription", shortDescription);
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        String productEntryId = document.get("entryClassPK");
        portletURL.setParameter("struts_action", "/software_catalog/view_product_entry");
        portletURL.setParameter("productEntryId", productEntryId);
        Summary summary = this.createSummary(document, "title", "content");
        summary.setMaxContentLength(200);
        summary.setPortletURL(portletURL);
        return summary;
    }

    protected void doReindex(Object obj) throws Exception {
        SCProductEntry productEntry = (SCProductEntry)obj;
        Document document = this.getDocument(productEntry);
        SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)productEntry.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        SCProductEntry productEntry = SCProductEntryLocalServiceUtil.getProductEntry((long)classPK);
        this.doReindex(productEntry);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexProductEntries(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void postProcessFullQuery(BooleanQuery fullQuery, SearchContext searchContext) throws Exception {
        String type = (String)((Object)searchContext.getAttribute("type"));
        if (Validator.isNotNull((String)type)) {
            BooleanQuery searchQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            searchQuery.addRequiredTerm("type", type);
            fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
        }
    }

    protected void reindexProductEntries(long companyId) throws PortalException, SystemException {
        SCProductEntryActionableDynamicQuery actionableDynamicQuery = new SCProductEntryActionableDynamicQuery(){

            protected void performAction(Object object) throws PortalException {
                SCProductEntry productEntry = (SCProductEntry)object;
                Document document = SCIndexer.this.getDocument(productEntry);
                this.addDocument(document);
            }
        };
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        actionableDynamicQuery.performActions();
    }
}

