/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.image.ImageToolImpl;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageTool;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.tools.ArgumentsUtil;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Map;
import javax.imageio.ImageIO;

public class ThumbnailBuilder {
    private static ImageTool _imageToolUtil = ImageToolImpl.getInstance();

    public static void main(String[] args) {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        File originalFile = new File(arguments.get("thumbnail.original.file"));
        File thumbnailFile = new File(arguments.get("thumbnail.thumbnail.file"));
        int height = GetterUtil.getInteger((String)arguments.get("thumbnail.height"));
        int width = GetterUtil.getInteger((String)arguments.get("thumbnail.width"));
        boolean overwrite = GetterUtil.getBoolean((String)arguments.get("thumbnail.overwrite"));
        new ThumbnailBuilder(originalFile, thumbnailFile, height, width, overwrite);
    }

    public ThumbnailBuilder(File originalFile, File thumbnailFile, int height, int width, boolean overwrite) {
        try {
            if (!originalFile.exists()) {
                return;
            }
            if (!overwrite && thumbnailFile.lastModified() > originalFile.lastModified()) {
                return;
            }
            ImageBag imageBag = _imageToolUtil.read(originalFile);
            RenderedImage renderedImage = _imageToolUtil.scale(imageBag.getRenderedImage(), height, width);
            ImageIO.write(renderedImage, imageBag.getType(), thumbnailFile);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

