/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntry;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntryThreadLocal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.SystemEvent;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.service.base.SystemEventLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

public class SystemEventLocalServiceImpl
extends SystemEventLocalServiceBaseImpl {
    public SystemEvent addSystemEvent(long userId, long groupId, String className, long classPK, String classUuid, String referrerClassName, int type, String extraData) throws PortalException, SystemException {
        if (userId == 0L) {
            userId = PrincipalThreadLocal.getUserId();
        }
        long companyId = 0L;
        String userName = "";
        if (userId > 0L) {
            User user = this.userPersistence.findByPrimaryKey(userId);
            companyId = user.getCompanyId();
            userName = user.getFullName();
        } else if (groupId > 0L) {
            Group group = this.groupPersistence.findByPrimaryKey(groupId);
            companyId = group.getCompanyId();
        }
        return this.addSystemEvent(userId, companyId, groupId, className, classPK, classUuid, referrerClassName, type, extraData, userName);
    }

    public SystemEvent addSystemEvent(long companyId, String className, long classPK, String classUuid, String referrerClassName, int type, String extraData) throws PortalException, SystemException {
        return this.addSystemEvent(0L, companyId, 0L, className, classPK, classUuid, referrerClassName, type, extraData, "");
    }

    public void deleteSystemEvents(long groupId) throws SystemException {
        this.systemEventPersistence.removeByGroupId(groupId);
    }

    public void deleteSystemEvents(long groupId, long systemEventSetKey) throws SystemException {
        this.systemEventPersistence.removeByG_S(groupId, systemEventSetKey);
    }

    public SystemEvent fetchSystemEvent(long groupId, long classNameId, long classPK, int type) throws SystemException {
        return this.systemEventPersistence.fetchByG_C_C_T_First(groupId, classNameId, classPK, type, null);
    }

    public List<SystemEvent> getSystemEvents(long groupId, long classNameId, long classPK) throws SystemException {
        return this.systemEventPersistence.findByG_C_C(groupId, classNameId, classPK);
    }

    public List<SystemEvent> getSystemEvents(long groupId, long classNameId, long classPK, int type) throws SystemException {
        return this.systemEventPersistence.findByG_C_C_T(groupId, classNameId, classPK, type);
    }

    protected SystemEvent addSystemEvent(long userId, long companyId, long groupId, String className, long classPK, String classUuid, String referrerClassName, int type, String extraData, String userName) throws PortalException, SystemException {
        Company company;
        Group companyGroup;
        SystemEventHierarchyEntry systemEventHierarchyEntry = SystemEventHierarchyEntryThreadLocal.peek();
        int action = 0;
        if (systemEventHierarchyEntry != null && (action = systemEventHierarchyEntry.getAction()) == 1 && !systemEventHierarchyEntry.hasTypedModel(className, classPK)) {
            return null;
        }
        if (!CompanyThreadLocal.isDeleteInProcess() && (companyGroup = (company = this.companyPersistence.findByPrimaryKey(companyId)).getGroup()).getGroupId() == groupId) {
            groupId = 0L;
        }
        if (Validator.isNotNull((String)referrerClassName) && referrerClassName.equals(className)) {
            referrerClassName = null;
        }
        long systemEventId = 0L;
        systemEventId = systemEventHierarchyEntry != null && systemEventHierarchyEntry.hasTypedModel(className, classPK) ? systemEventHierarchyEntry.getSystemEventId() : this.counterLocalService.increment();
        SystemEvent systemEvent = this.systemEventPersistence.create(systemEventId);
        systemEvent.setGroupId(groupId);
        systemEvent.setCompanyId(companyId);
        systemEvent.setUserId(userId);
        systemEvent.setUserName(userName);
        systemEvent.setCreateDate(new Date());
        systemEvent.setClassName(className);
        systemEvent.setClassPK(classPK);
        systemEvent.setClassUuid(classUuid);
        systemEvent.setReferrerClassName(referrerClassName);
        long parentSystemEventId = 0L;
        if (action == 3) {
            parentSystemEventId = systemEventHierarchyEntry.hasTypedModel(className, classPK) ? systemEventHierarchyEntry.getParentSystemEventId() : systemEventHierarchyEntry.getSystemEventId();
        }
        systemEvent.setParentSystemEventId(parentSystemEventId);
        long systemEventSetKey = 0L;
        systemEventSetKey = action == 2 || action == 3 ? systemEventHierarchyEntry.getSystemEventSetKey() : this.counterLocalService.increment();
        systemEvent.setSystemEventSetKey(systemEventSetKey);
        systemEvent.setType(type);
        systemEvent.setExtraData(extraData);
        return (SystemEvent)this.systemEventPersistence.update((BaseModel)systemEvent);
    }
}

