/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;

public class PortletClassLoaderUtil {
    private static Map<Long, ClassLoader> _classLoaders = new HashMap<Long, ClassLoader>();
    private static String _servletContextName;

    public static ClassLoader getClassLoader() {
        Thread currentThread = Thread.currentThread();
        return _classLoaders.get(currentThread.getId());
    }

    public static ClassLoader getClassLoader(String portletId) {
        PortalRuntimePermission.checkGetClassLoader(portletId);
        PortletBag portletBag = PortletBagPool.get(portletId);
        if (portletBag == null) {
            return null;
        }
        ServletContext servletContext = portletBag.getServletContext();
        return (ClassLoader)servletContext.getAttribute("PLUGIN_CLASS_LOADER");
    }

    public static String getServletContextName() {
        return _servletContextName;
    }

    public static void setClassLoader(ClassLoader classLoader) {
        PortalRuntimePermission.checkSetBeanProperty(PortletClassLoaderUtil.class);
        Thread currentThread = Thread.currentThread();
        _classLoaders.put(currentThread.getId(), classLoader);
    }

    public static void setServletContextName(String servletContextName) {
        PortalRuntimePermission.checkSetBeanProperty(PortletClassLoaderUtil.class);
        _servletContextName = servletContextName;
    }
}

