/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool.impl;

import com.netflix.astyanax.connectionpool.ConnectionFactory;
import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import com.netflix.astyanax.connectionpool.ConnectionPoolMonitor;
import com.netflix.astyanax.connectionpool.ExecuteWithFailover;
import com.netflix.astyanax.connectionpool.HostConnectionPool;
import com.netflix.astyanax.connectionpool.Operation;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.NoAvailableHostsException;
import com.netflix.astyanax.connectionpool.impl.AbstractHostPartitionConnectionPool;
import com.netflix.astyanax.connectionpool.impl.RoundRobinExecuteWithFailover;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class RoundRobinConnectionPoolImpl<CL>
extends AbstractHostPartitionConnectionPool<CL> {
    private final AtomicInteger roundRobinCounter = new AtomicInteger(new Random().nextInt(997));
    private static final int MAX_RR_COUNTER = 0x3FFFFFFF;

    public RoundRobinConnectionPoolImpl(ConnectionPoolConfiguration config, ConnectionFactory<CL> factory, ConnectionPoolMonitor monitor) {
        super(config, factory, monitor);
    }

    @Override
    public <R> ExecuteWithFailover<CL, R> newExecuteWithFailover(Operation<CL, R> operation) throws ConnectionException {
        try {
            if (operation.getPinnedHost() != null) {
                HostConnectionPool pool = (HostConnectionPool)this.hosts.get((Object)operation.getPinnedHost());
                if (pool == null) {
                    throw new NoAvailableHostsException("Host " + operation.getPinnedHost() + " not active");
                }
                return new RoundRobinExecuteWithFailover(this.config, this.monitor, Arrays.asList(pool), 0);
            }
            int index = this.roundRobinCounter.incrementAndGet();
            if (index > 0x3FFFFFFF) {
                this.roundRobinCounter.set(0);
            }
            return new RoundRobinExecuteWithFailover(this.config, this.monitor, this.topology.getAllPools().getPools(), index);
        }
        catch (ConnectionException e) {
            this.monitor.incOperationFailure(e.getHost(), e);
            throw e;
        }
    }
}

