/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.compat.portal.kernel.notifications;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.notifications.UserNotificationFeedEntry;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.UserNotificationEvent;
import com.liferay.portal.service.ServiceContext;

public abstract class BaseUserNotificationHandler
extends com.liferay.portal.kernel.notifications.BaseUserNotificationHandler {
    private static Log _log = LogFactoryUtil.getLog(BaseUserNotificationHandler.class);
    private boolean _actionable;

    public UserNotificationFeedEntry interpret(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws PortalException {
        try {
            UserNotificationFeedEntry userNotificationFeedEntry = this.doInterpret(userNotificationEvent, serviceContext);
            if (userNotificationFeedEntry != null) {
                userNotificationFeedEntry.setPortletId(this.getPortletId());
            }
            return userNotificationFeedEntry;
        }
        catch (Exception e) {
            _log.error((Object)"Unable to interpret notification", (Throwable)e);
            return null;
        }
    }

    protected String getBodyTemplate() throws Exception {
        if (this.isActionable()) {
            StringBundler sb = new StringBundler(5);
            sb.append("<div class=\"title\">[$TITLE$]</div><div ");
            sb.append("class=\"body\"><a class=\"btn btn-action ");
            sb.append("btn-success\" href=\"[$CONFIRM_URL$]\">[$CONFIRM$]</a>");
            sb.append("<a class=\"btn btn-action btn-warning\" href=\"");
            sb.append("[$IGNORE_URL$]\">[$IGNORE$]</a></div>");
            return sb.toString();
        }
        return "<div class=\"title\">[$TITLE$]</div><div class=\"body\">[$BODY$]</div>";
    }

    protected boolean isActionable() {
        return this._actionable;
    }

    protected void setActionable(boolean actionable) {
        this._actionable = actionable;
    }
}

