/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.support;

import java.util.ArrayList;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.support.AbstractControllerUrlHandlerMapping;

public class ControllerBeanNameHandlerMapping
extends AbstractControllerUrlHandlerMapping {
    private String urlPrefix = "";
    private String urlSuffix = "";

    public void setUrlPrefix(String urlPrefix) {
        this.urlPrefix = urlPrefix != null ? urlPrefix : "";
    }

    public void setUrlSuffix(String urlSuffix) {
        this.urlSuffix = urlSuffix != null ? urlSuffix : "";
    }

    protected String[] buildUrlsForHandler(String beanName, Class beanClass) {
        String[] aliases;
        ArrayList<String> urls = new ArrayList<String>();
        urls.add(this.generatePathMapping(beanName));
        String[] stringArray = aliases = this.getApplicationContext().getAliases(beanName);
        int n = aliases.length;
        int n2 = 0;
        while (n2 < n) {
            String alias = stringArray[n2];
            urls.add(this.generatePathMapping(alias));
            ++n2;
        }
        return StringUtils.toStringArray(urls);
    }

    protected String generatePathMapping(String beanName) {
        String name = beanName.startsWith("/") ? beanName : "/" + beanName;
        StringBuilder path = new StringBuilder();
        if (!name.startsWith(this.urlPrefix)) {
            path.append(this.urlPrefix);
        }
        path.append(name);
        if (!name.endsWith(this.urlSuffix)) {
            path.append(this.urlSuffix);
        }
        return path.toString();
    }
}

