/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation.filter;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.observation.filter.EventFilter;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class VisibleFilter
implements EventFilter {
    private static boolean isVisible(String name) {
        return !name.startsWith(":");
    }

    @Override
    public boolean includeAdd(PropertyState after) {
        return VisibleFilter.isVisible(after.getName());
    }

    @Override
    public boolean includeChange(PropertyState before, PropertyState after) {
        return VisibleFilter.isVisible(after.getName());
    }

    @Override
    public boolean includeDelete(PropertyState before) {
        return VisibleFilter.isVisible(before.getName());
    }

    @Override
    public boolean includeAdd(String name, NodeState after) {
        return VisibleFilter.isVisible(name);
    }

    @Override
    public boolean includeDelete(String name, NodeState before) {
        return VisibleFilter.isVisible(name);
    }

    @Override
    public boolean includeMove(String sourcePath, String name, NodeState moved) {
        for (String element : PathUtils.elements((String)sourcePath)) {
            if (VisibleFilter.isVisible(element)) continue;
            return false;
        }
        return VisibleFilter.isVisible(name);
    }

    @Override
    public boolean includeReorder(String destName, String name, NodeState reordered) {
        return VisibleFilter.isVisible(destName) && VisibleFilter.isVisible(name);
    }

    @Override
    public EventFilter create(String name, NodeState before, NodeState after) {
        if (VisibleFilter.isVisible(name)) {
            return this;
        }
        return null;
    }
}

