/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;

public class BlobStoreBlob
implements Blob {
    private final BlobStore blobStore;
    private final String blobId;

    public BlobStoreBlob(BlobStore blobStore, String blobId) {
        this.blobStore = blobStore;
        this.blobId = blobId;
    }

    @Override
    @Nonnull
    public InputStream getNewStream() {
        try {
            return this.blobStore.getInputStream(this.blobId);
        }
        catch (IOException e) {
            throw new RuntimeException("Error occurred while obtaining InputStream for blobId [" + this.blobId + "]", e);
        }
    }

    @Override
    public long length() {
        try {
            return this.blobStore.getBlobLength(this.blobId);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid blob id: " + this.blobId, e);
        }
    }

    @Override
    @CheckForNull
    public String getReference() {
        return this.blobStore.getReference(this.blobId);
    }

    @Override
    public String getContentIdentity() {
        return this.blobId;
    }

    public String getBlobId() {
        return this.blobId;
    }

    public String toString() {
        return this.blobId;
    }

    public int hashCode() {
        return this.blobId.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof BlobStoreBlob) {
            BlobStoreBlob b = (BlobStoreBlob)other;
            return b.blobId.equals(this.blobId);
        }
        return false;
    }
}

