/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.trash;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.trash.BaseTrashRenderer;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import java.util.Locale;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class DLFileShortcutTrashRenderer
extends BaseTrashRenderer {
    public static final String TYPE = "shortcut";
    private FileEntry _fileEntry;
    private DLFileShortcut _fileShortcut;

    public DLFileShortcutTrashRenderer(DLFileShortcut fileShortcut) throws PortalException, SystemException {
        this._fileShortcut = fileShortcut;
        this._fileEntry = DLAppLocalServiceUtil.getFileEntry((long)fileShortcut.getToFileEntryId());
    }

    public String getClassName() {
        return DLFileShortcut.class.getName();
    }

    public long getClassPK() {
        return this._fileShortcut.getPrimaryKey();
    }

    public String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/file_system/small/" + this._fileEntry.getIcon() + ".png";
    }

    public String getPortletId() {
        return "20";
    }

    public String getSummary(Locale locale) {
        return HtmlUtil.stripHtml((String)this._fileEntry.getDescription());
    }

    public String getTitle(Locale locale) {
        return LanguageUtil.format((Locale)locale, (String)"shortcut-to-x", (Object)this._fileShortcut.getToTitle());
    }

    public String getType() {
        return TYPE;
    }

    public String render(RenderRequest renderRequest, RenderResponse renderResponse, String template) throws Exception {
        if (template.equals("abstract") || template.equals("full_content")) {
            renderRequest.setAttribute("DOCUMENT_LIBRARY_FILE_ENTRY", (Object)this._fileEntry);
            return "/html/portlet/document_library/asset/" + template + ".jsp";
        }
        return null;
    }
}

