/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.management;

import java.lang.management.ManagementFactory;
import java.security.AccessControlException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.jruby.Ruby;
import org.jruby.compiler.JITCompilerMBean;
import org.jruby.management.BeanManager;
import org.jruby.management.ClassCacheMBean;
import org.jruby.management.ConfigMBean;
import org.jruby.management.MethodCacheMBean;
import org.jruby.management.ParserStatsMBean;
import org.jruby.management.Runtime;

public class BeanManagerImpl
implements BeanManager {
    public final String base;
    private final boolean managementEnabled;

    public BeanManagerImpl(Ruby ruby2, boolean managementEnabled) {
        this.managementEnabled = managementEnabled;
        this.base = "org.jruby:type=Runtime,name=" + ruby2.hashCode() + ",";
    }

    public void register(JITCompilerMBean jitCompiler) {
        if (this.managementEnabled) {
            this.register(this.base + "service=JITCompiler", jitCompiler);
        }
    }

    public void register(ConfigMBean config) {
        if (this.managementEnabled) {
            this.register(this.base + "service=Config", config);
        }
    }

    public void register(ParserStatsMBean parserStats) {
        if (this.managementEnabled) {
            this.register(this.base + "service=ParserStats", parserStats);
        }
    }

    public void register(MethodCacheMBean methodCache) {
        if (this.managementEnabled) {
            this.register(this.base + "service=MethodCache", methodCache);
        }
    }

    public void register(ClassCacheMBean classCache) {
        if (this.managementEnabled) {
            this.register(this.base + "service=ClassCache", classCache);
        }
    }

    public void register(Runtime runtime2) {
        if (this.managementEnabled) {
            this.register(this.base + "service=Runtime", runtime2);
        }
    }

    public void unregisterCompiler() {
        if (this.managementEnabled) {
            this.unregister(this.base + "service=JITCompiler");
        }
    }

    public void unregisterConfig() {
        if (this.managementEnabled) {
            this.unregister(this.base + "service=Config");
        }
    }

    public void unregisterParserStats() {
        if (this.managementEnabled) {
            this.unregister(this.base + "service=ParserStats");
        }
    }

    public void unregisterClassCache() {
        if (this.managementEnabled) {
            this.unregister(this.base + "service=ClassCache");
        }
    }

    public void unregisterMethodCache() {
        if (this.managementEnabled) {
            this.unregister(this.base + "service=MethodCache");
        }
    }

    public void unregisterRuntime() {
        if (this.managementEnabled) {
            this.unregister(this.base + "service=Runtime");
        }
    }

    private void register(String name2, Object bean) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName beanName = new ObjectName(name2);
            mbs.registerMBean(bean, beanName);
        }
        catch (InstanceAlreadyExistsException ex) {
            Logger.getLogger(BeanManagerImpl.class.getName()).log(Level.WARNING, "mbean already registered: " + name2);
        }
        catch (MBeanRegistrationException ex) {
            Logger.getLogger(BeanManagerImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NotCompliantMBeanException ex) {
            Logger.getLogger(BeanManagerImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (MalformedObjectNameException ex) {
            Logger.getLogger(BeanManagerImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NullPointerException ex) {
            Logger.getLogger(BeanManagerImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (AccessControlException ex) {
        }
        catch (SecurityException ex) {
        }
        catch (Error e) {
            Logger.getLogger(BeanManagerImpl.class.getName()).log(Level.FINE, null, e);
        }
    }

    private void unregister(String name2) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName beanName = new ObjectName(name2);
            mbs.unregisterMBean(beanName);
        }
        catch (InstanceNotFoundException ex) {
        }
        catch (MBeanRegistrationException ex) {
            Logger.getLogger(BeanManagerImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (MalformedObjectNameException ex) {
            Logger.getLogger(BeanManagerImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NullPointerException ex) {
            Logger.getLogger(BeanManagerImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (AccessControlException ex) {
        }
        catch (SecurityException ex) {
        }
        catch (Error e) {
            Logger.getLogger(BeanManagerImpl.class.getName()).log(Level.FINE, null, e);
        }
    }
}

