/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.security.pacl.checker.AuthorizationProperty;
import com.liferay.portal.security.pacl.checker.BaseChecker;
import java.security.Permission;
import java.security.Permissions;
import java.util.PropertyPermission;
import java.util.Set;

public class PropertyChecker
extends BaseChecker {
    private static Log _log = LogFactoryUtil.getLog(PropertyChecker.class);
    private Permissions _permissions = new Permissions();

    @Override
    public void afterPropertiesSet() {
        this.initProperties();
    }

    @Override
    public AuthorizationProperty generateAuthorizationProperty(Object ... arguments) {
        if (arguments != null && arguments.length == 1 && !(arguments[0] instanceof Permission)) {
            return null;
        }
        Permission permission = (Permission)arguments[0];
        String actions = permission.getActions();
        AuthorizationProperty authorizationProperty = new AuthorizationProperty();
        if (actions.equals("write")) {
            authorizationProperty.setKey("security-manager-properties-write");
        } else {
            authorizationProperty.setKey("security-manager-properties-read");
        }
        authorizationProperty.setValue(permission.getName());
        return authorizationProperty;
    }

    @Override
    public boolean implies(Permission permission) {
        if (this._permissions.implies(permission)) {
            return true;
        }
        String name = permission.getName();
        String action = permission.getActions();
        this.logSecurityException(_log, "Attempted to " + action + " system property " + name);
        return false;
    }

    protected void initProperties() {
        PropertyPermission permission;
        Set<String> names = this.getPropertySet("security-manager-properties-read");
        for (String name : names) {
            permission = new PropertyPermission(name, "read");
            this._permissions.add(permission);
        }
        names = this.getPropertySet("security-manager-properties-write");
        for (String name : names) {
            permission = new PropertyPermission(name, "write");
            this._permissions.add(permission);
        }
    }
}

