/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import com.google.common.base.Preconditions;
import com.mongodb.BasicDBObject;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Hex;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    private static final int REVISION_LENGTH = new Revision(System.currentTimeMillis(), 0, 0).toString().length();
    private static final int PATH_SHORT = Integer.getInteger("oak.pathShort", 165);
    private static final int PATH_LONG = Integer.getInteger("oak.pathLong", 350);
    private static final int NODE_NAME_LIMIT = Integer.getInteger("oak.nodeNameLimit", 150);
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public static String unshareString(String x) {
        return new String(x);
    }

    public static int pathDepth(String path) {
        if (path.equals("/")) {
            return 0;
        }
        int depth = 0;
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) != '/') continue;
            ++depth;
        }
        return depth;
    }

    public static int estimateMemoryUsage(Map<?, Object> map) {
        if (map == null) {
            return 0;
        }
        int size = 0;
        for (Map.Entry<?, Object> e : map.entrySet()) {
            size = e.getKey() instanceof Revision ? (size += 32) : (size += 48 + e.getKey().toString().length() * 2);
            Object o = e.getValue();
            if (o instanceof String) {
                size += 48 + ((String)o).length() * 2;
                continue;
            }
            if (o instanceof Long) {
                size += 16;
                continue;
            }
            if (o instanceof Boolean) {
                size += 8;
                continue;
            }
            if (o instanceof Integer) {
                size += 8;
                continue;
            }
            if (o instanceof Map) {
                size += 8 + Utils.estimateMemoryUsage((Map)o);
                continue;
            }
            if (o == null) continue;
            throw new IllegalArgumentException("Can't estimate memory usage of " + o);
        }
        if (map instanceof BasicDBObject) {
            size += 176;
            size += map.size() * 136;
        } else {
            size += 112;
            size += map.size() * 64;
        }
        return size;
    }

    public static int getUniqueClusterId() {
        ObjectId objId = new ObjectId();
        return objId._machine();
    }

    public static String escapePropertyName(String propertyName) {
        int len = propertyName.length();
        if (len == 0) {
            return "_";
        }
        StringBuilder buff = null;
        char c = propertyName.charAt(0);
        int i = 0;
        if (c == '_' || c == '$') {
            buff = new StringBuilder(len + 1);
            buff.append('_').append(c);
            ++i;
        }
        while (i < len) {
            char rep;
            c = propertyName.charAt(i);
            switch (c) {
                case '.': {
                    rep = 'd';
                    break;
                }
                case '\\': {
                    rep = '\\';
                    break;
                }
                default: {
                    rep = '\u0000';
                }
            }
            if (rep != '\u0000') {
                if (buff == null) {
                    buff = new StringBuilder(propertyName.substring(0, i));
                }
                buff.append('\\').append(rep);
            } else if (buff != null) {
                buff.append(c);
            }
            ++i;
        }
        return buff == null ? propertyName : buff.toString();
    }

    public static String unescapePropertyName(String key) {
        int len = key.length();
        if (key.startsWith("_") && (key.startsWith("__") || key.startsWith("_$") || len == 1)) {
            key = key.substring(1);
            --len;
        }
        StringBuilder buff = null;
        for (int i = 0; i < len; ++i) {
            int c = key.charAt(i);
            if (c == 92) {
                if (buff == null) {
                    buff = new StringBuilder(key.substring(0, i));
                }
                if ((c = key.charAt(++i)) != 92 && c == 100) {
                    c = 46;
                }
                buff.append((char)c);
                continue;
            }
            if (buff == null) continue;
            buff.append((char)c);
        }
        return buff == null ? key : buff.toString();
    }

    public static boolean isPropertyName(String key) {
        return !key.startsWith("_") || key.startsWith("__") || key.startsWith("_$");
    }

    public static String getIdFromPath(String path) {
        if (Utils.isLongPath(path)) {
            MessageDigest digest;
            try {
                digest = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            int depth = Utils.pathDepth(path);
            String parent = PathUtils.getParentPath((String)path);
            byte[] hash = digest.digest(parent.getBytes(UTF_8));
            String name = PathUtils.getName((String)path);
            return depth + ":h" + Hex.encodeHexString((byte[])hash) + "/" + name;
        }
        int depth = Utils.pathDepth(path);
        return depth + ":" + path;
    }

    public static boolean isLongPath(String path) {
        if (path.length() < PATH_SHORT) {
            return false;
        }
        byte[] parent = PathUtils.getParentPath((String)path).getBytes(UTF_8);
        if (parent.length < PATH_LONG) {
            return false;
        }
        String name = PathUtils.getName((String)path);
        if (name.getBytes(UTF_8).length > NODE_NAME_LIMIT) {
            throw new IllegalArgumentException("Node name is too long: " + path);
        }
        return true;
    }

    public static boolean isIdFromLongPath(String id) {
        int index = id.indexOf(58);
        return id.charAt(index + 1) == 'h';
    }

    public static String getPathFromId(String id) {
        if (Utils.isIdFromLongPath(id)) {
            throw new IllegalArgumentException("Id is hashed: " + id);
        }
        int index = id.indexOf(58);
        return id.substring(index + 1);
    }

    public static String getPreviousPathFor(String path, Revision r, int height) {
        if (!PathUtils.isAbsolute((String)path)) {
            throw new IllegalArgumentException("path must be absolute: " + path);
        }
        StringBuilder sb = new StringBuilder(path.length() + REVISION_LENGTH + 3);
        sb.append("p").append(path);
        if (sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        r.toStringBuilder(sb).append("/").append(height);
        return sb.toString();
    }

    public static String getPreviousIdFor(String path, Revision r, int height) {
        return Utils.getIdFromPath(Utils.getPreviousPathFor(path, r, height));
    }

    public static <K> void deepCopyMap(Map<K, Object> source, Map<K, Object> target) {
        for (Map.Entry<K, Object> e : source.entrySet()) {
            TreeMap value = e.getValue();
            Comparator comparator = null;
            if (value instanceof SortedMap) {
                SortedMap map = value;
                comparator = map.comparator();
            }
            if (value instanceof Map) {
                Map old = value;
                TreeMap c = new TreeMap(comparator);
                Utils.deepCopyMap(old, c);
                value = c;
            }
            target.put(e.getKey(), value);
        }
    }

    public static String getKeyLowerLimit(String path) {
        String from = PathUtils.concat((String)path, (String)"a");
        from = Utils.getIdFromPath(from);
        from = from.substring(0, from.length() - 1);
        return from;
    }

    public static String getKeyUpperLimit(String path) {
        String to = PathUtils.concat((String)path, (String)"z");
        to = Utils.getIdFromPath(to);
        to = to.substring(0, to.length() - 2) + "0";
        return to;
    }

    public static boolean isCommitted(@Nullable String tag) {
        return tag != null && (tag.equals("c") || tag.startsWith("c-"));
    }

    @Nonnull
    public static Revision resolveCommitRevision(@Nonnull Revision rev, @Nonnull String tag) {
        return ((String)Preconditions.checkNotNull((Object)tag)).startsWith("c-") ? Revision.fromString(tag.substring(2)) : rev;
    }

    public static void closeIfCloseable(Object obj) {
        if (obj instanceof Closeable) {
            try {
                ((Closeable)obj).close();
            }
            catch (IOException e) {
                LOG.warn("Error occurred while closing {}", obj, (Object)e);
            }
        }
    }

    public static String timestampToString(long timestamp) {
        return (new Timestamp(timestamp) + "00").substring(0, 23);
    }
}

