/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyInstanceConfig;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.callsite.BitAndCallSite;
import org.jruby.runtime.callsite.BitOrCallSite;
import org.jruby.runtime.callsite.CmpCallSite;
import org.jruby.runtime.callsite.EqCallSite;
import org.jruby.runtime.callsite.FunctionalCachingCallSite;
import org.jruby.runtime.callsite.GeCallSite;
import org.jruby.runtime.callsite.GtCallSite;
import org.jruby.runtime.callsite.LeCallSite;
import org.jruby.runtime.callsite.LtCallSite;
import org.jruby.runtime.callsite.MinusCallSite;
import org.jruby.runtime.callsite.MulCallSite;
import org.jruby.runtime.callsite.NormalCachingCallSite;
import org.jruby.runtime.callsite.PlusCallSite;
import org.jruby.runtime.callsite.RespondToCallSite;
import org.jruby.runtime.callsite.ShiftLeftCallSite;
import org.jruby.runtime.callsite.ShiftRightCallSite;
import org.jruby.runtime.callsite.SuperCallSite;
import org.jruby.runtime.callsite.VariableCachingCallSite;
import org.jruby.runtime.callsite.XorCallSite;

public class MethodIndex {
    public static final int NO_METHOD = 0;
    public static final int OP_EQUAL = 1;
    public static final int EQL = 2;
    public static final int HASH = 3;
    public static final int OP_CMP = 4;
    public static final int MAX_METHODS = 5;
    public static final String[] METHOD_NAMES = new String[]{"", "==", "eql?", "hash", "<=>"};

    public static CallSite getCallSite(String name2) {
        if (name2.equals("respond_to?")) {
            return new RespondToCallSite();
        }
        if (RubyInstanceConfig.FASTOPS_COMPILE_ENABLED && !RubyInstanceConfig.FULL_TRACE_ENABLED) {
            return MethodIndex.getFastOpsCallSite(name2);
        }
        return new NormalCachingCallSite(name2);
    }

    public static boolean hasFastOps(String name2) {
        return name2.equals("+") || name2.equals("-") || name2.equals("*") || name2.equals("<") || name2.equals("<=") || name2.equals(">") || name2.equals(">=") || name2.equals("==") || name2.equals("<=>") || name2.equals("&") || name2.equals("|") || name2.equals("^") || name2.equals(">>") || name2.equals("<<");
    }

    public static CallSite getFastOpsCallSite(String name2) {
        if (name2.equals("+")) {
            return new PlusCallSite();
        }
        if (name2.equals("-")) {
            return new MinusCallSite();
        }
        if (name2.equals("*")) {
            return new MulCallSite();
        }
        if (name2.equals("<")) {
            return new LtCallSite();
        }
        if (name2.equals("<=")) {
            return new LeCallSite();
        }
        if (name2.equals(">")) {
            return new GtCallSite();
        }
        if (name2.equals(">=")) {
            return new GeCallSite();
        }
        if (name2.equals("==")) {
            return new EqCallSite();
        }
        if (name2.equals("<=>")) {
            return new CmpCallSite();
        }
        if (name2.equals("&")) {
            return new BitAndCallSite();
        }
        if (name2.equals("|")) {
            return new BitOrCallSite();
        }
        if (name2.equals("^")) {
            return new XorCallSite();
        }
        if (name2.equals(">>")) {
            return new ShiftRightCallSite();
        }
        if (name2.equals("<<")) {
            return new ShiftLeftCallSite();
        }
        return new NormalCachingCallSite(name2);
    }

    public static CallSite getFunctionalCallSite(String name2) {
        return new FunctionalCachingCallSite(name2);
    }

    public static CallSite getVariableCallSite(String name2) {
        return new VariableCachingCallSite(name2);
    }

    public static CallSite getSuperCallSite() {
        return new SuperCallSite();
    }
}

