/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.BrowseFacet;
import com.browseengine.bobo.api.FacetIterator;
import java.util.List;
import java.util.NoSuchElementException;

public class PathFacetIterator
extends FacetIterator {
    private BrowseFacet[] _facets;
    private int _index;

    public PathFacetIterator(List<BrowseFacet> facets) {
        this._facets = facets.toArray(new BrowseFacet[facets.size()]);
        this._index = -1;
        this.facet = null;
        this.count = 0;
    }

    @Override
    public Comparable next() {
        if (this._index >= 0 && !this.hasNext()) {
            throw new NoSuchElementException("No more facets in this iteration");
        }
        ++this._index;
        this.facet = this._facets[this._index].getValue();
        this.count = this._facets[this._index].getFacetValueHitCount();
        return this.facet;
    }

    @Override
    public boolean hasNext() {
        return this._index >= 0 && this._index < this._facets.length - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() method not supported for Facet Iterators");
    }

    @Override
    public Comparable next(int minHits) {
        while (++this._index < this._facets.length) {
            if (this._facets[this._index].getFacetValueHitCount() < minHits) continue;
            this.facet = this._facets[this._index].getValue();
            this.count = this._facets[this._index].getFacetValueHitCount();
            return this.facet;
        }
        this.facet = null;
        this.count = 0;
        return this.facet;
    }

    @Override
    public String format(Object val) {
        return (String)val;
    }
}

