/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.util.LogFileHandler;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class AlternatingLogFileHandler
extends LogFileHandler {
    public static String DEFAULT_FILE_NAME_ROOT = "jena";
    public static String DEFAULT_FILE_NAME_EXT = ".log";
    public static int DEFAULT_NUM_FILES = 3;
    public static int DEFAULT_ENTRIES_PER_FILE = 5000;
    protected int numFiles;
    protected int fileCount = 1;
    protected int entriesPerFile;
    protected int entryCount = 0;
    protected String fileNameRoot;
    protected String fileNameExt;

    public AlternatingLogFileHandler() throws IOException {
        this(DEFAULT_FILE_NAME_ROOT, DEFAULT_FILE_NAME_EXT);
    }

    public AlternatingLogFileHandler(String string, String string2) throws IOException {
        this(string, string2, DEFAULT_NUM_FILES, DEFAULT_ENTRIES_PER_FILE);
    }

    public AlternatingLogFileHandler(String string, String string2, int n, int n2) throws IOException {
        super(string + "1" + string2);
        this.fileNameRoot = string;
        this.fileNameExt = string2;
        this.numFiles = n;
        this.entriesPerFile = n2;
    }

    public void publish(int n, String string, String string2, String string3, Throwable throwable) {
        super.publish(n, string, string2, string3, throwable);
        if (++this.entryCount > this.entriesPerFile) {
            this.nextFile();
        }
    }

    protected void nextFile() {
        this.close();
        if (++this.fileCount > this.numFiles) {
            this.fileCount = 1;
        }
        try {
            this.m_file = new FileWriter(this.fileNameRoot + this.fileCount + this.fileNameExt);
            this.m_print = new PrintWriter(this.m_file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.entryCount = 0;
    }
}

