/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImageJ;
import ij.io.OpenDialog;
import ij.io.Opener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class SocketListener
implements Runnable {
    public SocketListener() {
        Thread thread = new Thread((Runnable)this, "SocketListener");
        thread.start();
    }

    public void run() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(ImageJ.getPort());
            if (IJ.debugMode) {
                IJ.log("SocketListener: new ServerSocket(" + ImageJ.getPort() + ")");
            }
            while (true) {
                Socket clientSocket;
                InetAddress address;
                boolean isLocal;
                boolean bl = isLocal = (address = (clientSocket = serverSocket.accept()).getInetAddress()) != null && address.isLoopbackAddress();
                if (IJ.debugMode) {
                    IJ.log("SocketListener: client=" + address + "  " + isLocal);
                }
                try {
                    BufferedReader is = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                    String cmd = is.readLine();
                    if (IJ.debugMode) {
                        IJ.log("SocketListener: command=\"" + cmd + "\"");
                    }
                    if (cmd.startsWith("open ")) {
                        new Opener().openAndAddToRecent(cmd.substring(5));
                    } else if (isLocal && cmd.startsWith("macro ")) {
                        int index;
                        String name;
                        String name2 = name = cmd.substring(6);
                        String arg = null;
                        if (name2.endsWith(")") && (index = name2.lastIndexOf("(")) > 0) {
                            name = name2.substring(0, index);
                            arg = name2.substring(index + 1, name2.length() - 1);
                        }
                        IJ.runMacroFile(name, arg);
                    } else if (isLocal && cmd.startsWith("run ")) {
                        IJ.run(cmd.substring(4));
                    } else if (isLocal && cmd.startsWith("eval ")) {
                        String rtn = IJ.runMacro(cmd.substring(5));
                        if (rtn != null) {
                            System.out.print(rtn);
                        }
                    } else if (cmd.startsWith("user.dir ")) {
                        OpenDialog.setDefaultDirectory(cmd.substring(9));
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
                clientSocket.close();
            }
        }
        catch (IOException e) {
            return;
        }
    }
}

