/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.metadata;

import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.mappings.transformers.AttributeTransformer;
import org.eclipse.persistence.mappings.transformers.FieldTransformer;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;

public class QNameTransformer
implements AttributeTransformer,
FieldTransformer {
    private static final char COLON = ':';
    private static final char HASH = '#';
    public static final String QNAME_NAMESPACE_PREFIX = "qns";
    private static final String DEFAULT_NAMESPACE_PREFIX = "";
    AbstractTransformationMapping transformationMapping;
    private NamespaceResolver namespaceResolver;
    private String xPath;

    public QNameTransformer(String xPath) {
        this.xPath = xPath;
    }

    public void initialize(AbstractTransformationMapping mapping) {
        this.transformationMapping = mapping;
        this.namespaceResolver = ((XMLDescriptor)mapping.getDescriptor()).getNamespaceResolver();
    }

    public Object buildAttributeValue(Record record, Object object, Session session) {
        if (null == record) {
            return null;
        }
        String value = (String)record.get(this.xPath);
        if (null == value) {
            return null;
        }
        int index = value.lastIndexOf(58);
        if (index > -1) {
            String prefix = value.substring(0, index);
            String localName = value.substring(index + 1);
            String namespaceURI = ((XMLRecord)record).resolveNamespacePrefix(prefix);
            if (namespaceURI != null) {
                return namespaceURI + '#' + localName;
            }
            return localName;
        }
        String namespaceURI = ((XMLRecord)record).resolveNamespacePrefix(DEFAULT_NAMESPACE_PREFIX);
        if (namespaceURI != null) {
            return namespaceURI + '#' + value;
        }
        return value;
    }

    public Object buildFieldValue(Object instance, String fieldName, Session session) {
        if (null == instance) {
            return null;
        }
        String value = (String)this.transformationMapping.getAttributeValueFromObject(instance);
        int index = value.lastIndexOf(35);
        if (index > -1) {
            String namespaceURI = value.substring(0, index);
            String localName = value.substring(index + 1);
            String prefix = this.namespaceResolver.resolveNamespaceURI(namespaceURI);
            if (prefix == null) {
                if (namespaceURI.equals(this.namespaceResolver.getDefaultNamespaceURI())) {
                    return localName;
                }
                prefix = QNAME_NAMESPACE_PREFIX;
            }
            return prefix + ':' + localName;
        }
        return value;
    }
}

