/*
 * Decompiled with CFR 0.152.
 */
package jodd.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;

public class HttpTransport {
    protected Socket socket;
    protected HttpRequest httpRequest;

    public Socket open(HttpRequest httpRequest) throws IOException {
        this.httpRequest = httpRequest;
        if (httpRequest.protocol().equals("https")) {
            SocketFactory ssocketFactory = SSLSocketFactory.getDefault();
            SSLSocket sslSocket = (SSLSocket)ssocketFactory.createSocket(httpRequest.host(), 443);
            sslSocket.startHandshake();
            this.socket = sslSocket;
        } else {
            this.socket = new Socket(httpRequest.host(), httpRequest.port());
        }
        return this.socket;
    }

    public HttpResponse send() throws IOException {
        OutputStream outputStream = this.socket.getOutputStream();
        this.httpRequest.sendTo(outputStream);
        InputStream inputStream = this.socket.getInputStream();
        return HttpResponse.readFrom(inputStream);
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Socket getSocket() {
        return this.socket;
    }
}

