/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.btree;

import java.util.Comparator;
import org.apache.cassandra.utils.SearchIterator;
import org.apache.cassandra.utils.btree.BTree;
import org.apache.cassandra.utils.btree.Path;

public class BTreeSearchIterator<CK, K extends CK, V>
extends Path
implements SearchIterator<K, V> {
    final Comparator<CK> comparator;

    public BTreeSearchIterator(Object[] btree, Comparator<CK> comparator) {
        this.init(btree);
        this.comparator = comparator;
    }

    @Override
    public V next(K target) {
        int successorParentIndex;
        Object[] successParentNode;
        Object successorParentKey;
        int c;
        byte successorParentDepth;
        while (this.depth > 0 && (successorParentDepth = this.findSuccessorParentDepth()) >= 0 && (c = BTree.compare(this.comparator, target, successorParentKey = (successParentNode = this.path[successorParentDepth])[successorParentIndex = this.indexes[successorParentDepth] + 1])) >= 0) {
            if (c == 0) {
                this.depth = successorParentDepth;
                byte by = successorParentDepth;
                this.indexes[by] = (byte)(this.indexes[by] + 1);
                return (V)successorParentKey;
            }
            this.depth = successorParentDepth;
            byte by = successorParentDepth;
            this.indexes[by] = (byte)(this.indexes[by] + 1);
        }
        if (this.find(this.comparator, target, Path.Op.CEIL, true)) {
            return (V)this.currentKey();
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.depth != 0 || this.indexes[0] != BTree.getKeyEnd(this.path[0]);
    }
}

