/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.calendar.lar;

import com.liferay.portal.kernel.cal.TZSRecurrence;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.calendar.model.CalEvent;
import com.liferay.portlet.calendar.service.CalEventLocalServiceUtil;
import com.liferay.portlet.calendar.service.persistence.CalEventUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.portlet.PortletPreferences;

public class CalendarPortletDataHandler
extends BasePortletDataHandler {
    public static final String NAMESPACE = "calendar";

    public CalendarPortletDataHandler() {
        this.setDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(CalEvent.class)});
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "events", true, true, null, CalEvent.class.getName())});
        this.setPublishToLiveByDefault(PropsValues.CALENDAR_PUBLISH_TO_LIVE_BY_DEFAULT);
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletDataContext.addPrimaryKey(CalendarPortletDataHandler.class, "deleteData")) {
            return portletPreferences;
        }
        CalEventLocalServiceUtil.deleteEvents((long)portletDataContext.getScopeGroupId());
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPermissions("com.liferay.portlet.calendar", portletDataContext.getScopeGroupId());
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        List events = CalEventUtil.findByGroupId((long)portletDataContext.getScopeGroupId());
        for (CalEvent event : events) {
            this.exportEvent(portletDataContext, rootElement, event);
        }
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPermissions("com.liferay.portlet.calendar", portletDataContext.getSourceGroupId(), portletDataContext.getScopeGroupId());
        Element rootElement = portletDataContext.getImportDataRootElement();
        for (Element eventElement : rootElement.elements("event")) {
            String path = eventElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            CalEvent event = (CalEvent)portletDataContext.getZipEntryAsObject(path);
            this.importEvent(portletDataContext, eventElement, event);
        }
        return null;
    }

    protected void exportEvent(PortletDataContext portletDataContext, Element rootElement, CalEvent event) throws PortalException, SystemException {
        if (!portletDataContext.isWithinDateRange(event.getModifiedDate())) {
            return;
        }
        String path = this.getEventPath(portletDataContext, event);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element eventElement = rootElement.addElement("event");
        portletDataContext.addClassedModel(eventElement, path, (ClassedModel)event);
    }

    protected String getEventPath(PortletDataContext portletDataContext, CalEvent event) {
        StringBundler sb = new StringBundler(4);
        sb.append(ExportImportPathUtil.getPortletPath((PortletDataContext)portletDataContext, (String)"8"));
        sb.append("/events/");
        sb.append(event.getEventId());
        sb.append(".xml");
        return sb.toString();
    }

    protected void importEvent(PortletDataContext portletDataContext, Element eventElement, CalEvent event) throws Exception {
        long userId = portletDataContext.getUserId(event.getUserUuid());
        Date startDate = event.getStartDate();
        int startDateMonth = 0;
        int startDateDay = 0;
        int startDateYear = 0;
        int startDateHour = 0;
        int startDateMinute = 0;
        if (startDate != null) {
            Locale locale = null;
            TimeZone timeZone = null;
            if (event.getTimeZoneSensitive()) {
                User user = UserLocalServiceUtil.getUser((long)userId);
                locale = user.getLocale();
                timeZone = user.getTimeZone();
            } else {
                locale = LocaleUtil.getSiteDefault();
                timeZone = TimeZoneUtil.getTimeZone((String)"UTC");
            }
            Calendar startCal = CalendarFactoryUtil.getCalendar((TimeZone)timeZone, (Locale)locale);
            startCal.setTime(startDate);
            startDateMonth = startCal.get(2);
            startDateDay = startCal.get(5);
            startDateYear = startCal.get(1);
            startDateHour = startCal.get(10);
            startDateMinute = startCal.get(12);
            if (startCal.get(9) == 1) {
                startDateHour += 12;
            }
        }
        ServiceContext serviceContext = portletDataContext.createServiceContext(eventElement, (ClassedModel)event);
        CalEvent importedEvent = null;
        if (portletDataContext.isDataStrategyMirror()) {
            CalEvent existingEvent = CalEventUtil.fetchByUUID_G((String)event.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingEvent == null) {
                serviceContext.setUuid(event.getUuid());
                importedEvent = CalEventLocalServiceUtil.addEvent((long)userId, (String)event.getTitle(), (String)event.getDescription(), (String)event.getLocation(), (int)startDateMonth, (int)startDateDay, (int)startDateYear, (int)startDateHour, (int)startDateMinute, (int)event.getDurationHour(), (int)event.getDurationMinute(), (boolean)event.isAllDay(), (boolean)event.isTimeZoneSensitive(), (String)event.getType(), (boolean)event.getRepeating(), (TZSRecurrence)event.getRecurrenceObj(), (int)event.getRemindBy(), (int)event.getFirstReminder(), (int)event.getSecondReminder(), (ServiceContext)serviceContext);
            } else {
                importedEvent = CalEventLocalServiceUtil.updateEvent((long)userId, (long)existingEvent.getEventId(), (String)event.getTitle(), (String)event.getDescription(), (String)event.getLocation(), (int)startDateMonth, (int)startDateDay, (int)startDateYear, (int)startDateHour, (int)startDateMinute, (int)event.getDurationHour(), (int)event.getDurationMinute(), (boolean)event.isAllDay(), (boolean)event.isTimeZoneSensitive(), (String)event.getType(), (boolean)event.getRepeating(), (TZSRecurrence)event.getRecurrenceObj(), (int)event.getRemindBy(), (int)event.getFirstReminder(), (int)event.getSecondReminder(), (ServiceContext)serviceContext);
            }
        } else {
            importedEvent = CalEventLocalServiceUtil.addEvent((long)userId, (String)event.getTitle(), (String)event.getDescription(), (String)event.getLocation(), (int)startDateMonth, (int)startDateDay, (int)startDateYear, (int)startDateHour, (int)startDateMinute, (int)event.getDurationHour(), (int)event.getDurationMinute(), (boolean)event.isAllDay(), (boolean)event.isTimeZoneSensitive(), (String)event.getType(), (boolean)event.getRepeating(), (TZSRecurrence)event.getRecurrenceObj(), (int)event.getRemindBy(), (int)event.getFirstReminder(), (int)event.getSecondReminder(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)event, (ClassedModel)importedEvent);
    }
}

