/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.netflix.astyanax.AstyanaxConfiguration;
import com.netflix.astyanax.CassandraOperationType;
import com.netflix.astyanax.ColumnMutation;
import com.netflix.astyanax.Execution;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.KeyspaceTracerFactory;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.SerializerPackage;
import com.netflix.astyanax.WriteAheadEntry;
import com.netflix.astyanax.WriteAheadLog;
import com.netflix.astyanax.connectionpool.ConnectionContext;
import com.netflix.astyanax.connectionpool.ConnectionPool;
import com.netflix.astyanax.connectionpool.Host;
import com.netflix.astyanax.connectionpool.Operation;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.TokenRange;
import com.netflix.astyanax.connectionpool.exceptions.BadRequestException;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.IsDeadConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.NotFoundException;
import com.netflix.astyanax.connectionpool.exceptions.OperationException;
import com.netflix.astyanax.connectionpool.exceptions.SchemaDisagreementException;
import com.netflix.astyanax.connectionpool.impl.OperationResultImpl;
import com.netflix.astyanax.connectionpool.impl.TokenRangeImpl;
import com.netflix.astyanax.cql.CqlStatement;
import com.netflix.astyanax.ddl.ColumnFamilyDefinition;
import com.netflix.astyanax.ddl.KeyspaceDefinition;
import com.netflix.astyanax.ddl.SchemaChangeResult;
import com.netflix.astyanax.ddl.impl.SchemaChangeResponseImpl;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.partitioner.Partitioner;
import com.netflix.astyanax.query.ColumnFamilyQuery;
import com.netflix.astyanax.retry.RetryPolicy;
import com.netflix.astyanax.retry.RunOnce;
import com.netflix.astyanax.serializers.SerializerPackageImpl;
import com.netflix.astyanax.serializers.UnknownComparatorException;
import com.netflix.astyanax.thrift.AbstractKeyspaceOperationImpl;
import com.netflix.astyanax.thrift.AbstractOperationImpl;
import com.netflix.astyanax.thrift.AbstractThriftColumnMutationImpl;
import com.netflix.astyanax.thrift.AbstractThriftMutationBatchImpl;
import com.netflix.astyanax.thrift.ThriftColumnFamilyQueryImpl;
import com.netflix.astyanax.thrift.ThriftConverter;
import com.netflix.astyanax.thrift.ThriftCqlFactory;
import com.netflix.astyanax.thrift.ThriftCqlFactoryResolver;
import com.netflix.astyanax.thrift.ThriftUtils;
import com.netflix.astyanax.thrift.ddl.ThriftColumnFamilyDefinitionImpl;
import com.netflix.astyanax.thrift.ddl.ThriftKeyspaceDefinitionImpl;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.EndpointDetails;
import org.apache.cassandra.thrift.KsDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThriftKeyspaceImpl
implements Keyspace {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftKeyspaceImpl.class);
    final ConnectionPool<Cassandra.Client> connectionPool;
    final AstyanaxConfiguration config;
    final String ksName;
    final ListeningExecutorService executor;
    final KeyspaceTracerFactory tracerFactory;
    final Cache<String, Object> cache;
    final ThriftCqlFactory cqlStatementFactory;
    private Host ddlHost = null;
    private volatile Partitioner partitioner;

    public ThriftKeyspaceImpl(String ksName, ConnectionPool<Cassandra.Client> pool, AstyanaxConfiguration config, KeyspaceTracerFactory tracerFactory) {
        this.connectionPool = pool;
        this.config = config;
        this.ksName = ksName;
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)config.getAsyncExecutor());
        this.tracerFactory = tracerFactory;
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();
        this.cqlStatementFactory = ThriftCqlFactoryResolver.createFactory(config);
    }

    public String getKeyspaceName() {
        return this.ksName;
    }

    public MutationBatch prepareMutationBatch() {
        return new AbstractThriftMutationBatchImpl(this.config.getClock(), this.config.getDefaultWriteConsistencyLevel(), this.config.getRetryPolicy().duplicate()){

            public OperationResult<Void> execute() throws ConnectionException {
                WriteAheadLog wal = this.getWriteAheadLog();
                WriteAheadEntry walEntry = null;
                if (wal != null) {
                    walEntry = wal.createEntry();
                    walEntry.writeMutation((MutationBatch)this);
                }
                try {
                    OperationResult result = ThriftKeyspaceImpl.this.executeOperation(new AbstractKeyspaceOperationImpl<Void>(ThriftKeyspaceImpl.this.tracerFactory.newTracer(this.useAtomicBatch() ? CassandraOperationType.ATOMIC_BATCH_MUTATE : CassandraOperationType.BATCH_MUTATE), this.getPinnedHost(), ThriftKeyspaceImpl.this.getKeyspaceName()){

                        @Override
                        public Void internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                            if (this.useAtomicBatch()) {
                                client.atomic_batch_mutate(this.getMutationMap(), ThriftConverter.ToThriftConsistencyLevel(this.getConsistencyLevel()));
                            } else {
                                client.batch_mutate(this.getMutationMap(), ThriftConverter.ToThriftConsistencyLevel(this.getConsistencyLevel()));
                            }
                            this.discardMutations();
                            return null;
                        }

                        @Override
                        public ByteBuffer getRowKey() {
                            if (this.getMutationMap().size() == 1) {
                                return this.getMutationMap().keySet().iterator().next();
                            }
                            return null;
                        }
                    }, this.getRetryPolicy());
                    if (walEntry != null) {
                        wal.removeEntry(walEntry);
                    }
                    return result;
                }
                catch (ConnectionException exception) {
                    throw exception;
                }
                catch (Exception exception) {
                    throw ThriftConverter.ToConnectionPoolException(exception);
                }
            }

            public ListenableFuture<OperationResult<Void>> executeAsync() throws ConnectionException {
                return ThriftKeyspaceImpl.this.executor.submit((Callable)new Callable<OperationResult<Void>>(){

                    @Override
                    public OperationResult<Void> call() throws Exception {
                        return this.execute();
                    }
                });
            }

            public MutationBatch withCaching(boolean condition) {
                return this;
            }
        };
    }

    public List<TokenRange> describeRing() throws ConnectionException {
        return this.describeRing(null, null);
    }

    public List<TokenRange> describeRing(String dc) throws ConnectionException {
        return this.describeRing(dc, null);
    }

    public List<TokenRange> describeRing(final String dc, final String rack) throws ConnectionException {
        return (List)this.executeOperation(new AbstractKeyspaceOperationImpl<List<TokenRange>>(this.tracerFactory.newTracer(CassandraOperationType.DESCRIBE_RING), this.getKeyspaceName()){

            @Override
            public List<TokenRange> internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                List trs = client.describe_ring(ThriftKeyspaceImpl.this.getKeyspaceName());
                ArrayList range = Lists.newArrayList();
                for (org.apache.cassandra.thrift.TokenRange tr : trs) {
                    ArrayList endpoints = Lists.newArrayList();
                    for (EndpointDetails ed : tr.getEndpoint_details()) {
                        if (dc != null && !ed.getDatacenter().equals(dc) || rack != null && !ed.getRack().equals(rack)) continue;
                        endpoints.add(ed.getHost());
                    }
                    if (endpoints.isEmpty()) continue;
                    range.add(new TokenRangeImpl(tr.getStart_token(), tr.getEnd_token(), (List)endpoints));
                }
                return range;
            }
        }, this.getConfig().getRetryPolicy().duplicate()).getResult();
    }

    public List<TokenRange> describeRing(boolean cached) throws ConnectionException {
        if (cached) {
            try {
                return (List)this.cache.get((Object)CassandraOperationType.DESCRIBE_RING.name(), (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ThriftKeyspaceImpl.this.describeRing();
                    }
                });
            }
            catch (ExecutionException e) {
                throw ThriftConverter.ToConnectionPoolException(e);
            }
        }
        return this.describeRing();
    }

    public KeyspaceDefinition describeKeyspace() throws ConnectionException {
        return (KeyspaceDefinition)this.internalDescribeKeyspace().getResult();
    }

    public OperationResult<KeyspaceDefinition> internalDescribeKeyspace() throws ConnectionException {
        return this.executeOperation(new AbstractKeyspaceOperationImpl<KeyspaceDefinition>(this.tracerFactory.newTracer(CassandraOperationType.DESCRIBE_KEYSPACE), this.getKeyspaceName()){

            @Override
            public KeyspaceDefinition internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                return new ThriftKeyspaceDefinitionImpl(client.describe_keyspace(ThriftKeyspaceImpl.this.getKeyspaceName()));
            }
        }, this.getConfig().getRetryPolicy().duplicate());
    }

    public Map<String, List<String>> describeSchemaVersions() throws ConnectionException {
        return (Map)this.connectionPool.executeWithFailover((Operation)new AbstractOperationImpl<Map<String, List<String>>>(this.tracerFactory.newTracer(CassandraOperationType.DESCRIBE_SCHEMA_VERSION)){

            @Override
            public Map<String, List<String>> internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                return client.describe_schema_versions();
            }
        }, this.config.getRetryPolicy().duplicate()).getResult();
    }

    public <K, C> ColumnFamilyQuery<K, C> prepareQuery(ColumnFamily<K, C> cf) {
        return new ThriftColumnFamilyQueryImpl<K, C>((ExecutorService)this.executor, this.tracerFactory, this, this.connectionPool, cf, this.config.getDefaultReadConsistencyLevel(), this.config.getRetryPolicy().duplicate());
    }

    public <K, C> ColumnMutation prepareColumnMutation(final ColumnFamily<K, C> columnFamily, final K rowKey, C column) {
        return new AbstractThriftColumnMutationImpl(columnFamily.getKeySerializer().toByteBuffer(rowKey), columnFamily.getColumnSerializer().toByteBuffer(column), this.config){

            public Execution<Void> incrementCounterColumn(final long amount) {
                return new Execution<Void>(){

                    public OperationResult<Void> execute() throws ConnectionException {
                        return ThriftKeyspaceImpl.this.executeOperation(new AbstractKeyspaceOperationImpl<Void>(ThriftKeyspaceImpl.this.tracerFactory.newTracer(CassandraOperationType.COUNTER_MUTATE), ThriftKeyspaceImpl.this.getKeyspaceName()){

                            @Override
                            public Void internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                                client.add(key, ThriftConverter.getColumnParent(columnFamily, null), new CounterColumn().setValue(amount).setName(column), ThriftConverter.ToThriftConsistencyLevel(writeConsistencyLevel));
                                return null;
                            }

                            @Override
                            public ByteBuffer getRowKey() {
                                return columnFamily.getKeySerializer().toByteBuffer(rowKey);
                            }
                        }, retry);
                    }

                    public ListenableFuture<OperationResult<Void>> executeAsync() throws ConnectionException {
                        return ThriftKeyspaceImpl.this.executor.submit((Callable)new Callable<OperationResult<Void>>(){

                            @Override
                            public OperationResult<Void> call() throws Exception {
                                return this.execute();
                            }
                        });
                    }
                };
            }

            public Execution<Void> deleteColumn() {
                return new Execution<Void>(){

                    public OperationResult<Void> execute() throws ConnectionException {
                        return ThriftKeyspaceImpl.this.executeOperation(new AbstractKeyspaceOperationImpl<Void>(ThriftKeyspaceImpl.this.tracerFactory.newTracer(CassandraOperationType.COLUMN_DELETE), ThriftKeyspaceImpl.this.getKeyspaceName()){

                            @Override
                            public Void internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                                client.remove(key, new ColumnPath().setColumn_family(columnFamily.getName()).setColumn(column), ThriftKeyspaceImpl.this.config.getClock().getCurrentTime(), ThriftConverter.ToThriftConsistencyLevel(writeConsistencyLevel));
                                return null;
                            }

                            @Override
                            public ByteBuffer getRowKey() {
                                return columnFamily.getKeySerializer().toByteBuffer(rowKey);
                            }
                        }, retry);
                    }

                    public ListenableFuture<OperationResult<Void>> executeAsync() throws ConnectionException {
                        return ThriftKeyspaceImpl.this.executor.submit((Callable)new Callable<OperationResult<Void>>(){

                            @Override
                            public OperationResult<Void> call() throws Exception {
                                return this.execute();
                            }
                        });
                    }
                };
            }

            @Override
            public Execution<Void> insertValue(final ByteBuffer value, final Integer ttl) {
                return new Execution<Void>(){

                    public OperationResult<Void> execute() throws ConnectionException {
                        return ThriftKeyspaceImpl.this.executeOperation(new AbstractKeyspaceOperationImpl<Void>(ThriftKeyspaceImpl.this.tracerFactory.newTracer(CassandraOperationType.COLUMN_INSERT), ThriftKeyspaceImpl.this.getKeyspaceName()){

                            @Override
                            public Void internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                                Column c = new Column();
                                c.setName(column).setValue(value).setTimestamp(clock.getCurrentTime());
                                if (ttl != null) {
                                    c.setTtl(ttl.intValue());
                                }
                                client.insert(key, ThriftConverter.getColumnParent(columnFamily, null), c, ThriftConverter.ToThriftConsistencyLevel(writeConsistencyLevel));
                                return null;
                            }

                            @Override
                            public ByteBuffer getRowKey() {
                                return columnFamily.getKeySerializer().toByteBuffer(rowKey);
                            }
                        }, retry);
                    }

                    public ListenableFuture<OperationResult<Void>> executeAsync() throws ConnectionException {
                        return ThriftKeyspaceImpl.this.executor.submit((Callable)new Callable<OperationResult<Void>>(){

                            @Override
                            public OperationResult<Void> call() throws Exception {
                                return this.execute();
                            }
                        });
                    }
                };
            }

            public Execution<Void> deleteCounterColumn() {
                return new Execution<Void>(){

                    public OperationResult<Void> execute() throws ConnectionException {
                        return ThriftKeyspaceImpl.this.executeOperation(new AbstractKeyspaceOperationImpl<Void>(ThriftKeyspaceImpl.this.tracerFactory.newTracer(CassandraOperationType.COLUMN_DELETE), ThriftKeyspaceImpl.this.getKeyspaceName()){

                            @Override
                            public Void internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                                client.remove_counter(key, new ColumnPath().setColumn_family(columnFamily.getName()).setColumn(column), ThriftConverter.ToThriftConsistencyLevel(writeConsistencyLevel));
                                return null;
                            }

                            @Override
                            public ByteBuffer getRowKey() {
                                return columnFamily.getKeySerializer().toByteBuffer(rowKey);
                            }
                        }, retry);
                    }

                    public ListenableFuture<OperationResult<Void>> executeAsync() throws ConnectionException {
                        return ThriftKeyspaceImpl.this.executor.submit((Callable)new Callable<OperationResult<Void>>(){

                            @Override
                            public OperationResult<Void> call() throws Exception {
                                return this.execute();
                            }
                        });
                    }
                };
            }
        };
    }

    public AstyanaxConfiguration getConfig() {
        return this.config;
    }

    public SerializerPackage getSerializerPackage(String cfName, boolean ignoreErrors) throws ConnectionException, UnknownComparatorException {
        return new SerializerPackageImpl(this.describeKeyspace().getColumnFamily(cfName), ignoreErrors);
    }

    public OperationResult<Void> testOperation(Operation<?, ?> operation) throws ConnectionException {
        return this.testOperation(operation, this.config.getRetryPolicy().duplicate());
    }

    public OperationResult<Void> testOperation(final Operation<?, ?> operation, RetryPolicy retry) throws ConnectionException {
        return this.executeOperation(new AbstractKeyspaceOperationImpl<Void>(this.tracerFactory.newTracer(CassandraOperationType.TEST), operation.getPinnedHost(), this.getKeyspaceName()){

            @Override
            public Void internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                operation.execute(null, context);
                return null;
            }
        }, retry);
    }

    public ConnectionPool<Cassandra.Client> getConnectionPool() {
        return this.connectionPool;
    }

    public <K, C> OperationResult<Void> truncateColumnFamily(ColumnFamily<K, C> columnFamily) throws OperationException, ConnectionException {
        return this.truncateColumnFamily(columnFamily.getName());
    }

    public OperationResult<Void> truncateColumnFamily(final String columnFamily) throws ConnectionException {
        return this.executeOperation(new AbstractKeyspaceOperationImpl<Void>(this.tracerFactory.newTracer(CassandraOperationType.TRUNCATE), this.getKeyspaceName()){

            @Override
            public Void internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                client.truncate(columnFamily);
                return null;
            }
        }, this.config.getRetryPolicy().duplicate());
    }

    private <R> OperationResult<R> executeOperation(Operation<Cassandra.Client, R> operation, RetryPolicy retry) throws OperationException, ConnectionException {
        return this.connectionPool.executeWithFailover(operation, retry);
    }

    private synchronized <R> OperationResult<R> executeDdlOperation(AbstractOperationImpl<R> operation, RetryPolicy retry) throws OperationException, ConnectionException {
        ConnectionException lastException = null;
        for (int i = 0; i < 2; ++i) {
            operation.setPinnedHost(this.ddlHost);
            try {
                OperationResult result = this.connectionPool.executeWithFailover(operation, retry);
                this.ddlHost = result.getHost();
                return result;
            }
            catch (ConnectionException e) {
                lastException = e;
                if (!(e instanceof IsDeadConnectionException)) continue;
                this.ddlHost = null;
                continue;
            }
        }
        throw lastException;
    }

    public String describePartitioner() throws ConnectionException {
        return (String)this.executeOperation(new AbstractOperationImpl<String>(this.tracerFactory.newTracer(CassandraOperationType.DESCRIBE_PARTITIONER)){

            @Override
            public String internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                return client.describe_partitioner();
            }
        }, this.config.getRetryPolicy().duplicate()).getResult();
    }

    public OperationResult<SchemaChangeResult> createColumnFamily(Map<String, Object> options) throws ConnectionException {
        CfDef cfDef = this.toThriftColumnFamilyDefinition(options, null).getThriftColumnFamilyDefinition();
        return this.internalCreateColumnFamily(cfDef);
    }

    public OperationResult<SchemaChangeResult> createKeyspaceIfNotExists(final Map<String, Object> options) throws ConnectionException {
        return this.createKeyspaceIfNotExists(new Callable<OperationResult<SchemaChangeResult>>(){

            @Override
            public OperationResult<SchemaChangeResult> call() throws Exception {
                return ThriftKeyspaceImpl.this.createKeyspace(options);
            }
        });
    }

    public OperationResult<SchemaChangeResult> createKeyspace(Map<String, Object> options, Map<ColumnFamily, Map<String, Object>> cfs) throws ConnectionException {
        ThriftKeyspaceDefinitionImpl ksDef = this.toThriftKeyspaceDefinition(options);
        for (Map.Entry<ColumnFamily, Map<String, Object>> cf : cfs.entrySet()) {
            ksDef.addColumnFamily(this.toThriftColumnFamilyDefinition(cf.getValue(), cf.getKey()));
        }
        ksDef.setName(this.getKeyspaceName());
        return this.internalCreateKeyspace(ksDef.getThriftKeyspaceDefinition());
    }

    public OperationResult<SchemaChangeResult> createKeyspaceIfNotExists(final Map<String, Object> options, final Map<ColumnFamily, Map<String, Object>> cfs) throws ConnectionException {
        return this.createKeyspaceIfNotExists(new Callable<OperationResult<SchemaChangeResult>>(){

            @Override
            public OperationResult<SchemaChangeResult> call() throws Exception {
                return ThriftKeyspaceImpl.this.createKeyspace(options, cfs);
            }
        });
    }

    public OperationResult<SchemaChangeResult> createKeyspace(Properties props) throws ConnectionException {
        KsDef ksDef;
        if (props.containsKey("name") && !props.get("name").equals(this.getKeyspaceName())) {
            throw new BadRequestException(String.format("'name' attribute must match keyspace name. Expected '%s' but got '%s'", this.getKeyspaceName(), props.get("name")));
        }
        try {
            ksDef = ThriftUtils.getThriftObjectFromProperties(KsDef.class, props);
        }
        catch (Exception e) {
            throw new BadRequestException("Unable to convert props to keyspace definition");
        }
        return this.internalCreateKeyspace(ksDef);
    }

    public OperationResult<SchemaChangeResult> createKeyspaceIfNotExists(final Properties props) throws ConnectionException {
        return this.createKeyspaceIfNotExists(new Callable<OperationResult<SchemaChangeResult>>(){

            @Override
            public OperationResult<SchemaChangeResult> call() throws Exception {
                return ThriftKeyspaceImpl.this.createKeyspace(props);
            }
        });
    }

    private OperationResult<SchemaChangeResult> createKeyspaceIfNotExists(Callable<OperationResult<SchemaChangeResult>> createKeyspace) throws ConnectionException {
        boolean shouldCreateKeyspace = false;
        try {
            OperationResult<KeyspaceDefinition> opResult = this.internalDescribeKeyspace();
            if (opResult != null && opResult.getResult() != null) {
                return new OperationResultImpl(opResult.getHost(), (Object)new SchemaChangeResponseImpl().setSchemaId("no-op"), opResult.getLatency());
            }
            shouldCreateKeyspace = true;
        }
        catch (BadRequestException e) {
            if (e.isKeyspaceDoestNotExist()) {
                shouldCreateKeyspace = true;
            }
            throw e;
        }
        if (shouldCreateKeyspace) {
            try {
                return createKeyspace.call();
            }
            catch (ConnectionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalStateException();
    }

    public <K, C> OperationResult<SchemaChangeResult> createColumnFamily(ColumnFamily<K, C> columnFamily, Map<String, Object> options) throws ConnectionException {
        CfDef cfDef = this.toThriftColumnFamilyDefinition(options, columnFamily).getThriftColumnFamilyDefinition();
        return this.internalCreateColumnFamily(cfDef);
    }

    public <K, C> OperationResult<SchemaChangeResult> updateColumnFamily(ColumnFamily<K, C> columnFamily, Map<String, Object> options) throws ConnectionException {
        CfDef cfDef = this.toThriftColumnFamilyDefinition(options, columnFamily).getThriftColumnFamilyDefinition();
        return this.internalUpdateColumnFamily(cfDef);
    }

    public OperationResult<SchemaChangeResult> dropColumnFamily(final String columnFamilyName) throws ConnectionException {
        return this.executeDdlOperation(new AbstractKeyspaceOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.DROP_COLUMN_FAMILY), this.getKeyspaceName()){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                ThriftKeyspaceImpl.this.precheckSchemaAgreement(client);
                return new SchemaChangeResponseImpl().setSchemaId(client.system_drop_column_family(columnFamilyName));
            }
        }, (RetryPolicy)RunOnce.get());
    }

    public <K, C> OperationResult<SchemaChangeResult> dropColumnFamily(ColumnFamily<K, C> columnFamily) throws ConnectionException {
        return this.dropColumnFamily(columnFamily.getName());
    }

    public OperationResult<SchemaChangeResult> createKeyspace(Map<String, Object> options) throws ConnectionException {
        KsDef ksDef = this.toThriftKeyspaceDefinition(options).getThriftKeyspaceDefinition();
        return this.internalCreateKeyspace(ksDef);
    }

    public OperationResult<SchemaChangeResult> updateKeyspace(Map<String, Object> options) throws ConnectionException {
        KsDef ksDef = this.toThriftKeyspaceDefinition(options).getThriftKeyspaceDefinition();
        return this.internalUpdateKeyspace(ksDef);
    }

    public OperationResult<SchemaChangeResult> dropKeyspace() throws ConnectionException {
        return this.executeDdlOperation(new AbstractKeyspaceOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.DROP_KEYSPACE), this.getKeyspaceName()){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                ThriftKeyspaceImpl.this.precheckSchemaAgreement(client);
                return new SchemaChangeResponseImpl().setSchemaId(client.system_drop_keyspace(ThriftKeyspaceImpl.this.getKeyspaceName()));
            }
        }, (RetryPolicy)RunOnce.get());
    }

    public CqlStatement prepareCqlStatement() {
        return this.cqlStatementFactory.createCqlStatement(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Partitioner getPartitioner() throws ConnectionException {
        if (this.partitioner == null) {
            ThriftKeyspaceImpl thriftKeyspaceImpl = this;
            synchronized (thriftKeyspaceImpl) {
                if (this.partitioner == null) {
                    String partitionerName = this.describePartitioner();
                    try {
                        this.partitioner = this.config.getPartitioner(partitionerName);
                        LOG.info(String.format("Detected partitioner %s for keyspace %s", partitionerName, this.ksName));
                    }
                    catch (Exception e) {
                        throw new NotFoundException("Unable to determine partitioner " + partitionerName, (Throwable)e);
                    }
                }
            }
        }
        return this.partitioner;
    }

    private void precheckSchemaAgreement(Cassandra.Client client) throws Exception {
        Map schemas = client.describe_schema_versions();
        if (schemas.size() > 1) {
            throw new SchemaDisagreementException("Can't change schema due to pending schema agreement");
        }
    }

    private ThriftColumnFamilyDefinitionImpl toThriftColumnFamilyDefinition(Map<String, Object> options, ColumnFamily columnFamily) {
        ThriftColumnFamilyDefinitionImpl def = new ThriftColumnFamilyDefinitionImpl();
        HashMap internalOptions = Maps.newHashMap();
        if (options != null) {
            internalOptions.putAll(options);
        }
        internalOptions.put("keyspace", this.getKeyspaceName());
        if (columnFamily != null) {
            internalOptions.put("name", columnFamily.getName());
            if (!internalOptions.containsKey("comparator_type")) {
                internalOptions.put("comparator_type", columnFamily.getColumnSerializer().getComparatorType().getTypeName());
            }
            if (!internalOptions.containsKey("key_validation_class")) {
                internalOptions.put("key_validation_class", columnFamily.getKeySerializer().getComparatorType().getTypeName());
            }
            if (columnFamily.getDefaultValueSerializer() != null && !internalOptions.containsKey("default_validation_class")) {
                internalOptions.put("default_validation_class", columnFamily.getDefaultValueSerializer().getComparatorType().getTypeName());
            }
        }
        def.setFields(internalOptions);
        return def;
    }

    private ThriftKeyspaceDefinitionImpl toThriftKeyspaceDefinition(Map<String, Object> options) {
        ThriftKeyspaceDefinitionImpl def = new ThriftKeyspaceDefinitionImpl();
        HashMap internalOptions = Maps.newHashMap();
        if (options != null) {
            internalOptions.putAll(options);
        }
        if (internalOptions.containsKey("name") && !internalOptions.get("name").equals(this.getKeyspaceName())) {
            throw new RuntimeException(String.format("'name' attribute must match keyspace name. Expected '%s' but got '%s'", this.getKeyspaceName(), internalOptions.get("name")));
        }
        internalOptions.put("name", this.getKeyspaceName());
        def.setFields(internalOptions);
        return def;
    }

    public OperationResult<SchemaChangeResult> updateKeyspace(Properties props) throws ConnectionException {
        KsDef ksDef;
        if (props.containsKey("name") && !props.get("name").equals(this.getKeyspaceName())) {
            throw new RuntimeException(String.format("'name' attribute must match keyspace name. Expected '%s' but got '%s'", this.getKeyspaceName(), props.get("name")));
        }
        try {
            ksDef = ThriftUtils.getThriftObjectFromProperties(KsDef.class, props);
        }
        catch (Exception e) {
            throw new BadRequestException("Unable to convert properties to KsDef", (Throwable)e);
        }
        ksDef.setName(this.getKeyspaceName());
        return this.internalUpdateKeyspace(ksDef);
    }

    public OperationResult<SchemaChangeResult> internalUpdateKeyspace(final KsDef ksDef) throws ConnectionException {
        return this.connectionPool.executeWithFailover((Operation)new AbstractOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.UPDATE_KEYSPACE)){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                ThriftKeyspaceImpl.this.precheckSchemaAgreement(client);
                return new SchemaChangeResponseImpl().setSchemaId(client.system_update_keyspace(ksDef));
            }
        }, (RetryPolicy)RunOnce.get());
    }

    public OperationResult<SchemaChangeResult> internalCreateKeyspace(final KsDef ksDef) throws ConnectionException {
        if (ksDef.getCf_defs() == null) {
            ksDef.setCf_defs((List)Lists.newArrayList());
        }
        return this.executeDdlOperation(new AbstractOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.ADD_KEYSPACE)){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                ThriftKeyspaceImpl.this.precheckSchemaAgreement(client);
                return new SchemaChangeResponseImpl().setSchemaId(client.system_add_keyspace(ksDef));
            }
        }, (RetryPolicy)RunOnce.get());
    }

    public OperationResult<SchemaChangeResult> createColumnFamily(Properties props) throws ConnectionException {
        CfDef cfDef;
        if (props.containsKey("keyspace") && !props.get("keyspace").equals(this.getKeyspaceName())) {
            throw new RuntimeException(String.format("'keyspace' attribute must match keyspace name. Expected '%s' but got '%s'", this.getKeyspaceName(), props.get("keyspace")));
        }
        try {
            cfDef = ThriftUtils.getThriftObjectFromProperties(CfDef.class, props);
        }
        catch (Exception e) {
            throw new BadRequestException("Unable to convert properties to CfDef", (Throwable)e);
        }
        cfDef.setKeyspace(this.getKeyspaceName());
        return this.internalCreateColumnFamily(cfDef);
    }

    private OperationResult<SchemaChangeResult> internalCreateColumnFamily(final CfDef cfDef) throws ConnectionException {
        return this.executeDdlOperation(new AbstractKeyspaceOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.ADD_COLUMN_FAMILY), this.getKeyspaceName()){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                ThriftKeyspaceImpl.this.precheckSchemaAgreement(client);
                LOG.info(cfDef.toString());
                return new SchemaChangeResponseImpl().setSchemaId(client.system_add_column_family(cfDef));
            }
        }, (RetryPolicy)RunOnce.get());
    }

    private OperationResult<SchemaChangeResult> internalUpdateColumnFamily(final CfDef cfDef) throws ConnectionException {
        return this.executeDdlOperation(new AbstractKeyspaceOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.ADD_COLUMN_FAMILY), this.getKeyspaceName()){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                ThriftKeyspaceImpl.this.precheckSchemaAgreement(client);
                return new SchemaChangeResponseImpl().setSchemaId(client.system_update_column_family(cfDef));
            }
        }, (RetryPolicy)RunOnce.get());
    }

    public OperationResult<SchemaChangeResult> updateColumnFamily(final Map<String, Object> options) throws ConnectionException {
        if (options.containsKey("keyspace") && !options.get("keyspace").equals(this.getKeyspaceName())) {
            throw new RuntimeException(String.format("'keyspace' attribute must match keyspace name. Expected '%s' but got '%s'", this.getKeyspaceName(), options.get("keyspace")));
        }
        return this.connectionPool.executeWithFailover((Operation)new AbstractKeyspaceOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.UPDATE_COLUMN_FAMILY), this.getKeyspaceName()){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                ThriftColumnFamilyDefinitionImpl def = new ThriftColumnFamilyDefinitionImpl();
                def.setFields(options);
                def.setKeyspace(ThriftKeyspaceImpl.this.getKeyspaceName());
                return new SchemaChangeResponseImpl().setSchemaId(client.system_update_column_family(def.getThriftColumnFamilyDefinition()));
            }
        }, (RetryPolicy)RunOnce.get());
    }

    public OperationResult<SchemaChangeResult> updateColumnFamily(final Properties props) throws ConnectionException {
        if (props.containsKey("keyspace") && !props.get("keyspace").equals(this.getKeyspaceName())) {
            throw new RuntimeException(String.format("'keyspace' attribute must match keyspace name. Expected '%s' but got '%s'", this.getKeyspaceName(), props.get("keyspace")));
        }
        return this.connectionPool.executeWithFailover((Operation)new AbstractKeyspaceOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.ADD_COLUMN_FAMILY), this.getKeyspaceName()){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                CfDef def = ThriftUtils.getThriftObjectFromProperties(CfDef.class, props);
                def.setKeyspace(ThriftKeyspaceImpl.this.getKeyspaceName());
                return new SchemaChangeResponseImpl().setSchemaId(client.system_update_column_family(def));
            }
        }, (RetryPolicy)RunOnce.get());
    }

    public Properties getKeyspaceProperties() throws ConnectionException {
        KeyspaceDefinition ksDef = this.describeKeyspace();
        if (ksDef == null) {
            throw new NotFoundException(String.format("Keyspace '%s' not found", this.getKeyspaceName()));
        }
        Properties props = new Properties();
        ThriftKeyspaceDefinitionImpl thriftKsDef = (ThriftKeyspaceDefinitionImpl)ksDef;
        try {
            for (Map.Entry<Object, Object> prop : thriftKsDef.getProperties().entrySet()) {
                props.setProperty((String)prop.getKey(), (String)prop.getValue());
            }
        }
        catch (Exception e) {
            LOG.error(String.format("Error fetching properties for keyspace '%s'", this.getKeyspaceName()));
        }
        return props;
    }

    public Properties getColumnFamilyProperties(String columnFamily) throws ConnectionException {
        KeyspaceDefinition ksDef = this.describeKeyspace();
        ColumnFamilyDefinition cfDef = ksDef.getColumnFamily(columnFamily);
        if (cfDef == null) {
            throw new NotFoundException(String.format("Column family '%s' in keyspace '%s' not found", columnFamily, this.getKeyspaceName()));
        }
        Properties props = new Properties();
        ThriftColumnFamilyDefinitionImpl thriftCfDef = (ThriftColumnFamilyDefinitionImpl)cfDef;
        try {
            for (Map.Entry<Object, Object> prop : thriftCfDef.getProperties().entrySet()) {
                props.setProperty((String)prop.getKey(), (String)prop.getValue());
            }
        }
        catch (Exception e) {
            LOG.error("Error processing column family properties");
        }
        return props;
    }
}

