/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper.relation.lazy.initializor;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.entities.mapper.relation.lazy.initializor.AbstractCollectionInitializor;
import org.hibernate.envers.entities.mapper.relation.query.RelationQueryGenerator;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.reader.AuditReaderImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicCollectionInitializor<T extends Collection>
extends AbstractCollectionInitializor<T> {
    protected final Class<? extends T> collectionClass;
    private final MiddleComponentData elementComponentData;

    public BasicCollectionInitializor(AuditConfiguration verCfg, AuditReaderImplementor versionsReader, RelationQueryGenerator queryGenerator, Object primaryKey, Number revision, Class<? extends T> collectionClass, MiddleComponentData elementComponentData) {
        super(verCfg, versionsReader, queryGenerator, primaryKey, revision);
        this.collectionClass = collectionClass;
        this.elementComponentData = elementComponentData;
    }

    @Override
    protected T initializeCollection(int size) {
        try {
            return (T)((Collection)this.collectionClass.newInstance());
        }
        catch (InstantiationException e) {
            throw new AuditException(e);
        }
        catch (IllegalAccessException e) {
            throw new AuditException(e);
        }
    }

    @Override
    protected void addToCollection(T collection, Object collectionRow) {
        Object elementData = collectionRow;
        if (collectionRow instanceof List) {
            elementData = ((List)collectionRow).get(this.elementComponentData.getComponentIndex());
        }
        Object element = elementData instanceof Map ? this.elementComponentData.getComponentMapper().mapToObjectFromFullMap(this.entityInstantiator, (Map)elementData, null, this.revision) : elementData;
        collection.add((Object)element);
    }
}

