/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.examples;

import com.netflix.astyanax.AstyanaxConfiguration;
import com.netflix.astyanax.AstyanaxContext;
import com.netflix.astyanax.AstyanaxTypeFactory;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import com.netflix.astyanax.connectionpool.ConnectionPoolMonitor;
import com.netflix.astyanax.connectionpool.NodeDiscoveryType;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.impl.ConnectionPoolConfigurationImpl;
import com.netflix.astyanax.connectionpool.impl.CountingConnectionPoolMonitor;
import com.netflix.astyanax.impl.AstyanaxConfigurationImpl;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.serializers.IntegerSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.thrift.ThriftFamilyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AstClient {
    private static final Logger logger = LoggerFactory.getLogger(AstClient.class);
    private AstyanaxContext<Keyspace> context;
    private Keyspace keyspace;
    private ColumnFamily<Integer, String> EMP_CF;
    private static final String EMP_CF_NAME = "employees2";

    public void init() {
        logger.debug("init()");
        this.context = new AstyanaxContext.Builder().forCluster("Test Cluster").forKeyspace("test1").withAstyanaxConfiguration((AstyanaxConfiguration)new AstyanaxConfigurationImpl().setDiscoveryType(NodeDiscoveryType.RING_DESCRIBE)).withConnectionPoolConfiguration((ConnectionPoolConfiguration)new ConnectionPoolConfigurationImpl("MyConnectionPool").setPort(9160).setMaxConnsPerHost(1).setSeeds("127.0.0.1:9160")).withAstyanaxConfiguration((AstyanaxConfiguration)new AstyanaxConfigurationImpl().setCqlVersion("3.0.0").setTargetCassandraVersion("1.2")).withConnectionPoolMonitor((ConnectionPoolMonitor)new CountingConnectionPoolMonitor()).buildKeyspace((AstyanaxTypeFactory)ThriftFamilyFactory.getInstance());
        this.context.start();
        this.keyspace = (Keyspace)this.context.getEntity();
        this.EMP_CF = ColumnFamily.newColumnFamily((String)EMP_CF_NAME, (Serializer)IntegerSerializer.get(), (Serializer)StringSerializer.get());
    }

    public void insert(int empId, int deptId, String firstName, String lastName) {
        MutationBatch m = this.keyspace.prepareMutationBatch();
        m.withRow(this.EMP_CF, (Object)empId).putColumn((Object)"empid", empId, null).putColumn((Object)"deptid", deptId, null).putColumn((Object)"first_name", firstName, null).putColumn((Object)"last_name", lastName, null);
        try {
            OperationResult result = m.execute();
        }
        catch (ConnectionException e) {
            logger.error("failed to write data to C*", (Throwable)e);
            throw new RuntimeException("failed to write data to C*", e);
        }
        logger.debug("insert ok");
    }

    public void createCF() {
    }

    public void read(int empId) {
        try {
            OperationResult result = this.keyspace.prepareQuery(this.EMP_CF).getKey((Object)empId).execute();
            ColumnList cols = (ColumnList)result.getResult();
            logger.debug("read: isEmpty: " + cols.isEmpty());
            logger.debug("emp");
            for (Column c : cols) {
                Object v = null;
                v = ((String)c.getName()).endsWith("id") ? Integer.valueOf(c.getIntegerValue()) : c.getStringValue();
                logger.debug("- col: '" + (String)c.getName() + "': " + v);
            }
            logger.debug("emp");
            logger.debug("- emp id: " + cols.getIntegerValue((Object)"empid", null));
            logger.debug("- dept: " + cols.getIntegerValue((Object)"deptid", null));
            logger.debug("- firstName: " + cols.getStringValue((Object)"first_name", null));
            logger.debug("- lastName: " + cols.getStringValue((Object)"last_name", null));
        }
        catch (ConnectionException e) {
            logger.error("failed to read from C*", (Throwable)e);
            throw new RuntimeException("failed to read from C*", e);
        }
    }

    public static void main(String[] args) {
        AstClient c = new AstClient();
        c.init();
        c.insert(222, 333, "Eric", "Cartman");
        c.read(222);
    }
}

