/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Routine;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.StatementSchema;
import org.hsqldb.Table;
import org.hsqldb.TableWorks;
import org.hsqldb.TextTable;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.result.Result;
import org.hsqldb.rights.User;
import org.hsqldb.scriptio.ScriptWriterText;

public class StatementCommand
extends Statement {
    Object[] parameters;

    StatementCommand(int type, Object[] args) {
        this(type, args, null, null);
    }

    StatementCommand(int type, Object[] args, HsqlNameManager.HsqlName[] readNames, HsqlNameManager.HsqlName[] writeNames) {
        super(type);
        this.isTransactionStatement = true;
        this.parameters = args;
        if (readNames != null) {
            this.readTableNames = readNames;
        }
        if (writeNames != null) {
            this.writeTableNames = writeNames;
        }
        switch (type) {
            case 1002: {
                this.group = 2014;
                this.isLogged = false;
                break;
            }
            case 1004: {
                String name = (String)this.parameters[0];
                if (name == null) {
                    this.statementReturnType = 2;
                }
                this.group = 2014;
                this.isLogged = false;
            }
            case 1001: {
                this.group = 2014;
                this.isLogged = false;
                break;
            }
            case 1025: 
            case 1026: 
            case 1052: {
                this.isTransactionStatement = false;
                this.group = 2013;
                break;
            }
            case 1011: 
            case 1012: 
            case 1013: 
            case 1014: 
            case 1015: 
            case 1016: 
            case 1017: 
            case 1018: 
            case 1019: 
            case 1020: 
            case 1023: 
            case 1024: 
            case 1031: 
            case 1032: 
            case 1033: 
            case 1034: 
            case 1035: 
            case 1036: 
            case 1040: 
            case 1041: 
            case 1046: 
            case 1047: 
            case 1048: 
            case 1049: 
            case 1050: 
            case 1051: {
                this.group = 2013;
                this.isTransactionStatement = true;
                break;
            }
            case 1198: {
                this.group = 2012;
                break;
            }
            case 1196: {
                this.isLogged = false;
            }
            case 1195: {
                this.metaDataImpact = 1;
                this.group = 2012;
                this.isTransactionStatement = true;
                break;
            }
            case 1194: {
                this.metaDataImpact = 1;
                this.group = 2012;
                this.isTransactionStatement = true;
                break;
            }
            case 1003: {
                this.isLogged = false;
                this.group = 2014;
                this.isTransactionStatement = false;
                break;
            }
            case 1197: {
                this.group = 2012;
                this.isTransactionStatement = true;
                break;
            }
            case 1193: {
                this.group = 2013;
                this.isTransactionStatement = false;
                this.isLogged = false;
                break;
            }
            case 1060: 
            case 1061: 
            case 1062: {
                this.group = 2013;
                this.isTransactionStatement = false;
                break;
            }
            case 1005: {
                this.group = 2011;
                this.isTransactionStatement = false;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementCommand");
            }
        }
    }

    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable t) {
            result = Result.newErrorResult(t, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
            return result;
        }
        try {
            if (this.isLogged) {
                session.database.logger.writeOtherStatement(session, this.sql);
            }
        }
        catch (Throwable e) {
            return Result.newErrorResult(e, this.sql);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Result getResult(Session session) {
        if (this.isExplain) {
            return Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        }
        switch (this.type) {
            case 1001: {
                String path = (String)this.parameters[0];
                boolean blocking = (Boolean)this.parameters[1];
                boolean script = (Boolean)this.parameters[2];
                boolean compressed = (Boolean)this.parameters[3];
                try {
                    session.checkAdmin();
                    if (!session.database.getType().equals("file:")) {
                        return Result.newErrorResult(Error.error(464));
                    }
                    if (session.database.isReadOnly()) {
                        return Result.newErrorResult(Error.error(459), null);
                    }
                    if (session.database.logger.isStoredFileAccess()) {
                        return Result.newErrorResult(Error.error(464), null);
                    }
                    session.database.logger.backup(path, script, blocking, compressed);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1002: {
                Result blocking;
                boolean defrag = (Boolean)this.parameters[0];
                session.database.lobManager.lock();
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.checkpoint(defrag);
                    blocking = Result.updateZeroResult;
                    Object var8_113 = null;
                }
                catch (HsqlException e) {
                    try {
                        Result script = Result.newErrorResult(e, this.sql);
                        Object var8_114 = null;
                        session.database.lobManager.unlock();
                        return script;
                    }
                    catch (Throwable throwable) {
                        Object var8_115 = null;
                        session.database.lobManager.unlock();
                        throw throwable;
                    }
                }
                session.database.lobManager.unlock();
                return blocking;
            }
            case 1011: {
                try {
                    boolean mode = (Boolean)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setIncrementBackup(mode);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1012: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setCacheMaxRows(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1013: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setCacheSize(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1016: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (session.isProcessingScript) {
                        session.database.logger.setLobFileScaleNoCheck(value);
                    } else {
                        session.database.logger.setLobFileScale(value);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1023: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (session.isProcessingScript) {
                        session.database.logger.setCacheFileScaleNoCheck(value);
                    } else {
                        session.database.logger.setCacheFileScale(value);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1014: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setDefagLimit(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1015: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setEventLogLevel(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1017: {
                try {
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1020: {
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    Object v = this.parameters[0];
                    if (v instanceof Boolean) {
                        boolean value = (Boolean)this.parameters[0];
                        session.database.logger.setNioDataFile(value);
                    } else {
                        int value = (Integer)this.parameters[0];
                        session.database.logger.setNioMaxSize(value);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1018: {
                try {
                    boolean value = (Boolean)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setLogData(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1019: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setLogSize(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1025: {
                try {
                    String value = (String)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1024: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setScriptType(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1026: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setWriteDelay(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1033: {
                try {
                    Routine routine = (Routine)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.userManager.setExtAuthenticationFunction(routine);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1036: {
                try {
                    Routine routine = (Routine)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.userManager.setPasswordCheckFunction(routine);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1041: {
                try {
                    String name = (String)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.collation.setCollation(name);
                    session.database.schemaManager.setSchemaChangeTimestamp();
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1046: {
                boolean mode = (Boolean)this.parameters[0];
                session.checkAdmin();
                session.checkDDLWrite();
                session.database.setReferentialIntegrity(mode);
                return Result.updateZeroResult;
            }
            case 1047: {
                String property = (String)this.parameters[0];
                boolean mode = (Boolean)this.parameters[1];
                session.checkAdmin();
                session.checkDDLWrite();
                if (property == "sql.enforce_names") {
                    session.database.setStrictNames(mode);
                } else if (property == "sql.enforce_size") {
                    session.database.setStrictColumnSize(mode);
                } else if (property == "sql.enforce_types") {
                    session.database.setStrictTypes(mode);
                } else if (property == "sql.enforce_refs") {
                    session.database.setStrictReferences(mode);
                } else if (property == "sql.enforce_tdc_delete") {
                    session.database.setStrictTDCD(mode);
                } else if (property == "sql.enforce_tdc_update") {
                    session.database.setStrictTDCU(mode);
                } else if (property == "jdbc.translate_tti_types") {
                    session.database.setTranslateTTI(mode);
                } else if (property == "sql.concat_nulls") {
                    session.database.setConcatNulls(mode);
                } else if (property == "sql.unique_nulls") {
                    session.database.setUniqueNulls(mode);
                } else if (property == "sql.convert_trunc") {
                    session.database.setConvertTrunc(mode);
                } else if (property == "sql.double_nan") {
                    session.database.setDoubleNaN(mode);
                } else if (property == "sql.longvar_is_lob") {
                    session.database.setLongVarIsLob(mode);
                } else if (property == "sql.syntax_ora") {
                    session.database.setSyntaxOra(mode);
                } else if (property == "sql.syntax_mss") {
                    session.database.setSyntaxMss(mode);
                } else if (property == "sql.syntax_mys") {
                    session.database.setSyntaxMys(mode);
                } else if (property == "sql.syntax_pgs") {
                    session.database.setSyntaxPgs(mode);
                }
                return Result.updateZeroResult;
            }
            case 1031: {
                HsqlNameManager.HsqlName schema = (HsqlNameManager.HsqlName)this.parameters[0];
                session.checkAdmin();
                session.checkDDLWrite();
                session.database.schemaManager.setDefaultSchemaHsqlName(schema);
                session.database.schemaManager.setSchemaChangeTimestamp();
                return Result.updateZeroResult;
            }
            case 1032: {
                Integer type = (Integer)this.parameters[0];
                session.checkAdmin();
                session.checkDDLWrite();
                session.database.schemaManager.setDefaultTableType(type);
                return Result.updateZeroResult;
            }
            case 1049: {
                try {
                    int mode = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.database.txManager.setTransactionControl(session, mode);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1050: {
                try {
                    int mode = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.database.defaultIsolationLevel = mode;
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1051: {
                try {
                    boolean mode = (Boolean)this.parameters[0];
                    session.checkAdmin();
                    session.database.defaultDeadlockRollback = mode;
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1034: {
                try {
                    int count = (Integer)this.parameters[0];
                    session.checkAdmin();
                    JavaSystem.gcFrequency = count;
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1035: {
                try {
                    String property = (String)this.parameters[0];
                    Object value = this.parameters[1];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1040: {
                int size = (Integer)this.parameters[0];
                session.checkAdmin();
                session.database.getProperties().setProperty("hsqldb.result_max_memory_rows", size);
                session.database.setResultMaxMemoryRows(size);
                return Result.updateZeroResult;
            }
            case 1048: {
                try {
                    String source = (String)this.parameters[0];
                    HsqlProperties props = null;
                    session.checkAdmin();
                    if (source.length() > 0 && (props = HsqlProperties.delimitedArgPairsToProps(source, "=", ";", null)).getErrorKeys().length > 0) {
                        throw Error.error(482, props.getErrorKeys()[0]);
                    }
                    session.database.logger.setDefaultTextTableProperties(source, props);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1052: {
                try {
                    String name = (String)this.parameters[0];
                    session.checkAdmin();
                    session.database.setUniqueName(name);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1004: {
                ScriptWriterText dsw = null;
                String name = (String)this.parameters[0];
                try {
                    session.checkAdmin();
                    if (name == null) {
                        return session.database.getScript(false);
                    }
                    dsw = new ScriptWriterText(session.database, name, true, true, true);
                    dsw.writeAll();
                    dsw.close();
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1003: {
                try {
                    int mode = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.database.close(mode);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1198: {
                try {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.parameters[0];
                    int[] colIndex = (int[])this.parameters[1];
                    Table table = session.database.schemaManager.getTable(session, name.name, name.schema.name);
                    StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    if (!table.isCached() && !table.isText()) {
                        throw Error.error(457);
                    }
                    Index index = table.getIndexForColumns(session, colIndex);
                    if (index != null) {
                        Index[] indexes = table.getIndexList();
                        for (int i = 0; i < indexes.length; ++i) {
                            indexes[i].setClustered(false);
                        }
                        index.setClustered(true);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1193: {
                try {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.parameters[0];
                    String value = (String)this.parameters[1];
                    Table table = session.database.schemaManager.getTable(session, name.name, name.schema.name);
                    if (session.isProcessingScript()) {
                        table.setIndexRoots(session, value);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1194: {
                try {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.parameters[0];
                    Table table = session.database.schemaManager.getTable(session, name.name, name.schema.name);
                    boolean mode = (Boolean)this.parameters[1];
                    StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    table.setDataReadOnly(mode);
                    session.database.schemaManager.setSchemaChangeTimestamp();
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1195: 
            case 1196: {
                try {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.parameters[0];
                    Table table = session.database.schemaManager.getTable(session, name.name, name.schema.name);
                    StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    if (!table.isText()) {
                        HsqlException e = Error.error(321);
                        return Result.newErrorResult(e, this.sql);
                    }
                    if (this.parameters[1] != null) {
                        boolean mode = (Boolean)this.parameters[1];
                        if (mode) {
                            ((TextTable)table).connect(session);
                        } else {
                            ((TextTable)table).disconnect();
                        }
                        session.database.schemaManager.setSchemaChangeTimestamp();
                        return Result.updateZeroResult;
                    }
                    String source = (String)this.parameters[2];
                    boolean isDesc = (Boolean)this.parameters[3];
                    boolean isHeader = (Boolean)this.parameters[4];
                    if (isHeader) {
                        ((TextTable)table).setHeader(source);
                    } else {
                        ((TextTable)table).setDataSource(session, source, isDesc, false);
                    }
                    return Result.updateZeroResult;
                }
                catch (Throwable e2) {
                    HsqlException e2;
                    if (!(e2 instanceof HsqlException)) {
                        e2 = Error.error(467, e2.toString());
                    }
                    if (session.isProcessingLog() || session.isProcessingScript()) {
                        session.addWarning(e2);
                        session.database.logger.logWarningEvent("Problem processing SET TABLE SOURCE", e2);
                        return Result.updateZeroResult;
                    }
                    return Result.newErrorResult(e2, this.sql);
                }
            }
            case 1197: {
                try {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.parameters[0];
                    int type = (Integer)this.parameters[1];
                    Table table = session.database.schemaManager.getUserTable(session, name.name, name.schema.name);
                    if (name.schema != SqlInvariants.LOBS_SCHEMA_HSQLNAME) {
                        StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    }
                    session.setScripting(true);
                    TableWorks tw = new TableWorks(session, table);
                    tw.setTableType(session, type);
                    session.database.schemaManager.setSchemaChangeTimestamp();
                    if (name.schema == SqlInvariants.LOBS_SCHEMA_HSQLNAME) {
                        session.database.lobManager.compileStatements();
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1060: {
                User user = (User)this.parameters[0];
                boolean mode = (Boolean)this.parameters[1];
                session.checkAdmin();
                session.checkDDLWrite();
                user.isLocalOnly = mode;
                session.database.schemaManager.setSchemaChangeTimestamp();
                return Result.updateZeroResult;
            }
            case 1061: {
                try {
                    User user = (User)this.parameters[0];
                    HsqlNameManager.HsqlName schema = (HsqlNameManager.HsqlName)this.parameters[1];
                    session.checkDDLWrite();
                    if (user == null) {
                        user = session.getUser();
                    } else {
                        session.checkAdmin();
                        session.checkDDLWrite();
                        user = session.database.userManager.get(user.getName().getNameString());
                    }
                    if (schema != null) {
                        schema = session.database.schemaManager.getSchemaHsqlName(schema.name);
                    }
                    user.setInitialSchema(schema);
                    session.database.schemaManager.setSchemaChangeTimestamp();
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1062: {
                try {
                    User user = this.parameters[0] == null ? session.getUser() : (User)this.parameters[0];
                    String password = (String)this.parameters[1];
                    session.checkDDLWrite();
                    session.setScripting(true);
                    session.database.userManager.setPassword(session, user, password);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1005: {
                try {
                    long sessionID = ((Number)this.parameters[0]).longValue();
                    int action = ((Number)this.parameters[1]).intValue();
                    Session targetSession = session.database.sessionManager.getSession(sessionID);
                    if (targetSession == null) {
                        throw Error.error(4500);
                    }
                    switch (action) {
                        case 2: {
                            targetSession.resetSession();
                            break;
                        }
                        case 278: {
                            targetSession.sessionData.persistentStoreCollection.clearAllTables();
                            break;
                        }
                        case 236: {
                            targetSession.sessionData.closeAllNavigators();
                            break;
                        }
                        case 39: {
                            targetSession.abortTransaction = true;
                            targetSession.latch.setCount(0);
                            targetSession.close();
                            break;
                        }
                        case 233: {
                            targetSession.abortTransaction = true;
                            targetSession.latch.setCount(0);
                        }
                    }
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
                return Result.updateZeroResult;
            }
        }
        throw Error.runtimeError(201, "StatemntCommand");
    }

    public boolean isAutoCommitStatement() {
        return this.isTransactionStatement;
    }

    public String describe(Session session) {
        return this.sql;
    }
}

