/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.serializers;

import com.netflix.astyanax.model.Composite;
import com.netflix.astyanax.serializers.AbstractSerializer;
import com.netflix.astyanax.serializers.ComparatorType;
import java.nio.ByteBuffer;
import java.util.List;

public class CompositeSerializer
extends AbstractSerializer<Composite> {
    private static final CompositeSerializer instance = new CompositeSerializer();

    public static CompositeSerializer get() {
        return instance;
    }

    @Override
    public ByteBuffer toByteBuffer(Composite obj) {
        return obj.serialize();
    }

    @Override
    public Composite fromByteBuffer(ByteBuffer byteBuffer) {
        Composite composite = new Composite();
        composite.setComparatorsByPosition(this.getComparators());
        composite.deserialize(byteBuffer);
        return composite;
    }

    @Override
    public ByteBuffer getNext(ByteBuffer byteBuffer) {
        throw new IllegalStateException("Composite columns can't be paginated this way.  Use SpecificCompositeSerializer instead.");
    }

    @Override
    public ComparatorType getComparatorType() {
        return ComparatorType.COMPOSITETYPE;
    }

    public List<String> getComparators() {
        return null;
    }
}

