/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.NoSuchResourceActionException;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UniqueList;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentType;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.PasswordPolicy;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.ResourceAction;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.RoleConstants;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.permission.ResourceActions;
import com.liferay.portal.service.GroupServiceUtil;
import com.liferay.portal.service.PortletLocalService;
import com.liferay.portal.service.ResourceActionLocalService;
import com.liferay.portal.service.RoleLocalService;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletResourceBundles;
import com.liferay.portlet.expando.model.ExpandoColumn;
import com.liferay.portlet.mobiledevicerules.model.MDRRuleGroup;
import com.liferay.util.JS;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.jsp.PageContext;

@DoPrivileged
public class ResourceActionsImpl
implements ResourceActions {
    @BeanReference(type=PortletLocalService.class)
    protected PortletLocalService portletLocalService;
    @BeanReference(type=ResourceActionLocalService.class)
    protected ResourceActionLocalService resourceActionLocalService;
    @BeanReference(type=RoleLocalService.class)
    protected RoleLocalService roleLocalService;
    private static final String _ACTION_NAME_PREFIX = "action.";
    private static final String _MODEL_RESOURCE_NAME_PREFIX = "model.resource.";
    private static final String[] _ORGANIZATION_MODEL_RESOURCES = new String[]{Organization.class.getName(), PasswordPolicy.class.getName(), User.class.getName()};
    private static final String[] _PORTAL_MODEL_RESOURCES = new String[]{ExpandoColumn.class.getName(), LayoutPrototype.class.getName(), LayoutSetPrototype.class.getName(), MDRRuleGroup.class.getName(), Organization.class.getName(), PasswordPolicy.class.getName(), Role.class.getName(), User.class.getName(), UserGroup.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(ResourceActionsImpl.class);
    private Map<String, Set<String>> _modelPortletResources;
    private Map<String, List<String>> _modelResourceActions;
    private Map<String, List<String>> _modelResourceGroupDefaultActions;
    private Map<String, List<String>> _modelResourceGuestDefaultActions;
    private Map<String, List<String>> _modelResourceGuestUnsupportedActions;
    private Map<String, List<String>> _modelResourceOwnerDefaultActions;
    private Map<String, Double> _modelResourceWeights;
    private Set<String> _organizationModelResources;
    private Set<String> _portalModelResources;
    private Map<String, Set<String>> _portletModelResources;
    private Map<String, List<String>> _portletResourceActions;
    private Map<String, List<String>> _portletResourceGroupDefaultActions;
    private Map<String, List<String>> _portletResourceGuestDefaultActions;
    private Map<String, List<String>> _portletResourceGuestUnsupportedActions;
    private Map<String, List<String>> _portletResourceLayoutManagerActions;
    private Map<String, String> _portletRootModelResource;

    public void afterPropertiesSet() {
        String resource;
        this._organizationModelResources = new HashSet<String>();
        String[] stringArray = this.getOrganizationModelResources();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            resource = stringArray[n2];
            this._organizationModelResources.add(resource);
            ++n2;
        }
        this._portalModelResources = new HashSet<String>();
        stringArray = this.getPortalModelResources();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            resource = stringArray[n2];
            this._portalModelResources.add(resource);
            ++n2;
        }
        this._portletModelResources = new HashMap<String, Set<String>>();
        this._portletResourceActions = new HashMap<String, List<String>>();
        this._portletResourceGroupDefaultActions = new HashMap<String, List<String>>();
        this._portletResourceGuestDefaultActions = new HashMap<String, List<String>>();
        this._portletResourceGuestUnsupportedActions = new HashMap<String, List<String>>();
        this._portletResourceLayoutManagerActions = new HashMap<String, List<String>>();
        this._portletRootModelResource = new HashMap<String, String>();
        this._modelPortletResources = new HashMap<String, Set<String>>();
        this._modelResourceActions = new HashMap<String, List<String>>();
        this._modelResourceGroupDefaultActions = new HashMap<String, List<String>>();
        this._modelResourceGuestDefaultActions = new HashMap<String, List<String>>();
        this._modelResourceGuestUnsupportedActions = new HashMap<String, List<String>>();
        this._modelResourceOwnerDefaultActions = new HashMap<String, List<String>>();
        this._modelResourceWeights = new HashMap<String, Double>();
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            String[] stringArray2 = PropsValues.RESOURCE_ACTIONS_CONFIGS;
            int n3 = PropsValues.RESOURCE_ACTIONS_CONFIGS.length;
            n = 0;
            while (n < n3) {
                String config = stringArray2[n];
                this.read(null, classLoader, config);
                ++n;
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void checkAction(String name, String actionId) throws NoSuchResourceActionException {
        List<String> resourceActions = this.getResourceActions(name);
        if (!resourceActions.contains(actionId)) {
            throw new NoSuchResourceActionException(name.concat("#").concat(actionId));
        }
    }

    public String getAction(Locale locale, String action) {
        String key = String.valueOf(this.getActionNamePrefix()) + action;
        String value = LanguageUtil.get((Locale)locale, (String)key, null);
        if (value == null || value.equals(key)) {
            value = PortletResourceBundles.getString(locale, key);
        }
        if (value == null) {
            value = key;
        }
        return value;
    }

    public String getAction(PageContext pageContext, String action) {
        String key = String.valueOf(this.getActionNamePrefix()) + action;
        String value = LanguageUtil.get((PageContext)pageContext, (String)key, null);
        if (value == null || value.equals(key)) {
            value = PortletResourceBundles.getString(pageContext, key);
        }
        if (value == null) {
            value = key;
        }
        return value;
    }

    public String getActionNamePrefix() {
        return _ACTION_NAME_PREFIX;
    }

    public List<String> getActionsNames(PageContext pageContext, List<String> actions) {
        UniqueList actionNames = new UniqueList();
        for (String action : actions) {
            actionNames.add(this.getAction(pageContext, action));
        }
        return actionNames;
    }

    public List<String> getActionsNames(PageContext pageContext, String name, long actionIds) {
        try {
            List resourceActions = this.resourceActionLocalService.getResourceActions(name);
            ArrayList<String> actions = new ArrayList<String>();
            for (ResourceAction resourceAction : resourceActions) {
                long bitwiseValue = resourceAction.getBitwiseValue();
                if ((actionIds & bitwiseValue) != bitwiseValue) continue;
                actions.add(resourceAction.getActionId());
            }
            return this.getActionsNames(pageContext, actions);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            return Collections.emptyList();
        }
    }

    public List<String> getModelNames() {
        return ListUtil.fromMapKeys(this._modelPortletResources);
    }

    public List<String> getModelPortletResources(String name) {
        Set<String> resources = this._modelPortletResources.get(name);
        if (resources == null) {
            return new UniqueList();
        }
        return Collections.list(Collections.enumeration(resources));
    }

    public String getModelResource(Locale locale, String name) {
        String key = String.valueOf(this.getModelResourceNamePrefix()) + name;
        String value = LanguageUtil.get((Locale)locale, (String)key, null);
        if (value == null || value.equals(key)) {
            value = PortletResourceBundles.getString(locale, key);
        }
        if (value == null) {
            value = key;
        }
        return value;
    }

    public String getModelResource(PageContext pageContext, String name) {
        String key = String.valueOf(this.getModelResourceNamePrefix()) + name;
        String value = LanguageUtil.get((PageContext)pageContext, (String)key, null);
        if (value == null || value.equals(key)) {
            value = PortletResourceBundles.getString(pageContext, key);
        }
        if (value == null) {
            value = key;
        }
        return value;
    }

    public List<String> getModelResourceActions(String name) {
        return this.getActions(this._modelResourceActions, name);
    }

    public List<String> getModelResourceGroupDefaultActions(String name) {
        return this.getActions(this._modelResourceGroupDefaultActions, name);
    }

    public List<String> getModelResourceGuestDefaultActions(String name) {
        return this.getActions(this._modelResourceGuestDefaultActions, name);
    }

    public List<String> getModelResourceGuestUnsupportedActions(String name) {
        return this.getActions(this._modelResourceGuestUnsupportedActions, name);
    }

    public String getModelResourceNamePrefix() {
        return _MODEL_RESOURCE_NAME_PREFIX;
    }

    public List<String> getModelResourceOwnerDefaultActions(String name) {
        return this.getActions(this._modelResourceOwnerDefaultActions, name);
    }

    public Double getModelResourceWeight(String name) {
        return this._modelResourceWeights.get(name);
    }

    public String[] getOrganizationModelResources() {
        return _ORGANIZATION_MODEL_RESOURCES;
    }

    public String[] getPortalModelResources() {
        return _PORTAL_MODEL_RESOURCES;
    }

    public String getPortletBaseResource(String portletName) {
        List<String> modelNames = this.getPortletModelResources(portletName);
        for (String modelName : modelNames) {
            if (modelName.contains(".model.")) continue;
            return modelName;
        }
        return null;
    }

    public List<String> getPortletModelResources(String portletName) {
        Set<String> resources = this._portletModelResources.get(portletName = PortletConstants.getRootPortletId((String)portletName));
        if (resources == null) {
            return new UniqueList();
        }
        return Collections.list(Collections.enumeration(resources));
    }

    public List<String> getPortletNames() {
        return ListUtil.fromMapKeys(this._portletModelResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPortletResourceActions(Portlet portlet) {
        List actions = ListUtil.copy(this.getPortletResourceActions(portlet.getPortletId()));
        ResourceActionsImpl resourceActionsImpl = this;
        synchronized (resourceActionsImpl) {
            this.checkPortletActions(portlet, (List<String>)actions);
            this.setActions(this._portletResourceActions, portlet.getPortletId(), actions);
        }
        return actions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPortletResourceActions(String name) {
        List<String> actions = this.getActions(this._portletResourceActions, name = PortletConstants.getRootPortletId((String)name));
        if (!actions.isEmpty()) {
            return actions;
        }
        ResourceActionsImpl resourceActionsImpl = this;
        synchronized (resourceActionsImpl) {
            UniqueList layoutManagerActions;
            UniqueList guestDefaultActions;
            UniqueList groupDefaultActions;
            actions = this.getPortletMimeTypeActions(name);
            if (!name.equals("90")) {
                this.checkPortletActions(name, actions);
            }
            if ((groupDefaultActions = this._portletResourceGroupDefaultActions.get(name)) == null) {
                groupDefaultActions = new UniqueList();
                this.checkPortletGroupDefaultActions((List<String>)groupDefaultActions);
                this._portletResourceGroupDefaultActions.put(name, (List<String>)new UnmodifiableList((List)groupDefaultActions));
            }
            if ((guestDefaultActions = this._portletResourceGuestDefaultActions.get(name)) == null) {
                guestDefaultActions = new UniqueList();
                this.checkPortletGuestDefaultActions((List<String>)guestDefaultActions);
                this._portletResourceGuestDefaultActions.put(name, (List<String>)new UnmodifiableList((List)guestDefaultActions));
            }
            if ((layoutManagerActions = this._portletResourceLayoutManagerActions.get(name)) == null) {
                layoutManagerActions = new UniqueList();
                this.checkPortletLayoutManagerActions((List<String>)layoutManagerActions);
                this._portletResourceLayoutManagerActions.put(name, (List<String>)new UnmodifiableList((List)layoutManagerActions));
            }
            actions = this.setActions(this._portletResourceActions, name, actions);
        }
        return actions;
    }

    public List<String> getPortletResourceGroupDefaultActions(String name) {
        name = PortletConstants.getRootPortletId((String)name);
        return this.getActions(this._portletResourceGroupDefaultActions, name);
    }

    public List<String> getPortletResourceGuestDefaultActions(String name) {
        name = PortletConstants.getRootPortletId((String)name);
        return this.getActions(this._portletResourceGuestDefaultActions, name);
    }

    public List<String> getPortletResourceGuestUnsupportedActions(String name) {
        UniqueList actions = this.getActions(this._portletResourceGuestUnsupportedActions, name = PortletConstants.getRootPortletId((String)name));
        if (actions.contains("CONFIGURATION") && actions.contains("PERMISSIONS")) {
            return actions;
        }
        actions = new UniqueList(actions);
        actions.add("CONFIGURATION");
        actions.add("PERMISSIONS");
        this.setActions(this._portletResourceGuestUnsupportedActions, name, (List<String>)actions);
        return actions;
    }

    public List<String> getPortletResourceLayoutManagerActions(String name) {
        UniqueList actions = this.getActions(this._portletResourceLayoutManagerActions, name = PortletConstants.getRootPortletId((String)name));
        if (actions.isEmpty()) {
            actions = new UniqueList();
            actions.add("CONFIGURATION");
            actions.add("PREFERENCES");
            actions.add("VIEW");
            this.setActions(this._portletResourceLayoutManagerActions, name, (List<String>)actions);
        }
        return actions;
    }

    public String getPortletRootModelResource(String portletName) {
        portletName = PortletConstants.getRootPortletId((String)portletName);
        return this._portletRootModelResource.get(portletName);
    }

    public List<String> getResourceActions(String name) {
        if (name.indexOf(46) != -1) {
            return this.getModelResourceActions(name);
        }
        return this.getPortletResourceActions(name);
    }

    public List<String> getResourceActions(String portletResource, String modelResource) {
        List<String> actions = null;
        actions = Validator.isNull((String)modelResource) ? this.getPortletResourceActions(portletResource) : this.getModelResourceActions(modelResource);
        return actions;
    }

    public List<String> getResourceGroupDefaultActions(String name) {
        if (name.contains(".")) {
            return this.getModelResourceGroupDefaultActions(name);
        }
        return this.getPortletResourceGroupDefaultActions(name);
    }

    public List<String> getResourceGuestUnsupportedActions(String portletResource, String modelResource) {
        List<String> actions = null;
        actions = Validator.isNull((String)modelResource) ? this.getPortletResourceGuestUnsupportedActions(portletResource) : this.getModelResourceGuestUnsupportedActions(modelResource);
        return actions;
    }

    public List<Role> getRoles(long companyId, Group group, String modelResource) throws SystemException {
        return this.getRoles(companyId, group, modelResource, null);
    }

    public List<Role> getRoles(long companyId, Group group, String modelResource, int[] roleTypes) throws SystemException {
        if (roleTypes == null) {
            roleTypes = this.getRoleTypes(companyId, group, modelResource);
        }
        return this.roleLocalService.getRoles(companyId, roleTypes);
    }

    public boolean hasModelResourceActions(String name) {
        List<String> actions = this._modelResourceActions.get(name);
        return actions != null && !actions.isEmpty();
    }

    public boolean isOrganizationModelResource(String modelResource) {
        return this._organizationModelResources.contains(modelResource);
    }

    public boolean isPortalModelResource(String modelResource) {
        return this._portalModelResources.contains(modelResource);
    }

    public void read(String servletContextName, ClassLoader classLoader, String source) throws Exception {
        Document document;
        DocumentType documentType;
        String publicId;
        InputStream inputStream = classLoader.getResourceAsStream(source);
        if (inputStream == null) {
            if (_log.isWarnEnabled() && !source.endsWith("-ext.xml")) {
                _log.warn((Object)("Cannot load " + source));
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Loading " + source));
        }
        if ((publicId = GetterUtil.getString((String)(documentType = (document = UnsecureSAXReaderUtil.read((InputStream)inputStream, (boolean)true)).getDocumentType()).getPublicId())).equals("-//Liferay//DTD Resource Action Mapping 6.0.0//EN") && _log.isWarnEnabled()) {
            _log.warn((Object)("Please update " + source + " to use the 6.1.0 format"));
        }
        Element rootElement = document.getRootElement();
        for (Element resourceElement : rootElement.elements("resource")) {
            String file = resourceElement.attributeValue("file").trim();
            this.read(servletContextName, classLoader, file);
            String extFile = StringUtil.replace((String)file, (String)".xml", (String)"-ext.xml");
            this.read(servletContextName, classLoader, extFile);
        }
        this.read(servletContextName, document);
    }

    public void read(String servletContextName, InputStream inputStream) throws Exception {
        Document document = UnsecureSAXReaderUtil.read((InputStream)inputStream, (boolean)true);
        this.read(servletContextName, document);
    }

    protected void checkGuestUnsupportedActions(List<String> guestUnsupportedActions, List<String> guestDefaultActions) {
        Iterator<String> itr = guestDefaultActions.iterator();
        while (itr.hasNext()) {
            String actionId = itr.next();
            if (!guestUnsupportedActions.contains(actionId)) continue;
            itr.remove();
        }
    }

    protected void checkModelActions(List<String> actions) {
        if (!actions.contains("PERMISSIONS")) {
            actions.add("PERMISSIONS");
        }
    }

    protected void checkPortletActions(Portlet portlet, List<String> actions) {
        this.checkPortletLayoutManagerActions(actions);
        if (portlet != null && portlet.getControlPanelEntryCategory() != null && !actions.contains("ACCESS_IN_CONTROL_PANEL")) {
            actions.add("ACCESS_IN_CONTROL_PANEL");
        }
    }

    protected void checkPortletActions(String name, List<String> actions) {
        Portlet portlet = this.portletLocalService.getPortletById(name);
        this.checkPortletActions(portlet, actions);
    }

    protected void checkPortletGroupDefaultActions(List<String> actions) {
        if (actions.isEmpty()) {
            actions.add("VIEW");
        }
    }

    protected void checkPortletGuestDefaultActions(List<String> actions) {
        if (actions.isEmpty()) {
            actions.add("VIEW");
        }
    }

    protected void checkPortletLayoutManagerActions(List<String> actions) {
        if (!actions.contains("ACCESS_IN_CONTROL_PANEL") && !actions.contains("ADD_TO_PAGE")) {
            actions.add("ADD_TO_PAGE");
        }
        if (!actions.contains("CONFIGURATION")) {
            actions.add("CONFIGURATION");
        }
        if (!actions.contains("PERMISSIONS")) {
            actions.add("PERMISSIONS");
        }
        if (!actions.contains("PREFERENCES")) {
            actions.add("PREFERENCES");
        }
        if (!actions.contains("VIEW")) {
            actions.add("VIEW");
        }
    }

    protected List<String> getActions(Map<String, List<String>> actionsMap, String name) {
        UniqueList actions = actionsMap.get(name);
        if (actions == null) {
            actions = new UniqueList();
            actionsMap.put(name, (List<String>)actions);
        }
        return actions;
    }

    protected Element getPermissionsChildElement(Element parentElement, String childElementName) {
        Element permissionsElement = parentElement.element("permissions");
        if (permissionsElement != null) {
            return permissionsElement.element(childElementName);
        }
        return parentElement.element(childElementName);
    }

    protected List<String> getPortletMimeTypeActions(String name) {
        UniqueList actions = new UniqueList();
        Portlet portlet = this.portletLocalService.getPortletById(name);
        if (portlet != null) {
            Map portletModes = portlet.getPortletModes();
            Set mimeTypePortletModes = (Set)portletModes.get("text/html");
            if (mimeTypePortletModes != null) {
                for (String actionId : mimeTypePortletModes) {
                    if (StringUtil.equalsIgnoreCase((String)actionId, (String)"edit")) {
                        actions.add("PREFERENCES");
                        continue;
                    }
                    if (StringUtil.equalsIgnoreCase((String)actionId, (String)"edit_guest")) {
                        actions.add("GUEST_PREFERENCES");
                        continue;
                    }
                    actions.add(StringUtil.toUpperCase((String)actionId));
                }
            }
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)("Unable to obtain resource actions for unknown portlet " + name));
        }
        return actions;
    }

    protected int[] getRoleTypes(long companyId, Group group, String modelResource) {
        int[] types = RoleConstants.TYPES_REGULAR_AND_SITE;
        if (this.isPortalModelResource(modelResource)) {
            types = modelResource.equals(Organization.class.getName()) || modelResource.equals(User.class.getName()) ? RoleConstants.TYPES_ORGANIZATION_AND_REGULAR : RoleConstants.TYPES_REGULAR;
        } else if (group != null) {
            if (group.isLayout()) {
                try {
                    group = GroupServiceUtil.getGroup((long)group.getParentGroupId());
                }
                catch (Exception exception) {}
            }
            if (group.isOrganization()) {
                types = RoleConstants.TYPES_ORGANIZATION_AND_REGULAR_AND_SITE;
            } else if (group.isUser()) {
                types = RoleConstants.TYPES_REGULAR;
            }
        }
        return types;
    }

    protected void read(String servletContextName, Document document) throws Exception {
        Element rootElement = document.getRootElement();
        if (PropsValues.RESOURCE_ACTIONS_READ_PORTLET_RESOURCES) {
            for (Element portletResourceElement : rootElement.elements("portlet-resource")) {
                this.readPortletResource(servletContextName, portletResourceElement);
            }
        }
        for (Element modelResourceElement : rootElement.elements("model-resource")) {
            this.readModelResource(servletContextName, modelResourceElement);
        }
    }

    protected List<String> readActionKeys(Element parentElement) {
        ArrayList<String> actions = new ArrayList<String>();
        for (Element actionKeyElement : parentElement.elements("action-key")) {
            String actionKey = actionKeyElement.getTextTrim();
            if (Validator.isNull((String)actionKey)) continue;
            actions.add(actionKey);
        }
        return actions;
    }

    protected void readGroupDefaultActions(Element parentElement, Map<String, List<String>> actionsMap, String name) {
        UniqueList groupDefaultActions = new UniqueList(this.getActions(actionsMap, name));
        Element groupDefaultsElement = this.getPermissionsChildElement(parentElement, "site-member-defaults");
        if (groupDefaultsElement == null) {
            groupDefaultsElement = this.getPermissionsChildElement(parentElement, "community-defaults");
            if (_log.isWarnEnabled() && groupDefaultsElement != null) {
                _log.warn((Object)"The community-defaults element is deprecated. Use the site-member-defaults element instead.");
            }
        }
        groupDefaultActions.addAll(this.readActionKeys(groupDefaultsElement));
        this.setActions(actionsMap, name, (List<String>)groupDefaultActions);
    }

    protected List<String> readGuestDefaultActions(Element parentElement, Map<String, List<String>> actionsMap, String name) {
        UniqueList guestDefaultActions = new UniqueList(this.getActions(actionsMap, name));
        Element guestDefaultsElement = this.getPermissionsChildElement(parentElement, "guest-defaults");
        guestDefaultActions.addAll(this.readActionKeys(guestDefaultsElement));
        return guestDefaultActions;
    }

    protected void readGuestUnsupportedActions(Element parentElement, Map<String, List<String>> actionsMap, String name, List<String> guestDefaultActions) {
        UniqueList guestUnsupportedActions = new UniqueList(this.getActions(actionsMap, name));
        Element guestUnsupportedElement = this.getPermissionsChildElement(parentElement, "guest-unsupported");
        guestUnsupportedActions.addAll(this.readActionKeys(guestUnsupportedElement));
        this.checkGuestUnsupportedActions((List<String>)guestUnsupportedActions, guestDefaultActions);
        this.setActions(actionsMap, name, (List<String>)guestUnsupportedActions);
    }

    protected void readLayoutManagerActions(Element parentElement, Map<String, List<String>> actionsMap, String name, List<String> supportsActions) {
        UniqueList layoutManagerActions = new UniqueList(this.getActions(actionsMap, name));
        Element layoutManagerElement = this.getPermissionsChildElement(parentElement, "layout-manager");
        if (layoutManagerElement != null) {
            layoutManagerActions.addAll(this.readActionKeys(layoutManagerElement));
        } else {
            layoutManagerActions.addAll(supportsActions);
        }
        this.setActions(actionsMap, name, (List<String>)layoutManagerActions);
    }

    protected void readModelResource(String servletContextName, Element modelResourceElement) {
        String name = modelResourceElement.elementTextTrim("model-name");
        Element portletRefElement = modelResourceElement.element("portlet-ref");
        for (Element portletNameElement : portletRefElement.elements("portlet-name")) {
            Set<String> modelResources;
            String portletName = portletNameElement.getTextTrim();
            if (servletContextName != null) {
                portletName = portletName.concat("_WAR_").concat(servletContextName);
            }
            if ((modelResources = this._portletModelResources.get(portletName = JS.getSafeName((String)portletName))) == null) {
                modelResources = new HashSet<String>();
                this._portletModelResources.put(portletName, modelResources);
            }
            modelResources.add(name);
            Set<String> portletResources = this._modelPortletResources.get(name);
            if (portletResources == null) {
                portletResources = new HashSet<String>();
                this._modelPortletResources.put(name, portletResources);
            }
            portletResources.add(portletName);
            boolean root = GetterUtil.getBoolean((String)modelResourceElement.elementText("root"));
            if (!root) continue;
            this._portletRootModelResource.put(portletName, name);
        }
        double weight = GetterUtil.getDouble((String)modelResourceElement.elementTextTrim("weight"), (double)100.0);
        this._modelResourceWeights.put(name, weight);
        List<String> supportsActions = this.readSupportsActions(modelResourceElement, this._modelResourceActions, name);
        this.checkModelActions(supportsActions);
        this.setActions(this._modelResourceActions, name, supportsActions);
        this.readGroupDefaultActions(modelResourceElement, this._modelResourceGroupDefaultActions, name);
        List<String> guestDefaultActions = this.readGuestDefaultActions(modelResourceElement, this._modelResourceGuestDefaultActions, name);
        this.readGuestUnsupportedActions(modelResourceElement, this._modelResourceGuestUnsupportedActions, name, guestDefaultActions);
        this.setActions(this._modelResourceGuestDefaultActions, name, guestDefaultActions);
        this.readOwnerDefaultActions(modelResourceElement, this._modelResourceOwnerDefaultActions, name);
    }

    protected void readOwnerDefaultActions(Element parentElement, Map<String, List<String>> actionsMap, String name) {
        UniqueList ownerDefaultActions = new UniqueList(this.getActions(actionsMap, name));
        Element ownerDefaultsElement = this.getPermissionsChildElement(parentElement, "owner-defaults");
        if (ownerDefaultsElement == null) {
            return;
        }
        ownerDefaultActions.addAll(this.readActionKeys(ownerDefaultsElement));
        this.setActions(actionsMap, name, (List<String>)ownerDefaultActions);
    }

    protected void readPortletResource(String servletContextName, Element portletResourceElement) {
        String name = portletResourceElement.elementTextTrim("portlet-name");
        if (servletContextName != null) {
            name = name.concat("_WAR_").concat(servletContextName);
        }
        name = JS.getSafeName((String)name);
        List<String> supportsActions = this.readSupportsActions(portletResourceElement, this._portletResourceActions, name);
        supportsActions.addAll(this.getPortletMimeTypeActions(name));
        if (!name.equals("90")) {
            this.checkPortletActions(name, supportsActions);
        }
        supportsActions = this.setActions(this._portletResourceActions, name, supportsActions);
        this.readGroupDefaultActions(portletResourceElement, this._portletResourceGroupDefaultActions, name);
        List<String> guestDefaultActions = this.readGuestDefaultActions(portletResourceElement, this._portletResourceGuestDefaultActions, name);
        this.readGuestUnsupportedActions(portletResourceElement, this._portletResourceGuestUnsupportedActions, name, guestDefaultActions);
        this.setActions(this._portletResourceGuestDefaultActions, name, guestDefaultActions);
        this.readLayoutManagerActions(portletResourceElement, this._portletResourceLayoutManagerActions, name, supportsActions);
    }

    protected List<String> readSupportsActions(Element parentElement, Map<String, List<String>> actionsMap, String name) {
        UniqueList supportsActions = new UniqueList(this.getActions(actionsMap, name));
        Element supportsElement = this.getPermissionsChildElement(parentElement, "supports");
        supportsActions.addAll(this.readActionKeys(supportsElement));
        return supportsActions;
    }

    protected List<String> setActions(Map<String, List<String>> actionsMap, String name, List<String> actions) {
        actions = new UnmodifiableList(actions);
        actionsMap.put(name, (List<String>)actions);
        return actions;
    }
}

