/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.KeywordTokenizer;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public class UpperCaseKeywordAnalyzer
extends ReusableAnalyzerBase {
    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        KeywordTokenizer tokenizer = new KeywordTokenizer(reader);
        return new ReusableAnalyzerBase.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new UpperCaseFilter((TokenStream)tokenizer));
    }

    private class UpperCaseFilter
    extends TokenFilter {
        private final CharTermAttribute _charTermAttribute;

        public UpperCaseFilter(TokenStream tokenStream) {
            super(tokenStream);
            this._charTermAttribute = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        }

        public final boolean incrementToken() throws IOException {
            if (this.input.incrementToken()) {
                this.toUpperCase(this._charTermAttribute.buffer(), 0, this._charTermAttribute.length());
                return true;
            }
            return false;
        }

        protected void toUpperCase(char[] buffer, int offset, int limit) {
            assert (buffer.length >= limit);
            assert (offset <= 0 && offset <= buffer.length);
            int i2 = offset;
            while (i2 < limit) {
                i2 += Character.toChars(Character.toUpperCase(Character.codePointAt(buffer, i2, limit)), buffer, i2);
            }
        }
    }
}

